/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service.persistence.impl;

import com.liferay.portal.kernel.internal.service.persistence.TableMapperImpl;
import com.liferay.portal.kernel.internal.service.persistence.change.tracking.CTTableMapper;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.service.persistence.impl.TableMapper;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TableMapperFactory {
    private static final Set<String> _cachelessMappingTableNames = SetUtil.fromArray(PropsUtil.getArray("table.mapper.cacheless.mapping.table.names"));
    private static final Map<String, TableMapper<?, ?>> _tableMappers = new ConcurrentHashMap();

    public static <L extends BaseModel<L>, R extends BaseModel<R>> TableMapper<L, R> getTableMapper(String tableName, String companyColumnName, String leftColumnName, String rightColumnName, BasePersistence<L> leftPersistence, BasePersistence<R> rightPersistence) {
        return TableMapperFactory._getTableMapper(tableName, tableName, companyColumnName, leftColumnName, rightColumnName, leftPersistence, rightPersistence);
    }

    public static <L extends BaseModel<L>, R extends BaseModel<R>> TableMapper<L, R> getTableMapper(String tableMapperKey, String tableName, String companyColumnName, String leftColumnName, String rightColumnName, BasePersistence<L> leftPersistence, Class<R> rightModelClass) {
        return TableMapperFactory._getTableMapper(tableMapperKey, tableName, companyColumnName, leftColumnName, rightColumnName, leftPersistence, new RejectingBasePersistenceImpl(rightModelClass));
    }

    public static void removeTableMapper(String tableMapperKey) {
        TableMapper<?, ?> tableMapper = _tableMappers.remove(tableMapperKey);
        if (tableMapper != null) {
            tableMapper.destroy();
        }
    }

    private static <L extends BaseModel<L>, R extends BaseModel<R>> TableMapper<L, R> _getTableMapper(String tableMapperKey, String tableName, String companyColumnName, String leftColumnName, String rightColumnName, BasePersistence<L> leftPersistence, BasePersistence<R> rightPersistence) {
        TableMapperImpl tableMapper = _tableMappers.get(tableMapperKey);
        if (tableMapper == null) {
            Class<L> leftModelClass = leftPersistence.getModelClass();
            Class<R> rightModelClass = rightPersistence.getModelClass();
            tableMapper = CTModel.class.isAssignableFrom(leftModelClass) && CTModel.class.isAssignableFrom(rightModelClass) ? new CTTableMapper(tableName, companyColumnName, leftColumnName, rightColumnName, leftModelClass, rightModelClass, leftPersistence, rightPersistence, _cachelessMappingTableNames.contains(tableName)) : new TableMapperImpl(tableName, companyColumnName, leftColumnName, rightColumnName, leftModelClass, rightModelClass, leftPersistence, rightPersistence, _cachelessMappingTableNames.contains(tableName));
            _tableMappers.put(tableMapperKey, tableMapper);
        } else if (!tableMapper.matches(leftColumnName, rightColumnName)) {
            tableMapper = tableMapper.getReverseTableMapper();
        }
        return tableMapper;
    }

    private static class RejectingBasePersistenceImpl<T extends BaseModel<T>>
    extends BasePersistenceImpl<T> {
        @Override
        public T findByPrimaryKey(Serializable primaryKey) {
            throw new UnsupportedOperationException("The TableMapper only supports BaseModel queries on one side");
        }

        private RejectingBasePersistenceImpl(Class<T> modelClass) {
            this.setModelClass(modelClass);
        }
    }
}

