/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.nio.CharsetEncoderUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.Range;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.RandomAccessInputStream;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletResponseUtil {
    private static final String _CLIENT_ABORT_EXCEPTION = "org.apache.catalina.connector.ClientAbortException";
    private static final int _MAX_RANGE_FIELDS = GetterUtil.getInteger(PropsUtil.get("web.server.servlet.max.range.fields"));
    private static final String _RANGE_REGEX = "^bytes=\\d*-\\d*(,\\s?\\d*-\\d*)*$";
    private static final Log _log = LogFactoryUtil.getLog(ServletResponseUtil.class);

    public static boolean isClientAbortException(IOException ioException) {
        Class<?> clazz = ioException.getClass();
        String className = clazz.getName();
        return className.equals(_CLIENT_ABORT_EXCEPTION);
    }

    public static void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String fileName, byte[] bytes) throws IOException {
        ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, fileName, bytes, null);
    }

    public static void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String fileName, byte[] bytes, String contentType) throws IOException {
        ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, fileName, bytes, contentType, null);
    }

    public static void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String fileName, byte[] bytes, String contentType, String contentDispositionType) throws IOException {
        ServletResponseUtil.setHeaders(httpServletRequest, httpServletResponse, fileName, contentType, contentDispositionType);
        ServletResponseUtil.write(httpServletResponse, bytes);
    }

    public static void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String fileName, InputStream inputStream) throws IOException {
        ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, fileName, inputStream, null);
    }

    public static void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String fileName, InputStream inputStream, long contentLength, String contentType) throws IOException {
        ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, fileName, inputStream, contentLength, contentType, null);
    }

    public static void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String fileName, InputStream inputStream, long contentLength, String contentType, String contentDispositionType) throws IOException {
        ServletResponseUtil.setHeaders(httpServletRequest, httpServletResponse, fileName, contentType, contentDispositionType);
        ServletResponseUtil.write(httpServletResponse, inputStream, contentLength);
    }

    public static void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String fileName, InputStream inputStream, String contentType) throws IOException {
        ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, fileName, inputStream, 0L, contentType);
    }

    public static void sendFileWithRangeHeader(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String fileName, InputStream inputStream, long contentLength, String contentType) throws IOException {
        if (_log.isDebugEnabled()) {
            _log.debug("Accepting ranges for the file " + fileName);
        }
        httpServletResponse.setHeader("Accept-Ranges", "bytes");
        List<Range> ranges = null;
        try {
            ranges = ServletResponseUtil._getRanges(httpServletRequest, contentLength);
        }
        catch (IOException ioException) {
            _log.error("Unable to get ranges", ioException);
            httpServletResponse.setHeader("Content-Range", "bytes */" + contentLength);
            httpServletResponse.sendError(416);
            return;
        }
        if (ranges == null || ranges.isEmpty()) {
            ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, fileName, inputStream, contentLength, contentType);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug("Request has range header " + httpServletRequest.getHeader("Range"));
            }
            ServletResponseUtil._write(httpServletRequest, httpServletResponse, fileName, ranges, inputStream, contentLength, contentType);
        }
    }

    public static void write(HttpServletResponse httpServletResponse, BufferCacheServletResponse bufferCacheServletResponse) throws IOException {
        if (bufferCacheServletResponse.isByteMode()) {
            ServletResponseUtil.write(httpServletResponse, bufferCacheServletResponse.getByteBuffer());
        } else if (bufferCacheServletResponse.isCharMode()) {
            ServletResponseUtil.write(httpServletResponse, bufferCacheServletResponse.getCharBuffer());
        }
    }

    public static void write(HttpServletResponse httpServletResponse, byte[] bytes) throws IOException {
        ServletResponseUtil.write(httpServletResponse, bytes, 0, 0);
    }

    public static void write(HttpServletResponse httpServletResponse, byte[] bytes, int offset, int contentLength) throws IOException {
        try {
            if (!httpServletResponse.isCommitted()) {
                if (contentLength == 0) {
                    contentLength = bytes.length;
                }
                httpServletResponse.setContentLength(contentLength);
                httpServletResponse.flushBuffer();
                if (httpServletResponse instanceof BufferCacheServletResponse) {
                    BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)httpServletResponse;
                    bufferCacheServletResponse.setByteBuffer(ByteBuffer.wrap(bytes, offset, contentLength));
                } else {
                    ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                    servletOutputStream.write(bytes, offset, contentLength);
                }
            }
        }
        catch (IOException ioException) {
            ServletResponseUtil._checkSocketException(ioException);
        }
    }

    public static void write(HttpServletResponse httpServletResponse, byte[][] bytesArray) throws IOException {
        try {
            if (!httpServletResponse.isCommitted()) {
                long contentLength = 0L;
                for (byte[] bytes : bytesArray) {
                    contentLength += (long)bytes.length;
                }
                ServletResponseUtil.setContentLength(httpServletResponse, contentLength);
                httpServletResponse.flushBuffer();
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                for (byte[] bytes : bytesArray) {
                    servletOutputStream.write(bytes);
                }
            }
        }
        catch (IOException ioException) {
            ServletResponseUtil._checkSocketException(ioException);
        }
    }

    public static void write(HttpServletResponse httpServletResponse, ByteBuffer byteBuffer) throws IOException {
        if (httpServletResponse instanceof BufferCacheServletResponse) {
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)httpServletResponse;
            bufferCacheServletResponse.setByteBuffer(byteBuffer);
        } else {
            ServletResponseUtil.write(httpServletResponse, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.arrayOffset() + byteBuffer.limit());
        }
    }

    public static void write(HttpServletResponse httpServletResponse, CharBuffer charBuffer) throws IOException {
        if (httpServletResponse instanceof BufferCacheServletResponse) {
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)httpServletResponse;
            bufferCacheServletResponse.setCharBuffer(charBuffer);
        } else {
            ByteBuffer byteBuffer = CharsetEncoderUtil.encode((String)"UTF-8", (CharBuffer)charBuffer);
            ServletResponseUtil.write(httpServletResponse, byteBuffer);
        }
    }

    public static void write(HttpServletResponse httpServletResponse, File file) throws IOException {
        if (httpServletResponse instanceof BufferCacheServletResponse) {
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)httpServletResponse;
            ByteBuffer byteBuffer = ByteBuffer.wrap(FileUtil.getBytes(file));
            bufferCacheServletResponse.setByteBuffer(byteBuffer);
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            try (FileChannel fileChannel = fileInputStream.getChannel();){
                long contentLength = fileChannel.size();
                ServletResponseUtil.setContentLength(httpServletResponse, contentLength);
                httpServletResponse.flushBuffer();
                fileChannel.transferTo(0L, contentLength, Channels.newChannel((OutputStream)httpServletResponse.getOutputStream()));
            }
            catch (IOException ioException) {
                ServletResponseUtil._checkSocketException(ioException);
            }
        }
    }

    public static void write(HttpServletResponse httpServletResponse, InputStream inputStream) throws IOException {
        ServletResponseUtil.write(httpServletResponse, inputStream, 0L);
    }

    public static void write(HttpServletResponse httpServletResponse, InputStream inputStream, long contentLength) throws IOException {
        if (httpServletResponse.isCommitted()) {
            block7: {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioException) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn(ioException, ioException);
                    }
                }
            }
            return;
        }
        if (contentLength > 0L) {
            httpServletResponse.setHeader("Content-Length", String.valueOf(contentLength));
        }
        httpServletResponse.flushBuffer();
        try {
            StreamUtil.transfer(inputStream, (OutputStream)httpServletResponse.getOutputStream());
        }
        catch (IOException ioException) {
            ServletResponseUtil._checkSocketException(ioException);
        }
    }

    public static void write(HttpServletResponse httpServletResponse, String s) throws IOException {
        if (httpServletResponse instanceof BufferCacheServletResponse) {
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)httpServletResponse;
            bufferCacheServletResponse.setString(s);
        } else {
            ByteBuffer byteBuffer = CharsetEncoderUtil.encode((String)"UTF-8", (CharBuffer)CharBuffer.wrap(s));
            ServletResponseUtil.write(httpServletResponse, byteBuffer);
        }
    }

    protected static void setContentLength(HttpServletResponse httpServletResponse, long contentLength) {
        httpServletResponse.setHeader("Content-Length", String.valueOf(contentLength));
    }

    protected static void setHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String fileName, String contentType, String contentDispositionType) {
        if (_log.isDebugEnabled()) {
            _log.debug("Sending file of type " + contentType);
        }
        if (Validator.isNotNull(contentType)) {
            httpServletResponse.setContentType(contentType);
        }
        if (!httpServletResponse.containsHeader("Cache-Control")) {
            httpServletResponse.setHeader("Cache-Control", "private");
        }
        if (Validator.isNull(fileName)) {
            return;
        }
        String contentDispositionFileName = "filename=\"" + fileName + "\"";
        boolean ascii = true;
        for (int i = 0; i < fileName.length(); ++i) {
            if (Validator.isAscii(fileName.charAt(i))) continue;
            ascii = false;
            break;
        }
        if (!ascii) {
            String encodedFileName = URLCodec.encodeURL(fileName, true);
            contentDispositionFileName = BrowserSnifferUtil.isIe(httpServletRequest) ? "filename=\"" + encodedFileName + "\"" : "filename*=UTF-8''" + encodedFileName;
        }
        if (Validator.isNull(contentDispositionType)) {
            String extension = GetterUtil.getString(FileUtil.getExtension(fileName));
            extension = StringUtil.toLowerCase(extension);
            Object[] mimeTypesContentDispositionInline = null;
            try {
                mimeTypesContentDispositionInline = PropsUtil.getArray("mime.types.content.disposition.inline");
            }
            catch (Exception exception) {
                mimeTypesContentDispositionInline = new String[]{};
            }
            if (ArrayUtil.contains(mimeTypesContentDispositionInline, extension)) {
                contentDispositionType = "inline";
                contentType = MimeTypesUtil.getExtensionContentType(extension);
                httpServletResponse.setContentType(contentType);
            } else {
                contentDispositionType = "attachment";
            }
        }
        StringBundler sb = new StringBundler(4);
        sb.append(contentDispositionType);
        sb.append(";");
        sb.append(" ");
        sb.append(contentDispositionFileName);
        if (_log.isDebugEnabled()) {
            _log.debug("Setting content disposition header " + sb.toString());
        }
        httpServletResponse.setHeader("Content-Disposition", sb.toString());
    }

    protected static void setHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String fileName, String contentType, String contentDispositionType, Range range) {
        ServletResponseUtil.setHeaders(httpServletRequest, httpServletResponse, fileName, contentType, contentDispositionType);
        if (range != null) {
            httpServletResponse.setHeader("Content-Range", range.getContentRange());
            httpServletResponse.setHeader("Content-Length", String.valueOf(range.getLength()));
        }
    }

    private static void _checkSocketException(IOException ioException) throws IOException {
        if (ioException instanceof SocketException || ServletResponseUtil.isClientAbortException(ioException)) {
            if (_log.isWarnEnabled()) {
                _log.warn(ioException, ioException);
            }
        } else {
            throw ioException;
        }
    }

    private static InputStream _copyRange(InputStream inputStream, OutputStream outputStream, long start, long length) throws IOException {
        if (inputStream instanceof ByteArrayInputStream) {
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)inputStream;
            byteArrayInputStream.reset();
            byteArrayInputStream.skip(start);
            try {
                StreamUtil.transfer(byteArrayInputStream, outputStream, StreamUtil.BUFFER_SIZE, false, length);
            }
            catch (IOException ioException) {
                ServletResponseUtil._checkSocketException(ioException);
            }
            return byteArrayInputStream;
        }
        if (inputStream instanceof FileInputStream) {
            FileInputStream fileInputStream = (FileInputStream)inputStream;
            FileChannel fileChannel = fileInputStream.getChannel();
            try {
                fileChannel.transferTo(start, length, Channels.newChannel(outputStream));
            }
            catch (IOException ioException) {
                ServletResponseUtil._checkSocketException(ioException);
            }
            return fileInputStream;
        }
        if (inputStream instanceof RandomAccessInputStream) {
            RandomAccessInputStream randomAccessInputStream = (RandomAccessInputStream)inputStream;
            randomAccessInputStream.seek(start);
            try {
                StreamUtil.transfer(randomAccessInputStream, outputStream, StreamUtil.BUFFER_SIZE, false, length);
            }
            catch (IOException ioException) {
                ServletResponseUtil._checkSocketException(ioException);
            }
            return randomAccessInputStream;
        }
        inputStream.skip(start);
        try {
            StreamUtil.transfer(inputStream, outputStream, StreamUtil.BUFFER_SIZE, false, length);
        }
        catch (IOException ioException) {
            ServletResponseUtil._checkSocketException(ioException);
        }
        return inputStream;
    }

    private static List<Range> _getRanges(HttpServletRequest httpServletRequest, long length) throws IOException {
        String rangeString = httpServletRequest.getHeader("Range");
        if (Validator.isNull(rangeString)) {
            return Collections.emptyList();
        }
        if (!rangeString.matches(_RANGE_REGEX)) {
            throw new IOException("Range header does not match regular expression " + rangeString);
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        String[] rangeFields = StringUtil.split(rangeString.substring(6));
        if (rangeFields.length > _MAX_RANGE_FIELDS) {
            StringBundler sb = new StringBundler(8);
            sb.append("Request range ");
            sb.append(rangeString);
            sb.append(" with ");
            sb.append(rangeFields.length);
            sb.append(" range fields has exceeded maximum allowance as ");
            sb.append("specified by the property \"");
            sb.append("web.server.servlet.max.range.fields");
            sb.append("\"");
            throw new IOException(sb.toString());
        }
        for (String rangeField : rangeFields) {
            int index = rangeField.indexOf("-");
            long start = GetterUtil.getLong(rangeField.substring(0, index), -1L);
            long end = GetterUtil.getLong(rangeField.substring(index + 1), -1L);
            if (start == -1L) {
                start = length - end;
                end = length - 1L;
            } else if (end == -1L || end > length - 1L) {
                end = length - 1L;
            }
            if (start > end) {
                throw new IOException(StringBundler.concat((Object[])new Object[]{"Range start ", start, " is greater than end ", end}));
            }
            Range range = new Range(start, end, length);
            ranges.add(range);
        }
        return ranges;
    }

    private static boolean _isRandomAccessSupported(InputStream inputStream) {
        return inputStream instanceof ByteArrayInputStream || inputStream instanceof FileInputStream || inputStream instanceof RandomAccessInputStream;
    }

    private static boolean _isSequentialRangeList(List<Range> ranges) {
        Range previousRange = null;
        for (Range range : ranges) {
            if (previousRange != null && range.getStart() <= previousRange.getEnd()) {
                return false;
            }
            previousRange = range;
        }
        return true;
    }

    private static InputStream _toRandomAccessInputStream(InputStream inputStream) throws IOException {
        if (ServletResponseUtil._isRandomAccessSupported(inputStream)) {
            return inputStream;
        }
        return new RandomAccessInputStream(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _write(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String fileName, List<Range> ranges, InputStream inputStream, long fullLength, String contentType) throws IOException {
        try (ServletOutputStream outputStream = httpServletResponse.getOutputStream();){
            Range fullRange = new Range(0L, fullLength - 1L, fullLength);
            Range firstRange = null;
            if (!ranges.isEmpty()) {
                firstRange = ranges.get(0);
            }
            if (firstRange == null || firstRange.equals(fullRange)) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Writing full range");
                }
                httpServletResponse.setContentType(contentType);
                ServletResponseUtil.setHeaders(httpServletRequest, httpServletResponse, fileName, contentType, null, fullRange);
                ServletResponseUtil._copyRange(inputStream, (OutputStream)outputStream, fullRange.getStart(), fullRange.getLength());
            } else if (ranges.size() == 1) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Attempting to write a single range");
                }
                Range range = ranges.get(0);
                httpServletResponse.setContentType(contentType);
                ServletResponseUtil.setHeaders(httpServletRequest, httpServletResponse, fileName, contentType, null, range);
                httpServletResponse.setStatus(206);
                ServletResponseUtil._copyRange(inputStream, (OutputStream)outputStream, range.getStart(), range.getLength());
            } else if (ranges.size() > 1) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Attempting to write multiple ranges");
                }
                ServletOutputStream servletOutputStream = outputStream;
                String boundary = "liferay-multipart-boundary-" + System.currentTimeMillis();
                String multipartContentType = "multipart/byteranges; boundary=" + boundary;
                httpServletResponse.setContentType(multipartContentType);
                ServletResponseUtil.setHeaders(httpServletRequest, httpServletResponse, fileName, multipartContentType, null);
                httpServletResponse.setStatus(206);
                boolean sequentialRangeList = ServletResponseUtil._isSequentialRangeList(ranges);
                if (!sequentialRangeList) {
                    inputStream = ServletResponseUtil._toRandomAccessInputStream(inputStream);
                }
                Range previousRange = null;
                for (Range curRange : ranges) {
                    servletOutputStream.println();
                    servletOutputStream.println("--" + boundary);
                    servletOutputStream.println("Content-Type: " + contentType);
                    servletOutputStream.println("Content-Range: " + curRange.getContentRange());
                    servletOutputStream.println();
                    long start = curRange.getStart();
                    if (sequentialRangeList) {
                        if (previousRange != null) {
                            start -= previousRange.getEnd() + 1L;
                        }
                        previousRange = curRange;
                    }
                    ServletResponseUtil._copyRange(inputStream, (OutputStream)servletOutputStream, start, curRange.getLength());
                }
                servletOutputStream.println();
                servletOutputStream.println("--" + boundary + "--");
            }
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(true, inputStream);
            throw throwable;
        }
        StreamUtil.cleanUp(true, inputStream);
    }
}

