/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.xml.simple;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.HtmlUtil;
import java.util.LinkedList;

public class Element {
    private static final String _CLOSE_POST = ">";
    private static final String _CLOSE_PRE = "</";
    private static final String _EQUAL_QUOTE = "=\"";
    private static final String _OPEN_POST = ">";
    private static final String _OPEN_PRE = "<";
    private static final String _XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private boolean _elementClosed;
    private final LinkedList<Element> _elementStack;
    private final String _name;
    private boolean _openTagClosed;
    private Element _parentElement;
    private final StringBundler _sb;
    private final String _text;
    private String _xmlString;

    public Element(Element parentElement, String name) {
        this(parentElement, name, null);
    }

    public Element(Element parentElement, String name, String text) {
        if (parentElement._elementClosed) {
            throw new IllegalArgumentException("Parent element is closed");
        }
        this._parentElement = parentElement;
        this._name = name;
        this._text = this._formatText(text);
        this._elementStack = parentElement._elementStack;
        this._sb = parentElement._sb;
        this._appendChildElement();
    }

    public Element(String name) {
        this(name, null, true);
    }

    public Element(String name, boolean addHeader) {
        this(name, null, addHeader);
    }

    public Element(String name, String text) {
        this(name, text, true);
    }

    public Element(String name, String text, boolean addHeader) {
        this._name = name;
        this._text = this._formatText(text);
        this._elementStack = new LinkedList();
        this._sb = new StringBundler();
        if (addHeader) {
            this._sb.append(_XML_HEADER);
        }
        this._openElement(this);
    }

    public void addAttribute(String name, String value) {
        if (this._openTagClosed) {
            throw new IllegalStateException("Element is closed");
        }
        this._sb.append(" ");
        this._sb.append(name);
        this._sb.append(_EQUAL_QUOTE);
        this._sb.append(value);
        this._sb.append("\"");
    }

    public Element addElement(String name) {
        return this.addElement(name, null);
    }

    public Element addElement(String name, boolean text) {
        return this.addElement(name, String.valueOf(text));
    }

    public Element addElement(String name, double text) {
        return this.addElement(name, String.valueOf(text));
    }

    public Element addElement(String name, float text) {
        return this.addElement(name, String.valueOf(text));
    }

    public Element addElement(String name, int text) {
        return this.addElement(name, String.valueOf(text));
    }

    public Element addElement(String name, long text) {
        return this.addElement(name, String.valueOf(text));
    }

    public Element addElement(String name, Object text) {
        return this.addElement(name, String.valueOf(text));
    }

    public Element addElement(String name, short text) {
        return this.addElement(name, String.valueOf(text));
    }

    public Element addElement(String name, String text) {
        return new Element(this, name, text);
    }

    public String getName() {
        return this._name;
    }

    public Element getParentElement() {
        return this._parentElement;
    }

    public String getText() {
        return this._text;
    }

    public boolean isRootElement() {
        return this._parentElement == null;
    }

    public String toXMLString() {
        if (this._parentElement != null) {
            throw new IllegalStateException("XML string can only generated from a root element");
        }
        if (this._xmlString == null) {
            this._flushPendingOpenElements();
            this._xmlString = this._sb.toString();
        }
        return this._xmlString;
    }

    private void _appendChildElement() {
        Element topElement = this._elementStack.getLast();
        while (topElement != this._parentElement && topElement != null) {
            this._closeElement(topElement);
            this._elementStack.removeLast();
            topElement = this._elementStack.getLast();
        }
        if (topElement != this._parentElement) {
            throw new IllegalArgumentException("The parent element does not exist");
        }
        this._closeOpenTag(topElement);
        this._openElement(this);
    }

    private void _closeElement(Element element) {
        this._closeOpenTag(element);
        this._sb.append(_CLOSE_PRE);
        this._sb.append(element._name);
        this._sb.append(">");
        element._elementClosed = true;
    }

    private void _closeOpenTag(Element element) {
        if (!element._openTagClosed) {
            this._sb.append(">");
            if (element._text != null) {
                this._sb.append(element._text);
            }
            element._openTagClosed = true;
        }
    }

    private void _flushPendingOpenElements() {
        while (!this._elementStack.isEmpty()) {
            this._closeElement(this._elementStack.removeLast());
        }
    }

    private String _formatText(String text) {
        return HtmlUtil.escape(text);
    }

    private void _openElement(Element element) {
        this._sb.append(_OPEN_PRE);
        this._sb.append(element._name);
        this._elementStack.addLast(element);
    }
}

