/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.social.kernel.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class SocialCounterPeriodUtil {
    private static final long _BASE_TIME = new GregorianCalendar(2011, 0, 1).getTimeInMillis();
    private static final String _SOCIAL_ACTIVITY_COUNTER_PERIOD_LENGTH = PropsUtil.get("social.activity.counter.period.length");
    private static int _endPeriod;
    private static int _periodLength;
    private static int _startPeriod;

    public static int getActivityDay() {
        return SocialCounterPeriodUtil.getActivityDay(System.currentTimeMillis());
    }

    public static int getActivityDay(Calendar calendar) {
        Date date = calendar.getTime();
        return SocialCounterPeriodUtil.getActivityDay(date.getTime());
    }

    public static int getActivityDay(long time) {
        return (int)(time / 86400000L - _BASE_TIME / 86400000L);
    }

    public static Date getDate(int activityDay) {
        return new Date(_BASE_TIME + (long)activityDay * 86400000L);
    }

    public static int getEndPeriod() {
        if (SocialCounterPeriodUtil._isWithinPeriod(_startPeriod, _endPeriod, SocialCounterPeriodUtil.getActivityDay())) {
            return _endPeriod;
        }
        _endPeriod = SocialCounterPeriodUtil.getStartPeriod() + SocialCounterPeriodUtil.getPeriodLength() - 1;
        return _endPeriod;
    }

    public static int getEndPeriod(int offset) {
        if (SocialCounterPeriodUtil._isMonthlyPeriod()) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(5, 1);
            ((Calendar)calendar).add(2, offset + 1);
            ((Calendar)calendar).add(5, -1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return SocialCounterPeriodUtil.getActivityDay(calendar);
        }
        return SocialCounterPeriodUtil.getEndPeriod() - offset * SocialCounterPeriodUtil.getPeriodLength();
    }

    public static int getEndPeriod(long time) {
        int activityDay = SocialCounterPeriodUtil.getActivityDay(time);
        int offset = 0;
        while (SocialCounterPeriodUtil.getStartPeriod(offset) > activityDay) {
            --offset;
        }
        return SocialCounterPeriodUtil.getEndPeriod(offset);
    }

    public static int getFirstActivityDayOfYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return SocialCounterPeriodUtil.getActivityDay(calendar);
    }

    public static int getOffset(int activityDay) {
        if (SocialCounterPeriodUtil._isMonthlyPeriod()) {
            GregorianCalendar calendar = new GregorianCalendar();
            GregorianCalendar calendar2 = new GregorianCalendar();
            calendar2.setTimeInMillis(_BASE_TIME + (long)activityDay * 86400000L);
            int monthDelta = calendar.get(2) - calendar2.get(2);
            int yearDelta = calendar.get(1) - calendar2.get(1);
            return -(yearDelta * 12 + monthDelta);
        }
        return -((SocialCounterPeriodUtil.getStartPeriod() - activityDay) / SocialCounterPeriodUtil.getPeriodLength());
    }

    public static int getPeriodLength() {
        if (SocialCounterPeriodUtil._isMonthlyPeriod()) {
            if (SocialCounterPeriodUtil._isWithinPeriod(_startPeriod, _endPeriod, SocialCounterPeriodUtil.getActivityDay())) {
                return _periodLength;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            _startPeriod = SocialCounterPeriodUtil.getActivityDay(calendar);
            _periodLength = ((Calendar)calendar).getActualMaximum(5);
            _endPeriod = _startPeriod + _periodLength - 1;
            return _periodLength;
        }
        if (_periodLength == -1) {
            _periodLength = GetterUtil.getInteger(_SOCIAL_ACTIVITY_COUNTER_PERIOD_LENGTH);
        }
        return _periodLength;
    }

    public static int getPeriodLength(int offset) {
        if (SocialCounterPeriodUtil._isMonthlyPeriod()) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            ((Calendar)calendar).add(2, offset);
            return ((Calendar)calendar).getActualMaximum(5);
        }
        return SocialCounterPeriodUtil.getPeriodLength();
    }

    public static int getStartPeriod() {
        if (SocialCounterPeriodUtil._isWithinPeriod(_startPeriod, _endPeriod, SocialCounterPeriodUtil.getActivityDay())) {
            return _startPeriod;
        }
        if (SocialCounterPeriodUtil._isMonthlyPeriod()) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            _startPeriod = SocialCounterPeriodUtil.getActivityDay(calendar);
            return _startPeriod;
        }
        _startPeriod = SocialCounterPeriodUtil.getActivityDay() / SocialCounterPeriodUtil.getPeriodLength() * SocialCounterPeriodUtil.getPeriodLength();
        return _startPeriod;
    }

    public static int getStartPeriod(int offset) {
        if (SocialCounterPeriodUtil._isMonthlyPeriod()) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(5, 1);
            ((Calendar)calendar).add(2, offset);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date calendarTime = calendar.getTime();
            return SocialCounterPeriodUtil.getActivityDay(calendarTime.getTime());
        }
        return SocialCounterPeriodUtil.getStartPeriod() + offset * SocialCounterPeriodUtil.getPeriodLength();
    }

    public static int getStartPeriod(long time) {
        int activityDay = SocialCounterPeriodUtil.getActivityDay(time);
        int offset = 0;
        while (SocialCounterPeriodUtil.getStartPeriod(offset) > activityDay) {
            --offset;
        }
        return SocialCounterPeriodUtil.getStartPeriod(offset);
    }

    private static boolean _isMonthlyPeriod() {
        return _SOCIAL_ACTIVITY_COUNTER_PERIOD_LENGTH.equals("month");
    }

    private static boolean _isWithinPeriod(int startPeriod, int endPeriod, int activityDay) {
        return activityDay >= startPeriod && activityDay <= endPeriod;
    }

    static {
        _periodLength = -1;
    }
}

