/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.compat.util.bridges.alloy;

import com.liferay.compat.util.bridges.alloy.AlloyServiceInvoker;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAlloyIndexer
extends BaseIndexer {
    protected AlloyServiceInvoker alloyServiceInvoker;
    protected String[] classNames;
    protected String portletId;

    public AlloyServiceInvoker getAlloyServiceInvoker() {
        return this.alloyServiceInvoker;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public String getPortletId() {
        return this.portletId;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)-1);
        if (status != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        BaseModel baseModel = (BaseModel)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(this.portletId, String.valueOf(baseModel.getPrimaryKeyObj()));
        AuditedModel auditedModel = (AuditedModel)obj;
        SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)auditedModel.getCompanyId(), (String)document.get("uid"));
    }

    protected void doReindex(Object obj) throws Exception {
        Document document = this.getDocument(obj);
        AuditedModel auditedModel = (AuditedModel)obj;
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)auditedModel.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BaseModel<?> model = this.alloyServiceInvoker.fetchModel(classPK);
        if (model != null) {
            this.doReindex(model);
        }
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexModels(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return this.portletId;
    }

    protected void reindexModels(long companyId) throws Exception {
        int count = this.alloyServiceInvoker.getModelsCount();
        int pages = count / 10000;
        int i = 0;
        while (i <= pages) {
            int start = i * 10000;
            int end = start + 10000;
            this.reindexModels(companyId, start, end);
            ++i;
        }
    }

    protected void reindexModels(long companyId, int start, int end) throws Exception {
        List models = this.alloyServiceInvoker.getModels(start, end);
        if (models.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>(models.size());
        for (Object model : models) {
            Document document = this.getDocument(model);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }

    protected void setAlloyServiceInvoker(AlloyServiceInvoker alloyServiceInvoker) {
        this.alloyServiceInvoker = alloyServiceInvoker;
    }

    protected void setClassName(String className) {
        if (this.classNames == null) {
            this.classNames = new String[]{className};
        }
    }

    protected void setPortletId(String portletId) {
        if (this.portletId == null) {
            this.portletId = portletId;
        }
    }
}

