/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.io.File;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.DirectoryInput;
import org.tp23.antinstaller.renderer.MessageRenderer;

public class AppRootInput
extends DirectoryInput {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    private String checkFile1;
    private String checkFile2;
    private String checkDir1;
    private String checkDir2;

    public boolean validate(InstallerContext installerContext) throws ValidationException {
        if (this.getInputResult() == null) {
            return false;
        }
        MessageRenderer messageRenderer = installerContext.getMessageRenderer();
        String string = this.getInputResult();
        File file = new File(string);
        if (!file.isDirectory()) {
            messageRenderer.printMessage(res.getString("dirNotExist") + ":" + file.getAbsolutePath());
            return false;
        }
        if (this.checkFile1 != null && !this.checkExists(messageRenderer, file, this.checkFile1)) {
            return false;
        }
        if (this.checkFile2 != null && !this.checkExists(messageRenderer, file, this.checkFile2)) {
            return false;
        }
        if (this.checkDir1 != null && !this.checkExists(messageRenderer, file, this.checkDir1)) {
            return false;
        }
        return this.checkDir2 == null || this.checkExists(messageRenderer, file, this.checkDir2);
    }

    private boolean checkExists(MessageRenderer messageRenderer, File file, String string) {
        File file2 = new File(file, this.checkFile1);
        if (!file2.exists()) {
            this.reportMissing(messageRenderer, file2);
            return false;
        }
        return true;
    }

    private void reportMissing(MessageRenderer messageRenderer, File file) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(res.getString("appRootInvalid"));
        stringBuffer.append(System.getProperty("line.separator"));
        if (file.isDirectory()) {
            stringBuffer.append(res.getString("dirNotExist"));
        } else {
            stringBuffer.append(res.getString("fileNotExist"));
        }
        stringBuffer.append(":");
        stringBuffer.append(file.getAbsolutePath());
        messageRenderer.printMessage(stringBuffer.toString());
    }

    public String getCheckDir1() {
        return this.checkDir1;
    }

    public String getCheckDir2() {
        return this.checkDir2;
    }

    public String getCheckFile1() {
        return this.checkFile1;
    }

    public String getCheckFile2() {
        return this.checkFile2;
    }

    public void setCheckFile2(String string) {
        this.checkFile2 = string;
    }

    public void setCheckFile1(String string) {
        this.checkFile1 = string;
    }

    public void setCheckDir2(String string) {
        this.checkDir2 = string;
    }

    public void setCheckDir1(String string) {
        this.checkDir1 = string;
    }

    public boolean validateObject() {
        if (this.getDisplayText() == null) {
            System.out.println("AppRoot:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            System.out.println("AppRoot:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            System.out.println("AppRoot:defaultValue must be set");
            return false;
        }
        return true;
    }
}

