/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.io.File;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OSSpecific;
import org.tp23.antinstaller.renderer.MessageRenderer;

public class DirectoryInput
extends OSSpecific {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    private boolean abort = false;
    private String create;
    private String checkExists;

    public boolean validate(InstallerContext installerContext) throws ValidationException {
        if (this.getInputResult() == null) {
            return false;
        }
        MessageRenderer messageRenderer = installerContext.getMessageRenderer();
        File file = new File(this.getInputResult());
        if (InputField.isTrue(this.create) && !file.exists()) {
            try {
                boolean bl;
                if (messageRenderer.prompt(res.getString("dirNotExistCreate") + "\n" + file.getAbsolutePath()) && !(bl = file.mkdirs())) {
                    messageRenderer.printMessage(res.getString("dirNotCreated"));
                }
            }
            catch (Exception exception) {
                messageRenderer.printMessage(res.getString("canNotCreateFile") + "\n" + file.getAbsolutePath());
                throw new ValidationException(res.getString("canNotCreateFile"), exception);
            }
        }
        if (!(!InputField.isTrue(this.checkExists) || file.exists() && file.isDirectory())) {
            messageRenderer.printMessage(res.getString("dirNotExist") + "\n" + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean bl) {
        this.abort = bl;
    }

    public String getCreate() {
        return this.create;
    }

    public void setCreate(String string) {
        this.create = string;
    }

    public void setValue(String string) {
        this.setInputResult(string);
    }

    public String getCheckExists() {
        return this.checkExists;
    }

    public void setCheckExists(String string) {
        this.checkExists = string;
    }

    public boolean validateObject() {
        if (this.getDisplayText() == null) {
            System.out.println("Directory:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            System.out.println("Directory:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            System.out.println("Directory:defaultValue must be set");
            return false;
        }
        if (!InputField.optionalBoolean(this.getCreate())) {
            System.out.println("Directory:create must be true or false or null");
            return false;
        }
        if (!InputField.optionalBoolean(this.getCheckExists())) {
            System.out.println("Directory:checkExists must be true or false or null");
            return false;
        }
        return true;
    }
}

