/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.io.File;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.OSSpecific;

public class FileInput
extends OSSpecific {
    private boolean abort = false;
    private String checkExists;

    public boolean validate(InstallerContext installerContext) throws ValidationException {
        if (this.getInputResult() == null) {
            return false;
        }
        File file = new File(this.getInputResult());
        return !InputField.isTrue(this.checkExists) || file.exists();
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean bl) {
        this.abort = bl;
    }

    public String getCheckExists() {
        return this.checkExists;
    }

    public void setCheckExists(String string) {
        this.checkExists = string;
    }

    public void setValue(String string) {
        this.setInputResult(string);
    }

    public boolean validateObject() {
        if (this.getDisplayText() == null) {
            System.out.println("File:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            System.out.println("File:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            System.out.println("File:defaultValue must be set");
            return false;
        }
        if (!InputField.optionalBoolean(this.getCheckExists())) {
            System.out.println("File:checkExists must be true or false or null");
            return false;
        }
        return true;
    }
}

