/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.page;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.TargetInput;

public abstract class Page {
    private String name;
    private String displayText;
    private String imageResource;
    private OutputField[] outputField;
    private boolean abort;
    private Set targets = new TreeSet();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setDisplayText(String string) {
        this.displayText = string;
    }

    public String getImageResource() {
        return this.imageResource;
    }

    public void setImageResource(String string) {
        this.imageResource = string;
    }

    public OutputField[] getOutputField() {
        return this.outputField;
    }

    public void setOutputField(OutputField[] outputFieldArray) {
        this.outputField = outputFieldArray;
    }

    public List getTargets() {
        ArrayList<String> arrayList = new ArrayList<String>(this.targets.size());
        Iterator iterator = this.targets.iterator();
        while (iterator.hasNext()) {
            IndexedTarget indexedTarget = (IndexedTarget)iterator.next();
            arrayList.add(indexedTarget.target);
        }
        return arrayList;
    }

    public void setTarget(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.targets.add(new IndexedTarget(TargetInput.getGlobalIdx(), stringTokenizer.nextToken()));
        }
    }

    public void addTarget(int n, String string) {
        this.targets.add(new IndexedTarget(n, string));
    }

    public void removeTarget(int n, String string) {
        this.targets.remove(new IndexedTarget(n, string));
    }

    public boolean isTarget(String string) {
        if (string == null) {
            return false;
        }
        Iterator iterator = this.targets.iterator();
        while (iterator.hasNext()) {
            IndexedTarget indexedTarget = (IndexedTarget)iterator.next();
            if (!indexedTarget.target.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean bl) {
        this.abort = bl;
    }

    class IndexedTarget
    implements Comparable {
        int idx;
        String target;

        IndexedTarget(int n, String string) {
            this.idx = n;
            this.target = string;
        }

        public boolean equals(Object object) {
            IndexedTarget indexedTarget = (IndexedTarget)object;
            return indexedTarget.idx == this.idx;
        }

        public int compareTo(Object object) {
            IndexedTarget indexedTarget = (IndexedTarget)object;
            return this.idx - indexedTarget.idx;
        }
    }
}

