/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.swing.AIPasswordField;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.antinstaller.renderer.swing.ValidatedTextInputRenderer;
import org.tp23.gui.GBCF;

public class PasswordTextInputRenderer
extends ValidatedTextInputRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");

    public PasswordTextInputRenderer() {
        this.jTextField = new AIPasswordField();
        this.origFore = this.jTextField.getForeground();
    }

    public void renderError() {
        MessageRenderer messageRenderer = this.ctx.getMessageRenderer();
        messageRenderer.printMessage(res.getString("notCorrectPasswordFormat") + "\n\n e.g. " + this.inputField.getDefaultValue());
        this.jTextField.requestFocus();
        this.jTextField.setForeground(Color.red);
        this.jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() != '\t') {
                    PasswordTextInputRenderer.this.inputField.setEditted(true);
                }
            }
        });
    }

    public int addSelf(JPanel jPanel, GBCF gBCF, int n, boolean bl) {
        jPanel.add((Component)this.fieldLabel, gBCF.getCell(n, 0));
        jPanel.add((Component)this.jTextField, gBCF.getCell(n, 1));
        if (bl) {
            ((AIPasswordField)this.jTextField).setOverflow(SwingOutputFieldRenderer.OVERFLOW_FIELD_SIZE);
        }
        return ++n;
    }
}

