/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.FileInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class FileInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    protected InstallerContext ctx;

    public void setContext(InstallerContext installerContext) {
        this.ctx = installerContext;
    }

    public void renderOutput(OutputField outputField, InputStream inputStream, PrintStream printStream) throws IOException {
        FileInput fileInput = (FileInput)outputField;
        printStream.print(fileInput.getDisplayText());
        printStream.print("   [");
        printStream.print(res.getString("_default_"));
        printStream.print(":");
        printStream.print(fileInput.getDefaultValue(true));
        printStream.print("]");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        printStream.println();
        String string = bufferedReader.readLine();
        printStream.println();
        if (string == null || string.equals("")) {
            string = fileInput.getDefaultValue(true);
        }
        fileInput.setInputResult(new File(string).getAbsolutePath());
    }

    public void renderError(OutputField outputField, InputStream inputStream, PrintStream printStream) throws IOException {
        MessageRenderer messageRenderer = this.ctx.getMessageRenderer();
        messageRenderer.printMessage(res.getString("fileDoesNotExist"));
        this.renderOutput(outputField, inputStream, printStream);
    }

    public boolean isAbort() {
        return false;
    }
}

