/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.LargeSelectInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.text.Pager;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class LargeSelectInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    private static final String nextChar = res.getString("nextChar");
    protected InstallerContext ctx;

    public void setContext(InstallerContext installerContext) {
        this.ctx = installerContext;
    }

    public void renderOutput(OutputField outputField, InputStream inputStream, PrintStream printStream) throws IOException {
        LargeSelectInput largeSelectInput = (LargeSelectInput)outputField;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.printText(largeSelectInput, printStream, bufferedReader);
        String string = bufferedReader.readLine();
        printStream.println();
        if (string == null || string.equals("")) {
            string = largeSelectInput.getDefaultValue();
        } else {
            try {
                int n = Integer.parseInt(string.trim());
                string = largeSelectInput.getOptions()[n - 1].value;
            }
            catch (Exception exception) {
                return;
            }
        }
        largeSelectInput.setInputResult(string);
    }

    public boolean isAbort() {
        return false;
    }

    private void printText(LargeSelectInput largeSelectInput, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        printStream.println(largeSelectInput.getDisplayText());
        LargeSelectInput.Option[] optionArray = largeSelectInput.getOptions();
        printStream.print("  ");
        printStream.println(res.getString("availableOptions"));
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < optionArray.length; ++i) {
            stringBuffer.append("  ");
            stringBuffer.append(i + 1);
            stringBuffer.append(") ");
            stringBuffer.append(optionArray[i].text);
            if (largeSelectInput.getDefaultValue().equals(optionArray[i].value)) {
                stringBuffer.append(" [");
                stringBuffer.append(res.getString("_default_"));
                stringBuffer.append("]");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("  ");
        stringBuffer.append(res.getString("enterNumber")).append("\n");
        Pager pager = new Pager(stringBuffer.toString());
        String string = null;
        while (pager.next(printStream)) {
            printStream.println();
            printStream.println(this.getNextInstructions());
            string = bufferedReader.readLine();
            if (string.toUpperCase().startsWith(nextChar)) continue;
        }
        pager.rest(printStream);
    }

    public void renderError(OutputField outputField, InputStream inputStream, PrintStream printStream) throws IOException {
        this.ctx.getMessageRenderer().printMessage("Not a valid selection");
        this.renderOutput(outputField, inputStream, printStream);
    }

    private String getNextInstructions() {
        return res.getString("large_select_next");
    }
}

