/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.selfextract;

import java.awt.GraphicsEnvironment;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.runtime.ExecInstall;
import org.tp23.antinstaller.runtime.exe.FilterFactory;
import org.tp23.antinstaller.runtime.exe.SelfExtractorFilterChain;
import org.tp23.antinstaller.selfextract.ProgressIndicator;

public class SelfExtractor {
    private File extractDir;
    private File archiveFile;
    private boolean overwrite = true;
    private static int DEFAULT_BUFFER_SIZE = 1024;
    private int BUFFER_SIZE = DEFAULT_BUFFER_SIZE;
    private static boolean graphicsEnv = false;
    private static String lookAndFeel = null;

    public static File getEnclosingJar(Object object) {
        String string = "/" + object.getClass().getName().replace('.', '/') + ".class";
        URL uRL = object.getClass().getResource(string);
        String string2 = uRL.toString();
        String string3 = uRL.getFile();
        File file = null;
        int n = string2.indexOf("!/");
        if (n != -1) {
            String string4 = null;
            String string5 = string2.substring("jar:file:".length(), n);
            file = new File(string5);
            if (!file.exists()) {
                string4 = SelfExtractor.unescape(string5);
                file = new File(string4);
            }
            if (!file.exists()) {
                System.out.println("Can't locate the jar file itself to self extract");
                System.out.println("Tried:" + string5);
                System.out.println("Tried:" + string4);
            }
            return file;
        }
        System.out.println("Can't locate the jar file itself to self extract");
        throw new RuntimeException("Failed expanding Jar.");
    }

    public SelfExtractor() {
    }

    public void init() {
        System.out.println("Loading self extractor...");
        this.archiveFile = SelfExtractor.getEnclosingJar(this);
        this.makeTempDir();
        try {
            JarFile jarFile = new JarFile(this.archiveFile);
            lookAndFeel = jarFile.getManifest().getMainAttributes().getValue("Look-And-Feel");
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected File makeTempDir() {
        String string = System.getProperty("java.io.tmpdir");
        this.extractDir = new File(string, "antinstall");
        int n = 0;
        while (this.extractDir.exists()) {
            this.extractDir = new File(string, "antinstall" + n++);
        }
        this.extractDir.mkdirs();
        this.extractDir.deleteOnExit();
        return this.extractDir;
    }

    public SelfExtractor(int n) {
        this.BUFFER_SIZE = n;
        this.archiveFile = SelfExtractor.getEnclosingJar(this);
    }

    public void setExtractDir(File file) {
        this.extractDir = file;
    }

    public void setArchiveFile(File file) {
        this.archiveFile = file;
    }

    public File getExtractDir() {
        return this.extractDir;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public File getArchiveFile() {
        return this.archiveFile;
    }

    public ArrayList getList(boolean bl) throws FileNotFoundException, IOException {
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(this.archiveFile));
        JarEntry jarEntry = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            if (bl) {
                System.out.println(jarEntry.getName());
            }
            arrayList.add(jarEntry.getName());
        }
        return arrayList;
    }

    public int getFileCount() throws FileNotFoundException, IOException {
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(this.archiveFile));
        int n = 0;
        while (jarInputStream.getNextJarEntry() != null) {
            ++n;
        }
        return n;
    }

    public ArrayList extract(boolean bl, boolean bl2) throws FileNotFoundException, IOException {
        int n = this.getFileCount();
        ProgressIndicator progressIndicator = null;
        if (bl2) {
            progressIndicator = new ProgressIndicator(n);
            progressIndicator.show();
        }
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(this.archiveFile));
        JarEntry jarEntry = null;
        ArrayList<File> arrayList = new ArrayList<File>();
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            if (bl) {
                System.out.println("Extracting:" + jarEntry.getName());
            }
            arrayList.add(this.extract(jarInputStream, jarEntry));
            if (!bl2) continue;
            progressIndicator.tick();
        }
        if (bl2) {
            progressIndicator.hide();
        }
        jarInputStream.close();
        return arrayList;
    }

    private File extract(JarInputStream jarInputStream, JarEntry jarEntry) throws FileNotFoundException, IOException {
        this.createPath(jarEntry.getName());
        File file = new File(this.extractDir, jarEntry.getName());
        if (file.exists()) {
            if (!this.overwrite) {
                return file;
            }
        } else {
            file.createNewFile();
        }
        if (file.isDirectory()) {
            return file;
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), this.BUFFER_SIZE);
        byte[] byArray = new byte[this.BUFFER_SIZE];
        int n = 0;
        while ((n = jarInputStream.read(byArray)) >= 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.close();
        jarInputStream.closeEntry();
        return file;
    }

    private void createPath(String string) throws IOException {
        String string2;
        File file;
        int n = string.lastIndexOf(47);
        if (n >= 0 && !(file = new File(this.extractDir, string2 = string.substring(0, n))).exists()) {
            file.mkdirs();
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        SelfExtractor.testX();
        boolean bl = false;
        SelfExtractor selfExtractor = null;
        try {
            selfExtractor = new SelfExtractor();
            selfExtractor.init();
            object2 = selfExtractor.extract(bl, graphicsEnv);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object = "unknown";
            if (selfExtractor != null) {
                object = selfExtractor.getExtractDir().getAbsolutePath();
            }
            String string = "Could not extract Jar file to directory:" + (String)object;
            SelfExtractor.printXorTextWarning(string);
        }
        try {
            object2 = FilterFactory.factory("/org/tp23/antinstaller/runtime/exe/selfextractor.fconfig");
            object = new ExecInstall(new SelfExtractorFilterChain());
            ((ExecInstall)object).setInstallRoot(selfExtractor.getExtractDir());
            ((ExecInstall)object).setTempRoot(selfExtractor.getExtractDir());
            if (stringArray.length > 0) {
                ((ExecInstall)object).setUIOverride(stringArray[0]);
            }
            ((ExecInstall)object).exec();
        }
        catch (InstallException installException) {
            System.out.println("Cant load filter chain:/org/tp23/antinstaller/runtime/exe/selfextractor.fconfig");
            installException.printStackTrace();
        }
    }

    protected static void testX() {
        try {
            GraphicsEnvironment.getLocalGraphicsEnvironment();
            graphicsEnv = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected boolean isGraphicsEnv() {
        return graphicsEnv;
    }

    protected static void printXorTextWarning(String string) {
        if (graphicsEnv) {
            JOptionPane.showMessageDialog(null, string);
        } else {
            System.out.println(string);
        }
    }

    public static boolean testExtract() {
        try {
            File file = new File("C:\\ziptemp");
            File file2 = new File("C:\\ziptemp\\eg.zip");
            SelfExtractor selfExtractor = new SelfExtractor();
            selfExtractor.extract(true, true);
            return true;
        }
        catch (Exception exception) {
            System.out.println(exception.getClass() + ":" + exception.getMessage());
            return false;
        }
    }

    public static int deleteRecursive(File file) {
        int n = 0;
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory();
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i].delete();
            ++n;
        }
        File[] fileArray2 = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        for (int i = 0; i < fileArray2.length; ++i) {
            n += SelfExtractor.deleteRecursive(fileArray2[i]);
        }
        file.delete();
        return n;
    }

    private static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block6;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        String string2 = string.substring(i);
                        stringBuffer.append(string2);
                        if (string2.length() != 2) continue block6;
                        ++i;
                        continue block6;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

