/*
 * Decompiled with CFR 0.152.
 */
package ymsg.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import ymsg.network.AccountLockedException;
import ymsg.network.DirectConnectionHandler;
import ymsg.network.HTTPConnectionHandler;
import ymsg.network.LoginRefusedException;
import ymsg.network.SOCKSConnectionHandler;
import ymsg.network.Session;
import ymsg.network.YMSG9BadFormatException;
import ymsg.network.YahooChatCategory;
import ymsg.network.YahooChatLobby;
import ymsg.network.YahooChatRoom;
import ymsg.network.YahooChatUser;
import ymsg.network.YahooConference;
import ymsg.network.YahooGroup;
import ymsg.network.YahooIdentity;
import ymsg.network.YahooUser;
import ymsg.network.event.SessionAdapter;
import ymsg.network.event.SessionChatEvent;
import ymsg.network.event.SessionConferenceEvent;
import ymsg.network.event.SessionErrorEvent;
import ymsg.network.event.SessionEvent;
import ymsg.network.event.SessionExceptionEvent;
import ymsg.network.event.SessionFileTransferEvent;
import ymsg.network.event.SessionFriendEvent;
import ymsg.support.AntiSpam;
import ymsg.support.EmoteManager;
import ymsg.support.MessageDecoder;
import ymsg.support.MessageDecoderSettings;
import ymsg.support.MutableMessageElement;
import ymsg.support.SwingModelFactory;

public class SwingTestClient
extends JFrame
implements ActionListener,
ListSelectionListener {
    protected JTextField[] inputTF;
    protected JLabel[] inputLab;
    protected JTextPane outputTP;
    protected JList modeL;
    protected JButton sendB;
    protected ThreadGroup threadGroup;
    protected Document outputDoc;
    protected UserDisplay userDisplay = null;
    protected GroupDisplay groupDisplay = null;
    protected Session session;
    protected Vector conferences;
    protected YahooChatCategory rootCategory = null;
    protected YahooChatLobby currentLobby = null;
    protected YahooConference currentConf = null;
    protected MessageDecoder decoder;
    protected AntiSpam spamBlock;
    protected SwingModelFactory factory;
    protected EmoteManager emoteManager;
    protected MutableMessageElement styledOutRoot;
    protected MutableMessageElement styledOutBody;
    protected PrintWriter transcript;
    private static final String[][] LABELS = new String[][]{{"To", "Message", "-", "-"}, {"To", "-", "-", "-"}, {"To", "Message", "-", "-"}, {"To", "Filename", "Message", "-"}, {"Friend", "Group", "-", "-"}, {"Friend", "Group", "-", "-"}, {"Friend", "Message", "-", "-"}, {"Friend", "On/off", "-", "-"}, {"To list", "Message", "-", "-"}, {"Room", "-", "-", "-"}, {"Room", "Message", "-", "-"}, {"Room", "To", "Message", "-"}, {"Room", "Message", "-", "-"}, {"Room", "-", "-", "-"}, {"Room:Lobby", "-", "-", "-"}, {"Message", "-", "-", "-"}, {"To", "Emote", "-", "-"}, {"-", "-", "-", "-"}, {"-", "-", "-", "-"}, {"-", "-", "-", "-"}, {"To", "-", "-", "-"}, {"To", "-", "-", "-"}, {"To", "-", "-", "-"}, {"Username", "Password", "Connect", "-"}, {"-", "-", "-", "-"}, {"-", "-", "-", "-"}, {"To", "Msg", "-", "-"}, {"-", "-", "-", "-"}, {"Comment", "-", "-", "-"}};
    private static final int PARAMS = 3;
    private static final String[] MODES = new String[]{"Send message", "Send BUZZ", "Styled text demo", "Send file tf", "Friend: add", "Friend: remove", "Friend: reject", "Friend: ignore", "Conference: create", "Conference: accept", "Conference: decline", "Conference: extend", "Conference: message", "Conference: leave", "Chat: login", "Chat: message", "Chat: Emote", "Chat: logoff", "Activate identity", "Deactivate identity", "Add typing notif.", "Remove typing notif.", "Send typing notif.", "Login", "Logoff", "Refresh", "Test 1", "Test 2", "Log comment"};
    private static final int[] MAPPINGS = new int[]{256, 257, 258, 259, 512, 513, 514, 515, 768, 769, 770, 771, 772, 773, 1024, 1025, 1027, 1026, 1280, 1281, 1536, 1537, 1538, 3840, 3841, 3842, 3856, 3857, 3858};
    private String[][] inputCache;
    private int currentMode;
    private static final String FT_DIR = "/tmp";
    private static final String[] MENUS = new String[]{"Project", "Functions", "Chooser", "Options"};
    private static final String[][] MENUITEMS = new String[][]{{"Quit"}, {"Dump", "Clear", "Threads", "Garbage", "Reset"}, {"Choose lobby", "Choose conf.", "Choose Emote"}, {"+Invisible"}};
    private static final String[][] MENUCMDS = new String[][]{{"QUIT"}, {"DUMP", "CLEAR", "THREADS", "GARBAGE", "RESET"}, {"LOBBY", "CONF", "EMOTE"}, {"INVIS"}};
    private Hashtable menuItems;
    private JMenu identitiesMenu;
    private Hashtable identitiesHash;
    private YahooIdentity currentIdentity;

    public SwingTestClient(String string, String string2, String string3, String string4) {
        super("jYMSG Test Client v2.2 : " + string);
        this.addWindowListener(new WindowHandler());
        if (string4 != null) {
            try {
                this.transcript = new PrintWriter(new FileOutputStream(string4));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.threadGroup = new ThreadGroup("Test Client Threads");
        this.setBackground(new Color(0xCCCCCC));
        this.outputTP = new JTextPane();
        this.outputTP.setEditable(false);
        this.outputTP.setPreferredSize(new Dimension(400, 250));
        this.outputDoc = this.outputTP.getDocument();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.modeL = new JList<String>(MODES);
        this.modeL.setVisibleRowCount(5);
        this.modeL.addListSelectionListener(this);
        this.sendB = new JButton("Send");
        this.sendB.addActionListener(this);
        jPanel2.add((Component)new JScrollPane(this.modeL), "Center");
        jPanel2.add((Component)this.sendB, "East");
        jPanel.add((Component)jPanel2, "North");
        this.inputLab = new JLabel[3];
        this.inputTF = new JTextField[3];
        jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
        jPanel2.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel(new GridLayout(0, 1));
        jPanel2.add((Component)jPanel4, "East");
        for (int i = 0; i < 3; ++i) {
            this.inputLab[i] = new JLabel("--------------------:", 4);
            jPanel3.add(this.inputLab[i]);
            this.inputTF[i] = new JTextField("", 40);
            jPanel4.add(this.inputTF[i]);
        }
        jPanel.add((Component)jPanel2, "Center");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)new JScrollPane(this.outputTP), "Center");
        container.add((Component)jPanel, "South");
        System.getProperties().put("ymsg.debug", "true");
        this.inputCache = new String[MODES.length][3];
        int n = this.findMode(3840);
        this.inputCache[n][0] = string;
        this.inputCache[n][1] = string2;
        this.inputCache[n][2] = string3;
        this.menuItems = new Hashtable();
        JMenuBar jMenuBar = new JMenuBar();
        MenuHandler menuHandler = new MenuHandler();
        for (int i = 0; i < MENUS.length; ++i) {
            jMenuBar.add(this.createMenu(i, menuHandler));
        }
        this.identitiesMenu = new JMenu("Identities");
        jMenuBar.add(this.identitiesMenu);
        this.setJMenuBar(jMenuBar);
        this.pack();
        this.show();
        this.modeL.setSelectedIndex(n);
        this.modeL.ensureIndexIsVisible(n);
        this.updateSelectedMode();
        MessageDecoderSettings messageDecoderSettings = new MessageDecoderSettings();
        messageDecoderSettings.setRespectTextFade(true);
        messageDecoderSettings.setRespectTextAlt(true);
        messageDecoderSettings.setEmoticonsDecoded(false);
        messageDecoderSettings.setOverrideFont(null, 10, 18, null);
        this.decoder = new MessageDecoder(messageDecoderSettings);
        this.spamBlock = new AntiSpam();
        this.emoteManager = new EmoteManager("./emote_user.dat", true);
        this.createStyledTextTemplates();
        this.conferences = new Vector();
    }

    public void finalize() {
        if (this.transcript != null) {
            this.transcript.close();
        }
    }

    private JMenu createMenu(int n, MenuHandler menuHandler) {
        JMenu jMenu = new JMenu(MENUS[n]);
        for (int i = 0; i < MENUITEMS[n].length; ++i) {
            JMenuItem jMenuItem;
            String string = MENUITEMS[n][i];
            if (string.startsWith("-")) {
                jMenu.addSeparator();
                continue;
            }
            switch (string.charAt(0)) {
                case '.': {
                    jMenuItem = new JMenuItem(string.substring(1));
                    jMenuItem.setEnabled(false);
                    break;
                }
                case '+': {
                    jMenuItem = new JCheckBoxMenuItem(string.substring(1));
                    break;
                }
                default: {
                    jMenuItem = new JMenuItem(string);
                }
            }
            jMenuItem.setActionCommand(MENUCMDS[n][i]);
            jMenuItem.addActionListener(menuHandler);
            jMenu.add(jMenuItem);
            this.menuItems.put(MENUCMDS[n][i], jMenuItem);
        }
        return jMenu;
    }

    private void createStyledTextTemplates() {
        this.styledOutRoot = MutableMessageElement.createRoot();
        MutableMessageElement mutableMessageElement = MutableMessageElement.createIndexedColour(8);
        this.styledOutRoot.add(mutableMessageElement);
        MutableMessageElement mutableMessageElement2 = MutableMessageElement.createItalic();
        mutableMessageElement.add(mutableMessageElement2);
        this.styledOutBody = MutableMessageElement.createText("");
        mutableMessageElement2.add(this.styledOutBody);
    }

    private void setInputCache(int n, int n2, String string) {
        this.inputCache[n][n2] = string;
        if (this.currentMode == n) {
            this.inputTF[n2].setText(string);
        }
    }

    private int findMode(int n) {
        for (int i = 0; i < MAPPINGS.length; ++i) {
            if (MAPPINGS[i] != n) continue;
            return i;
        }
        return -1;
    }

    private void attemptLogin() throws Exception {
        int n = this.findMode(3840);
        String string = this.inputCache[n][0];
        String string2 = this.inputCache[n][1];
        try {
            System.out.println("Login[");
            this.session.login(string, string2);
            System.out.println("Login]");
        }
        catch (LoginRefusedException loginRefusedException) {
            switch ((int)loginRefusedException.getStatus()) {
                case 3: {
                    System.out.println("Yahoo doesn't recognise that username.");
                    break;
                }
                case 13: {
                    System.out.println("Yahoo refused our connection.  Password incorrect?");
                    break;
                }
                case 14: {
                    System.out.println("Your account is locked");
                    AccountLockedException accountLockedException = (AccountLockedException)loginRefusedException;
                    if (accountLockedException.getWebPage() == null) break;
                    System.out.println("Please visit: " + accountLockedException.getWebPage().toString());
                }
            }
            throw loginRefusedException;
        }
        if (this.session.getSessionStatus() == 2) {
            YahooIdentity[] yahooIdentityArray;
            if (this.factory == null) {
                this.factory = new SwingModelFactory(this.session);
            }
            if (this.groupDisplay == null || !this.groupDisplay.isDisplayable()) {
                yahooIdentityArray = new GroupDisplay();
                yahooIdentityArray.setModel(this.factory.createTreeModel(true));
            }
            yahooIdentityArray = this.session.getIdentities();
            this.identitiesHash = new Hashtable();
            ButtonGroup buttonGroup = new ButtonGroup();
            this.identitiesMenu.removeAll();
            MenuHandler menuHandler = new MenuHandler();
            JRadioButtonMenuItem jRadioButtonMenuItem = this._makeRBMI("[default]", menuHandler, "IDENT_NONE", true);
            buttonGroup.add(jRadioButtonMenuItem);
            this.identitiesMenu.add(jRadioButtonMenuItem);
            for (int i = 0; i < yahooIdentityArray.length; ++i) {
                jRadioButtonMenuItem = this._makeRBMI(yahooIdentityArray[i].getId(), menuHandler, "IDENT" + yahooIdentityArray[i].getId(), false);
                buttonGroup.add(jRadioButtonMenuItem);
                this.identitiesMenu.add(jRadioButtonMenuItem);
                this.identitiesHash.put(yahooIdentityArray[i].getId(), yahooIdentityArray[i]);
            }
            this.currentIdentity = null;
        } else {
            System.out.println("Sorry, there was a problem connecting");
        }
    }

    private JRadioButtonMenuItem _makeRBMI(String string, MenuHandler menuHandler, String string2, boolean bl) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        jRadioButtonMenuItem.addActionListener(menuHandler);
        jRadioButtonMenuItem.setActionCommand(string2);
        jRadioButtonMenuItem.setSelected(bl);
        return jRadioButtonMenuItem;
    }

    protected void updateSelectedMode() {
        int n;
        for (n = 0; n < 3; ++n) {
            this.inputCache[this.currentMode][n] = this.inputTF[n].getText();
        }
        this.currentMode = this.modeL.getSelectedIndex();
        if (this.currentMode < 0) {
            this.currentMode = 0;
        }
        for (n = 0; n < 3; ++n) {
            this.inputLab[n].setText(LABELS[this.currentMode][n] + " :");
            this.inputTF[n].setEnabled(!LABELS[this.currentMode][n].equals("-"));
        }
        for (n = 0; n < 3; ++n) {
            this.inputTF[n].setText(this.inputCache[this.currentMode][n]);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String[] stringArray = new String[this.inputTF.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.inputTF[i].getText().trim();
        }
        String string = this.currentIdentity == null ? "[default]" : this.currentIdentity.getId();
        try {
            if (object == this.sendB) {
                int n = 0;
                switch (MAPPINGS[this.modeL.getSelectedIndex()]) {
                    case 256: {
                        if (this.currentIdentity != null) {
                            this.session.sendMessage(stringArray[0], stringArray[1], this.currentIdentity);
                        } else {
                            this.session.sendMessage(stringArray[0], stringArray[1]);
                        }
                        this._appendOutput(string + "->" + stringArray[0] + " : " + stringArray[1] + "\n");
                        this._pushDown();
                        n = 2;
                        break;
                    }
                    case 257: {
                        if (this.currentIdentity != null) {
                            this.session.sendBuzz(stringArray[0], this.currentIdentity);
                            break;
                        }
                        this.session.sendBuzz(stringArray[0]);
                        break;
                    }
                    case 258: {
                        this.styledOutBody.setText(stringArray[1]);
                        this.session.sendMessage(stringArray[0], this.styledOutRoot.toYahooIM());
                        n = 2;
                        break;
                    }
                    case 259: {
                        this.session.sendFileTransfer(stringArray[0], stringArray[1], stringArray[2]);
                        n = 7;
                        break;
                    }
                    case 512: {
                        this.session.addFriend(stringArray[0], stringArray[1]);
                        n = 3;
                        break;
                    }
                    case 513: {
                        this.session.removeFriend(stringArray[0], stringArray[1]);
                        n = 3;
                        break;
                    }
                    case 515: {
                        this.session.ignoreContact(stringArray[0], stringArray[1].equalsIgnoreCase("on"));
                        n = 3;
                        break;
                    }
                    case 768: {
                        YahooConference yahooConference;
                        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], ",");
                        String[] stringArray2 = new String[stringTokenizer.countTokens()];
                        for (int i = 0; i < stringArray2.length; ++i) {
                            stringArray2[i] = stringTokenizer.nextToken().trim();
                        }
                        YahooConference yahooConference2 = yahooConference = this.currentIdentity != null ? this.session.createConference(stringArray2, stringArray[1], this.currentIdentity) : this.session.createConference(stringArray2, stringArray[1]);
                        if (!this.conferences.contains(yahooConference)) {
                            this.conferences.addElement(yahooConference);
                        }
                        n = 3;
                        break;
                    }
                    case 769: {
                        this.session.acceptConferenceInvite(this.currentConf);
                        n = 1;
                        break;
                    }
                    case 770: {
                        this.session.declineConferenceInvite(this.currentConf, stringArray[1]);
                        n = 3;
                        break;
                    }
                    case 771: {
                        this.session.extendConference(this.currentConf, stringArray[1], stringArray[2]);
                        n = 6;
                        break;
                    }
                    case 772: {
                        this.session.sendConferenceMessage(this.currentConf, stringArray[1]);
                        n = 2;
                        break;
                    }
                    case 773: {
                        this.session.leaveConference(this.currentConf);
                        n = 1;
                        break;
                    }
                    case 1024: {
                        if (this.currentLobby != null) {
                            if (this.currentIdentity != null) {
                                this.session.chatLogin(this.currentLobby, this.currentIdentity);
                            } else {
                                this.session.chatLogin(this.currentLobby);
                            }
                            if (this.factory == null) {
                                this.factory = new SwingModelFactory(this.session);
                            }
                            if (this.userDisplay == null || !this.userDisplay.isDisplayable()) {
                                this.userDisplay = new UserDisplay();
                            }
                            this.userDisplay.setModel(this.factory.createListModel(this.currentLobby, true));
                            this.userDisplay.show();
                        }
                        n = 0;
                        break;
                    }
                    case 1025: {
                        this._appendOutput("[" + this.currentLobby.getNetworkName() + "]  " + string + " : " + stringArray[0] + "\n");
                        this._pushDown();
                        this.session.sendChatMessage(stringArray[0]);
                        n = 1;
                        break;
                    }
                    case 1026: {
                        this.session.chatLogout();
                        this.userDisplay.setModel(SwingModelFactory.getEmptyListModel());
                        n = 0;
                        break;
                    }
                    case 1027: {
                        String string2;
                        if (stringArray[0].length() <= 0) {
                            string2 = this.emoteManager.getRoomEmote(stringArray[1]);
                        } else {
                            string2 = this.emoteManager.getUserEmote(stringArray[1]);
                            string2 = EmoteManager.encodeEmote(stringArray[0], string2);
                        }
                        this._appendOutput("[" + this.currentLobby.getNetworkName() + "]  " + string + " : <" + string2 + ">\n");
                        this._pushDown();
                        if (string2 != null && string2.length() > 0) {
                            this.session.sendChatEmote(string2);
                        }
                        n = 1;
                        break;
                    }
                    case 1280: {
                        this.session.activateIdentity(this.currentIdentity, true);
                        n = 0;
                        break;
                    }
                    case 1281: {
                        this.session.activateIdentity(this.currentIdentity, false);
                        n = 0;
                        break;
                    }
                    case 1536: {
                        this.session.addTypingNotification(stringArray[0], null);
                        n = 3;
                        break;
                    }
                    case 1537: {
                        this.session.removeTypingNotification(stringArray[0]);
                        n = 3;
                        break;
                    }
                    case 1538: {
                        this.session.keyTyped(stringArray[0]);
                        n = 0;
                        break;
                    }
                    case 3840: {
                        this.updateSelectedMode();
                        new LoginThread();
                        n = 2;
                        break;
                    }
                    case 3841: {
                        this.session.logout();
                        n = 0;
                        break;
                    }
                    case 3842: {
                        this.session.refreshFriends();
                        n = 0;
                        break;
                    }
                    case 3856: {
                        this.session.__test1(stringArray[0], stringArray[1]);
                        n = 0;
                        break;
                    }
                    case 3857: {
                        this.session.__test2();
                        n = 0;
                        break;
                    }
                    case 3858: {
                        System.out.println("COMMENT: " + stringArray[0]);
                        n = 1;
                        break;
                    }
                    default: {
                        System.err.println("Unknown option selected");
                    }
                }
                for (int i = 0; i < 3; ++i) {
                    if ((n & 1) > 0) {
                        this.inputTF[i].setText("");
                    }
                    n >>= 1;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void _appendOutput(String string) {
        try {
            this.outputDoc.insertString(this.outputDoc.getLength(), string, null);
            this._log(string);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void _pushDown() {
        try {
            this.outputTP.setCaretPosition(this.outputTP.getText().length());
            this.outputTP.scrollRectToVisible(new Rectangle(0, this.outputTP.getSize().height, 1, 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _log(String string) {
        if (this.transcript != null) {
            this.transcript.print(string);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateSelectedMode();
    }

    private String _attrs(YahooChatUser yahooChatUser) {
        String string = "";
        string = yahooChatUser.isMale() ? string + "(M" : (yahooChatUser.isFemale() ? string + "(F" : string + "(?");
        if (yahooChatUser.hasWebcam()) {
            string = string + "C";
        }
        string = string + ")";
        return string;
    }

    void dump() {
        YahooGroup[] yahooGroupArray = this.session.getGroups();
        for (int i = 0; i < yahooGroupArray.length; ++i) {
            System.out.println(yahooGroupArray[i].getName() + ":");
            Vector vector = yahooGroupArray[i].getMembers();
            for (int j = 0; j < vector.size(); ++j) {
                YahooUser yahooUser = (YahooUser)vector.elementAt(j);
                System.out.println("  " + yahooUser.toString());
            }
        }
        this.dumpUsers();
        String[] stringArray = this.session.getCookies();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("Cookie " + i + " : " + stringArray[i]);
        }
        System.out.println("Id:" + this.currentIdentity);
    }

    void dumpChat() {
        if (this.currentLobby != null) {
            Vector vector = this.currentLobby.getMembers();
            for (int i = 0; i < vector.size(); ++i) {
                YahooChatUser yahooChatUser = (YahooChatUser)vector.elementAt(i);
                System.out.println(yahooChatUser.toString());
            }
        }
    }

    void dumpUsers() {
        Hashtable hashtable = this.session.getUsers();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(string + " ==> " + ((YahooUser)hashtable.get(string)).toString());
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-u:")) {
                string = stringArray[i].substring(3);
            }
            if (stringArray[i].startsWith("-p:")) {
                string2 = stringArray[i].substring(3);
            }
            if (stringArray[i].startsWith("-m:")) {
                string3 = stringArray[i].substring(3);
            }
            if (!stringArray[i].startsWith("-T:")) continue;
            string4 = stringArray[i].substring(3);
        }
        if (stringArray.length == 0) {
            System.out.println("Usage: [-u:<username>] [-p:<password>] [-m:direct|socks|http] [-T:<transcript file>]");
        }
        SwingTestClient swingTestClient = new SwingTestClient(string, string2, string3, string4);
    }

    class GroupDisplay
    extends JFrame {
        JTree groupT;

        GroupDisplay() {
            super("Groups");
            this.groupT = new JTree();
            this.groupT.setCellRenderer(new CellRenderer());
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)new WindowCloser("Friends", this), "North");
            container.add((Component)new JScrollPane(this.groupT), "Center");
            this.pack();
            this.show();
        }

        void setModel(TreeModel treeModel) {
            this.groupT.setModel(treeModel);
        }

        class CellRenderer
        extends JLabel
        implements TreeCellRenderer {
            CellRenderer() {
            }

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                if (object instanceof YahooUser) {
                    YahooUser yahooUser = (YahooUser)object;
                    this.setText(yahooUser.getId() + " (" + Long.toHexString(yahooUser.getStatus()) + ")");
                } else if (object instanceof YahooGroup) {
                    this.setText(((YahooGroup)object).getName());
                } else {
                    this.setText(object.toString());
                }
                this.setBackground(bl ? Color.lightGray : Color.white);
                return this;
            }
        }
    }

    class UserDisplay
    extends JFrame {
        JList userL;

        UserDisplay() {
            super("Users");
            this.userL = new JList();
            this.userL.setCellRenderer(new CellRenderer());
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)new WindowCloser("Chatroom users", this), "North");
            container.add((Component)new JScrollPane(this.userL), "Center");
            this.pack();
            this.show();
        }

        void setModel(ListModel listModel) {
            this.userL.setModel(listModel);
        }

        class CellRenderer
        extends JLabel
        implements ListCellRenderer {
            CellRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof YahooUser) {
                    this.setText(((YahooUser)object).getId());
                } else if (object instanceof YahooChatUser) {
                    this.setText(((YahooChatUser)object).getId() + "   " + SwingTestClient.this._attrs((YahooChatUser)object));
                } else {
                    this.setText(object.toString());
                }
                this.setBackground(bl ? Color.lightGray : Color.white);
                return this;
            }
        }
    }

    class WindowCloser
    extends JPanel
    implements ActionListener {
        JFrame window;

        WindowCloser(String string, JFrame jFrame) {
            this.window = jFrame;
            JButton jButton = new JButton("Close");
            jButton.addActionListener(this);
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)new JLabel(string, 2), "Center");
            this.add((Component)jButton, "East");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.window.dispose();
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            SwingTestClient.this.hide();
            SwingTestClient.this.dispose();
            System.exit(0);
        }
    }

    class LoginThread
    extends Thread {
        LoginThread() {
            super(SwingTestClient.this.threadGroup, "Login Thread");
            this.start();
        }

        public void run() {
            int n = SwingTestClient.this.findMode(3840);
            String string = SwingTestClient.this.inputCache[n][2];
            SwingTestClient.this.session = string.equals("socks") ? new Session(new SOCKSConnectionHandler("autoproxy", 1080)) : (string.equals("http") ? new Session(new HTTPConnectionHandler("proxy", 8080)) : (string.equals("direct") ? new Session(new DirectConnectionHandler()) : new Session()));
            SwingTestClient.this.session.addSessionListener(new SessionHandler());
            System.out.println(SwingTestClient.this.session.getConnectionHandler().toString());
            try {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)SwingTestClient.this.menuItems.get("INVIS");
                if (jCheckBoxMenuItem.getState()) {
                    SwingTestClient.this.session.setStatus(12L);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                SwingTestClient.this.attemptLogin();
                SwingTestClient.this.dump();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class Selector
    extends JFrame
    implements ActionListener,
    ListSelectionListener {
        JList selectorL;
        JButton exitB;
        Vector list;
        int selected;
        String title;
        String buttonText;

        Selector(Vector vector, String string, String string2) {
            super("Selector");
            this.list = vector;
            this.title = string;
            this.buttonText = string2;
            this.selected = -2;
            this.initGfx();
        }

        int getSelected() {
            while (this.selected < -1) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.setVisible(false);
            this.dispose();
            return this.selected;
        }

        void initGfx() {
            this.selectorL = new JList(this.list);
            this.selectorL.addListSelectionListener(this);
            if (this.buttonText != null) {
                this.exitB = new JButton(this.buttonText);
                this.exitB.addActionListener(this);
            }
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)new JLabel("Select an item from the list: " + this.title), "North");
            container.add((Component)this.selectorL, "Center");
            if (this.buttonText != null) {
                container.add((Component)this.exitB, "South");
            }
            this.pack();
            this.show();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.selected = this.selectorL.getSelectedIndex();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.selected = -1;
        }
    }

    class EmoteChooser
    extends Thread {
        EmoteChooser() {
            super(SwingTestClient.this.threadGroup, "Emote Choose");
            this.start();
        }

        public void run() {
            Vector vector = SwingTestClient.this.emoteManager.getNames();
            if (vector.size() <= 0) {
                return;
            }
            Selector selector = new Selector(vector, "Choose an Emote", null);
            int n = selector.getSelected();
            int n2 = SwingTestClient.this.findMode(1027);
            SwingTestClient.this.setInputCache(n2, 1, (String)vector.elementAt(n));
        }
    }

    class ConfChooser
    extends Thread {
        ConfChooser() {
            super(SwingTestClient.this.threadGroup, "Conference Choose");
            this.start();
        }

        public void run() {
            if (SwingTestClient.this.conferences.size() <= 0) {
                return;
            }
            Selector selector = new Selector(SwingTestClient.this.conferences, "Choose a conference", null);
            SwingTestClient.this.currentConf = (YahooConference)SwingTestClient.this.conferences.elementAt(selector.getSelected());
            int n = SwingTestClient.this.findMode(768);
            for (int i = 1; i < 6; ++i) {
                SwingTestClient.this.setInputCache(n + i, 0, SwingTestClient.this.currentConf.getName());
            }
        }
    }

    class LobbyChooser
    extends Thread {
        LobbyChooser() {
            super(SwingTestClient.this.threadGroup, "Lobby Chooser");
            this.start();
        }

        public void run() {
            try {
                YahooChatLobby yahooChatLobby;
                Selector selector;
                int n;
                Object object;
                if (SwingTestClient.this.rootCategory == null) {
                    SwingTestClient.this.rootCategory = YahooChatCategory.loadCategories(SwingTestClient.this.session);
                }
                YahooChatCategory yahooChatCategory = SwingTestClient.this.rootCategory;
                String string = "<Root>";
                while (yahooChatCategory.getCategories().size() > 0) {
                    object = null;
                    int n2 = yahooChatCategory.getPublicRooms().size();
                    if (n2 > 0) {
                        object = "Rooms:" + n2;
                    }
                    if ((n = (selector = new Selector(yahooChatCategory.getCategories(), string, (String)object)).getSelected()) < 0) break;
                    yahooChatCategory = (YahooChatCategory)yahooChatCategory.getCategories().elementAt(n);
                    string = string + "->[" + yahooChatCategory.getName() + "]";
                }
                selector = new Selector(yahooChatCategory.getPublicRooms(), "Public rooms", null);
                n = selector.getSelected();
                object = (YahooChatRoom)yahooChatCategory.getPublicRooms().elementAt(n);
                selector = new Selector(((YahooChatRoom)object).getLobbies(), ((YahooChatRoom)object).getName() + " lobbies", null);
                n = selector.getSelected();
                SwingTestClient.this.currentLobby = yahooChatLobby = (YahooChatLobby)((YahooChatRoom)object).getLobbies().elementAt(n);
                SwingTestClient.this.setInputCache(SwingTestClient.this.findMode(1024), 0, SwingTestClient.this.currentLobby.getNetworkName());
                System.out.println(SwingTestClient.this.currentLobby.toString());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    class SessionHandler
    extends SessionAdapter {
        SessionHandler() {
        }

        public void messageReceived(SessionEvent sessionEvent) {
            SwingTestClient.this._appendOutput(sessionEvent.getFrom() + "->" + sessionEvent.getTo() + " : ");
            SwingTestClient.this.decoder.appendToDocument(sessionEvent.getMessage(), SwingTestClient.this.outputDoc);
            SwingTestClient.this._pushDown();
            SwingTestClient.this._log(sessionEvent.getMessage());
        }

        public void errorPacketReceived(SessionErrorEvent sessionErrorEvent) {
            if (sessionErrorEvent.getService() != 133) {
                SwingTestClient.this._appendOutput("ERROR : " + sessionErrorEvent.getMessage() + "\n");
                SwingTestClient.this._pushDown();
                System.err.println(sessionErrorEvent.toString());
            }
        }

        public void inputExceptionThrown(SessionExceptionEvent sessionExceptionEvent) {
            SwingTestClient.this._appendOutput("ERROR : " + sessionExceptionEvent.getMessage() + "\n");
            SwingTestClient.this._pushDown();
            YMSG9BadFormatException yMSG9BadFormatException = (YMSG9BadFormatException)sessionExceptionEvent.getException();
            System.err.println("**Message:\n" + sessionExceptionEvent.toString());
            System.err.println("**Exception:");
            yMSG9BadFormatException.printStackTrace();
            System.err.println("**Cause:");
            yMSG9BadFormatException.getCausingThrowable().printStackTrace();
        }

        public void offlineMessageReceived(SessionEvent sessionEvent) {
            SwingTestClient.this._appendOutput("At " + sessionEvent.getTimestamp().toString() + "\n");
            SwingTestClient.this._appendOutput(sessionEvent.getFrom() + " : " + SwingTestClient.this.decoder.decodeToText(sessionEvent.getMessage()) + "\n");
            SwingTestClient.this._pushDown();
        }

        public void fileTransferReceived(SessionFileTransferEvent sessionFileTransferEvent) {
            this.messageReceived(sessionFileTransferEvent);
            System.out.println(sessionFileTransferEvent.getLocation().toString());
            try {
                SwingTestClient.this.session.saveFileTransferTo(sessionFileTransferEvent, SwingTestClient.FT_DIR);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void connectionClosed(SessionEvent sessionEvent) {
            SwingTestClient.this._appendOutput("***Connection closed***\n");
            SwingTestClient.this._pushDown();
            System.out.println("**Connection closed**");
        }

        public void listReceived(SessionEvent sessionEvent) {
            SwingTestClient.this.dump();
        }

        public void friendsUpdateReceived(SessionFriendEvent sessionFriendEvent) {
            YahooUser[] yahooUserArray = sessionFriendEvent.getFriends();
            for (int i = 0; i < yahooUserArray.length; ++i) {
                System.out.println("Updated: " + yahooUserArray[i].toString());
            }
        }

        public void friendAddedReceived(SessionFriendEvent sessionFriendEvent) {
            System.out.println(sessionFriendEvent.toString());
        }

        public void friendRemovedReceived(SessionFriendEvent sessionFriendEvent) {
            System.out.println(sessionFriendEvent.toString());
        }

        public void contactRequestReceived(SessionEvent sessionEvent) {
            try {
                SwingTestClient.this.session.rejectContact(sessionEvent, "Not now, thanks");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void conferenceInviteReceived(SessionConferenceEvent sessionConferenceEvent) {
            System.out.println(sessionConferenceEvent.toString());
            try {
                SwingTestClient.this.session.declineConferenceInvite(sessionConferenceEvent.getRoom(), "Sorry!");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void conferenceInviteDeclinedReceived(SessionConferenceEvent sessionConferenceEvent) {
            System.out.println(sessionConferenceEvent.toString());
        }

        public void conferenceLogonReceived(SessionConferenceEvent sessionConferenceEvent) {
            System.out.println(sessionConferenceEvent.toString());
        }

        public void conferenceLogoffReceived(SessionConferenceEvent sessionConferenceEvent) {
            System.out.println(sessionConferenceEvent.toString());
        }

        public void conferenceMessageReceived(SessionConferenceEvent sessionConferenceEvent) {
            System.out.println(sessionConferenceEvent.toString());
        }

        public void chatLogonReceived(SessionChatEvent sessionChatEvent) {
            SwingTestClient.this._appendOutput("[" + sessionChatEvent.getLobby().getNetworkName() + "]  " + sessionChatEvent.getChatUser().getId() + " joined\n");
            SwingTestClient.this._pushDown();
        }

        public void chatLogoffReceived(SessionChatEvent sessionChatEvent) {
            SwingTestClient.this._appendOutput("[" + sessionChatEvent.getLobby().getNetworkName() + "]  " + sessionChatEvent.getChatUser().getId() + " has left\n");
            SwingTestClient.this._pushDown();
        }

        public void chatMessageReceived(SessionChatEvent sessionChatEvent) {
            String string;
            String string2 = sessionChatEvent.getChatUser().getId();
            int n = SwingTestClient.this.spamBlock.getViolations(string2, string = sessionChatEvent.getMessage());
            if (n > 0) {
                System.out.println("Blocked: " + string2 + "/" + n + ": " + string);
            } else {
                if (sessionChatEvent.isEmote()) {
                    string = "<" + string + ">";
                }
                SwingTestClient.this._appendOutput("[" + sessionChatEvent.getLobby().getNetworkName() + "]  " + string2 + " : ");
                SwingTestClient.this.decoder.appendToDocument(string, SwingTestClient.this.outputDoc);
                SwingTestClient.this._pushDown();
                SwingTestClient.this._log(string);
            }
        }

        public void chatConnectionClosed(SessionEvent sessionEvent) {
            SwingTestClient.this._appendOutput("**Chat connection closed**\n");
            SwingTestClient.this._pushDown();
            System.out.println("**Chat connection closed**");
        }
    }

    class MenuHandler
    implements ActionListener {
        MenuHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = actionEvent.getActionCommand();
                if (string.equals("QUIT")) {
                    System.exit(0);
                } else if (string.equals("DUMP")) {
                    SwingTestClient.this.dump();
                    SwingTestClient.this.dumpChat();
                } else if (string.equals("CLEAR")) {
                    SwingTestClient.this.outputDoc.remove(0, SwingTestClient.this.outputDoc.getLength());
                } else if (string.equals("LOBBY")) {
                    new LobbyChooser();
                } else if (string.equals("CONF")) {
                    new ConfChooser();
                } else if (string.equals("EMOTE")) {
                    new EmoteChooser();
                } else if (string.equals("THREADS")) {
                    System.out.println("Active count: " + Thread.activeCount());
                    Thread[] threadArray = new Thread[Thread.activeCount()];
                    Thread.enumerate(threadArray);
                    for (int i = 0; i < threadArray.length; ++i) {
                        System.out.println("Thread " + i + ": " + threadArray[i]);
                    }
                } else if (string.equals("GARBAGE")) {
                    System.gc();
                } else if (string.equals("RESET")) {
                    SwingTestClient.this.session.reset();
                } else if (string.equals("IDENT_NONE")) {
                    SwingTestClient.this.currentIdentity = null;
                } else if (string.startsWith("IDENT")) {
                    SwingTestClient.this.currentIdentity = (YahooIdentity)SwingTestClient.this.identitiesHash.get(string.substring(5));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

