/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.dtd;

import com.wutka.dtd.DTDExternalID;
import com.wutka.dtd.DTDOutput;
import com.wutka.dtd.DTDReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;

public class DTDEntity
implements DTDOutput {
    public String name;
    public boolean isParsed;
    public String value;
    public DTDExternalID externalID;
    public String ndata;
    public Object defaultLocation;

    public DTDEntity() {
    }

    public DTDEntity(String string) {
        this.name = string;
    }

    public DTDEntity(String string, Object object) {
        this.name = string;
        this.defaultLocation = object;
    }

    public void write(PrintWriter printWriter) throws IOException {
        printWriter.print("<!ENTITY ");
        if (this.isParsed) {
            printWriter.print(" % ");
        }
        printWriter.print(this.name);
        if (this.value != null) {
            char c = '\"';
            if (this.value.indexOf(c) >= 0) {
                c = '\'';
            }
            printWriter.print(c);
            printWriter.print(this.value);
            printWriter.print(c);
        } else {
            this.externalID.write(printWriter);
            if (this.ndata != null) {
                printWriter.print(" NDATA ");
                printWriter.print(this.ndata);
            }
        }
        printWriter.println(">");
    }

    public String getExternalId() {
        return this.externalID.system;
    }

    public Reader getReader() throws IOException {
        if (this.externalID == null) {
            return null;
        }
        Reader reader = this.getReader(this.externalID.system);
        return reader;
    }

    public InputStream getInputStream(String string) {
        try {
            if (this.defaultLocation instanceof File) {
                File file = (File)this.defaultLocation;
                return new FileInputStream(new File(file, string));
            }
            if (this.defaultLocation instanceof URL) {
                URL uRL = new URL((URL)this.defaultLocation, string);
                return uRL.openStream();
            }
            return new FileInputStream(new File(string));
        }
        catch (Exception exception) {
            System.out.println("Failed first attempt at opening " + string + " : " + exception);
            try {
                URL uRL = new URL(string);
                return uRL.openStream();
            }
            catch (Exception exception2) {
                System.out.println("Failed second attempt at opening " + string + " : " + exception2);
                return null;
            }
        }
    }

    public Reader getReader(String string) {
        DTDReader dTDReader = new DTDReader();
        return dTDReader.makeBufferedReader(this.getInputStream(string));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DTDEntity)) {
            return false;
        }
        DTDEntity dTDEntity = (DTDEntity)object;
        if (this.name == null ? dTDEntity.name != null : !this.name.equals(dTDEntity.name)) {
            return false;
        }
        if (this.isParsed != dTDEntity.isParsed) {
            return false;
        }
        if (this.value == null ? dTDEntity.value != null : !this.value.equals(dTDEntity.value)) {
            return false;
        }
        if (this.externalID == null ? dTDEntity.externalID != null : !this.externalID.equals(dTDEntity.externalID)) {
            return false;
        }
        return !(this.ndata == null ? dTDEntity.ndata != null : !this.ndata.equals(dTDEntity.ndata));
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setIsParsed(boolean bl) {
        this.isParsed = bl;
    }

    public boolean isParsed() {
        return this.isParsed;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setExternalID(DTDExternalID dTDExternalID) {
        this.externalID = dTDExternalID;
    }

    public DTDExternalID getExternalID() {
        return this.externalID;
    }

    public void setNdata(String string) {
        this.ndata = string;
    }

    public String getNdata() {
        return this.ndata;
    }
}

