/*
 * Decompiled with CFR 0.152.
 */
package DTDDoc;

import DTDDoc.DtdHighlighter;
import com.uwyn.jhighlight.highlighter.ExplicitStateHighlighter;
import com.uwyn.jhighlight.renderer.XhtmlRenderer;
import com.uwyn.jhighlight.tools.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class DtdXhtmlRenderer
extends XhtmlRenderer {
    public static final Map DEFAULT_CSS = new HashMap(){
        {
            this.put("h1", "font-family: sans-serif; font-size: 16pt; font-weight: bold; color: rgb(0,0,0); background: rgb(210,210,210); border: solid 1px black; padding: 5px; text-align: center;");
            this.put("code", "color: rgb(0,0,0); font-family: monospace; font-size: 12px; white-space: nowrap;");
            this.put(".dtd_plain", "color: rgb(0,0,0);");
            this.put(".dtd_char_data", "color: rgb(0,0,0);");
            this.put(".dtd_tag_symbols", "color: rgb(0,59,255);");
            this.put(".dtd_comment", "color: rgb(147,147,147); background-color: rgb(247,247,247);");
            this.put(".dtd_attribute_value", "color: rgb(193,0,0);");
            this.put(".dtd_attribute_name", "color: rgb(0,0,0); font-weight: bold;");
            this.put(".dtd_processing_instruction", "color: rgb(0,0,0); font-weight: bold; font-style: italic;");
            this.put(".dtd_tag_name", "color: rgb(0,55,255);");
            this.put(".dtd_dtddoc_tag", "color: rgb(0,55,255);");
        }
    };

    protected Map getDefaultCssStyles() {
        return DEFAULT_CSS;
    }

    protected String getCssClass(int style) {
        switch (style) {
            case 1: {
                return "dtd_plain";
            }
            case 2: {
                return "dtd_char_data";
            }
            case 3: {
                return "dtd_tag_symbols";
            }
            case 4: {
                return "dtd_comment";
            }
            case 5: {
                return "dtd_attribute_value";
            }
            case 6: {
                return "dtd_attribute_name";
            }
            case 7: {
                return "dtd_processing_instruction";
            }
            case 8: {
                return "dtd_tag_name";
            }
            case 9: {
                return "dtd_dtddoc_tag";
            }
            case 10: {
                return "dtd_keyword";
            }
        }
        return null;
    }

    protected ExplicitStateHighlighter getHighlighter() {
        return new DtdHighlighter();
    }

    public void highlight(Reader in, Writer out) throws IOException {
        String line;
        ExplicitStateHighlighter highlighter = this.getHighlighter();
        BufferedReader r = new BufferedReader(in);
        BufferedWriter w = new BufferedWriter(out);
        byte previous_style = 0;
        boolean newline = false;
        while ((line = r.readLine()) != null) {
            int length;
            line = line + "\n";
            line = StringUtils.convertTabsToSpaces(line, 4);
            StringReader lineReader = new StringReader(line);
            highlighter.setReader(lineReader);
            for (int index = 0; index < line.length(); index += length) {
                String css_class;
                byte style = highlighter.getNextToken();
                length = highlighter.getTokenLength();
                String token = StringUtils.replace(line.substring(index, index + length), "\n", "");
                if ((style != previous_style || newline) && token.length() > 0 && (css_class = this.getCssClass(style)) != null) {
                    if (previous_style != 0 && !newline) {
                        w.write("</span>");
                    }
                    w.write("<span class=\"" + css_class + "\">");
                    previous_style = style;
                }
                newline = false;
                w.write(StringUtils.encodeHtml(token));
            }
            if (previous_style != 0) {
                w.write("</span>");
            }
            w.write("\n");
            newline = true;
            previous_style = 0;
        }
        w.flush();
    }
}

