/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jcifs.Config;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbNamedPipe;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.DefaultProperties;
import net.sourceforge.jtds.jdbc.SharedSocket;
import net.sourceforge.jtds.jdbc.Support;

public class SharedNamedPipe
extends SharedSocket {
    private SmbNamedPipe pipe;

    public SharedNamedPipe(ConnectionJDBC2 connection) throws IOException {
        super(connection.getBufferDir(), connection.getTdsVersion(), connection.getServerType());
        int timeout = connection.getSocketTimeout() * 1000;
        String val = String.valueOf(timeout > 0 ? timeout : Integer.MAX_VALUE);
        Config.setProperty("jcifs.smb.client.responseTimeout", val);
        Config.setProperty("jcifs.smb.client.soTimeout", val);
        NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication(connection.getDomainName(), connection.getUser(), connection.getPassword());
        StringBuffer url = new StringBuffer(32);
        url.append("smb://");
        url.append(connection.getServerName());
        url.append("/IPC$");
        String instanceName = connection.getInstanceName();
        if (instanceName != null && instanceName.length() != 0) {
            url.append("/MSSQL$");
            url.append(instanceName);
        }
        String namedPipePath = DefaultProperties.getNamedPipePath(connection.getServerType());
        url.append(namedPipePath);
        this.setPipe(new SmbNamedPipe(url.toString(), 3, auth));
        this.setOut(new DataOutputStream(this.getPipe().getNamedPipeOutputStream()));
        int bufferSize = Support.calculateNamedPipeBufferSize(connection.getTdsVersion(), connection.getPacketSize());
        this.setIn(new DataInputStream(new BufferedInputStream(this.getPipe().getNamedPipeInputStream(), bufferSize)));
    }

    boolean isConnected() {
        return this.getPipe() != null;
    }

    void close() throws IOException {
        super.close();
        this.getOut().close();
        this.getIn().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceClose() {
        try {
            this.getOut().close();
        }
        catch (IOException e) {
        }
        finally {
            this.setOut(null);
        }
        try {
            this.getIn().close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.setIn(null);
        }
        this.setPipe(null);
    }

    private SmbNamedPipe getPipe() {
        return this.pipe;
    }

    private void setPipe(SmbNamedPipe pipe) {
        this.pipe = pipe;
    }

    protected void setTimeout(int timeout) {
    }
}

