/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.messaging;

import com.sun.jbi.messaging.EndpointReference;
import com.sun.jbi.messaging.util.WSDLHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public abstract class RegisteredEndpoint
implements ServiceEndpoint {
    public static final int DYNAMIC = 10;
    public static final int INTERNAL = 20;
    public static final int EXTERNAL = 30;
    public static final int LINKED = 40;
    private QName mService;
    private String mEndpoint;
    private String mOwnerId;
    private boolean mActive;
    private HashMap mOperations;
    private QName[] mInterfaces;
    private Logger mLog = Logger.getLogger(this.getClass().getPackage().getName());

    public RegisteredEndpoint(QName service, String endpoint, String ownerId) {
        this.mOwnerId = ownerId;
        this.mService = service;
        this.mEndpoint = endpoint;
        this.mActive = true;
    }

    public String getEndpointName() {
        return this.mEndpoint;
    }

    public QName getServiceName() {
        return this.mService;
    }

    public String getOwnerId() {
        return this.mOwnerId;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public abstract int getType();

    public void setActive(boolean isActive) {
        this.mActive = isActive;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof RegisteredEndpoint) {
            RegisteredEndpoint target = (RegisteredEndpoint)obj;
            if (target.mService.equals(this.mService) && target.mEndpoint.equals(this.mEndpoint) && target.mOwnerId.equals(this.mOwnerId)) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        return this.mService.hashCode() ^ this.mEndpoint.hashCode() ^ this.mOwnerId.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("          Owner:     ");
        sb.append(this.mOwnerId);
        sb.append("  Active: ");
        sb.append(this.mActive ? "True" : "False");
        sb.append("\n          Service:   ");
        sb.append(this.mService);
        sb.append("\n          Endpoint:  ");
        sb.append(this.mEndpoint);
        sb.append("\n");
        if (this.mOperations != null) {
            sb.append("          Operations Count: ");
            sb.append(this.mOperations.size());
            sb.append("\n");
            Iterator i = this.mOperations.values().iterator();
            while (i.hasNext()) {
                sb.append("            ");
                sb.append(i.next().toString());
                sb.append("\n");
            }
        }
        if (this.mInterfaces != null) {
            sb.append("          Interfaces Count: ");
            sb.append(this.mInterfaces.length);
            sb.append("\n");
            for (int i = 0; i < this.mInterfaces.length; ++i) {
                sb.append("            ");
                sb.append(this.mInterfaces[i].toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public HashMap getOperations() {
        return this.mOperations;
    }

    public void setOperations(HashMap map) {
        this.mOperations = map;
    }

    public QName[] getInterfaces() {
        return this.mInterfaces;
    }

    public void setInterfaces(QName[] interfaces) {
        this.mInterfaces = interfaces;
    }

    public boolean isInternal() {
        return this.getType() == 20;
    }

    public boolean isExternal() {
        return this.getType() == 30;
    }

    public boolean isLinked() {
        return this.getType() == 40;
    }

    public boolean isDynamic() {
        return this.getType() == 10;
    }

    public boolean implementsInterface(QName interfaceName) {
        boolean implemented = false;
        if (this.mInterfaces != null) {
            for (int i = 0; i < this.mInterfaces.length; ++i) {
                if (!this.mInterfaces[i].equals(interfaceName)) continue;
                implemented = true;
                break;
            }
        }
        return implemented;
    }

    public void parseDescriptor(Document descriptor) throws MessagingException {
        if (descriptor != null) {
            this.mOperations = WSDLHelper.getOperationsForService(descriptor, this.mService);
            this.mInterfaces = WSDLHelper.getInterfacesForService(descriptor, this.mService);
        }
    }

    public DocumentFragment getAsReference(QName operationName) {
        DocumentFragment doc = null;
        try {
            doc = EndpointReference.asReference(this);
        }
        catch (MessagingException msgEx) {
            this.mLog.warning(msgEx.toString());
        }
        return doc;
    }
}

