/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.io;

import de.hunsicker.util.ResourceBundleFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;

public final class ExtensionFilter
implements FilenameFilter {
    private static final String BUNDLE_NAME = "de.hunsicker.io.Bundle";
    private String _ext;

    public ExtensionFilter(String ext) {
        if (ext == null || ext.length() == 0) {
            Object[] args = new Object[]{ext};
            throw new IllegalArgumentException(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("INVALID_EXTENSION"), args));
        }
        this._ext = ext.trim();
        if (!this._ext.startsWith(".")) {
            this._ext = String.valueOf('.') + this._ext;
        }
    }

    public boolean accept(File dir, String name) {
        File file = new File(dir, name);
        return file.isDirectory() || name.endsWith(this._ext);
    }
}

