/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.io;

import de.hunsicker.util.ResourceBundleFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;

public final class IoHelper {
    private static final String BUNDLE_NAME = "de.hunsicker.io.Bundle";

    private IoHelper() {
    }

    public static boolean delete(File file, boolean recursive) {
        if (file.exists()) {
            if (file.isFile()) {
                return file.delete();
            }
            if (recursive) {
                File[] files = file.listFiles();
                boolean success = false;
                int i = 0;
                while (i < files.length) {
                    success = files[i].isDirectory() && files[i].list().length != 0 ? IoHelper.delete(files[i], true) : files[i].delete();
                    if (!success) {
                        return false;
                    }
                    ++i;
                }
                return file.delete();
            }
            return file.delete();
        }
        return false;
    }

    public static Object deserialize(byte[] data) throws IOException {
        if (data.length == 0) {
            return null;
        }
        return IoHelper.deserialize(new BufferedInputStream(new ByteArrayInputStream(data)));
    }

    public static Object deserialize(InputStream in) throws IOException {
        ObjectInputStream oin = new ObjectInputStream(in);
        try {
            Object object = oin.readObject();
            return object;
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            if (oin != null) {
                oin.close();
            }
        }
    }

    public static final Object deserialize(File file) throws IOException {
        return IoHelper.deserialize(new BufferedInputStream(new FileInputStream(file)));
    }

    public static boolean ensureDirectoryExists(File directory) {
        if (!directory.exists()) {
            return directory.mkdirs();
        }
        if (!directory.isDirectory()) {
            Object[] args = new Object[]{directory};
            throw new IllegalArgumentException(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("NOT_DIRECTORY"), args));
        }
        return true;
    }

    public static String readTextFile(File file) throws IOException {
        String string;
        block8: {
            BufferedReader in = null;
            try {
                if (!file.exists()) {
                    Object[] args = new Object[]{file};
                    throw new IOException(MessageFormat.format(ResourceBundleFactory.getBundle(BUNDLE_NAME).getString("FILE_DOES_NOT_EXIST"), args));
                }
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                int fileSize = (int)file.length();
                char[] buf = new char[fileSize];
                in.read(buf, 0, fileSize);
                string = new String(buf);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    public static void serialize(Object o, OutputStream out) throws IOException {
        ObjectOutputStream oout = new ObjectOutputStream(out);
        try {
            oout.writeObject(o);
        }
        finally {
            if (oout != null) {
                oout.close();
            }
        }
    }

    public static void serialize(Object o, File file) throws IOException {
        IoHelper.serialize(o, new BufferedOutputStream(new FileOutputStream(file)));
    }
}

