/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.JavaNodeModifier;
import de.hunsicker.jalopy.language.MethodType;
import de.hunsicker.jalopy.language.ModifierType;
import java.lang.reflect.Modifier;
import java.util.Comparator;

class NodeComparator
implements Comparator {
    static final int PUBLIC_STATIC = 9;
    private boolean _beanSorting = true;
    private boolean _modifierSorting = true;

    public void setModifierSorting(boolean modifierSorting) {
        this._modifierSorting = modifierSorting;
    }

    public void setBeanSorting(boolean sort) {
        this._beanSorting = sort;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        return this.compareNodes((AST)o1, (AST)o2);
    }

    protected int getParamCount(AST node) {
        AST params = JavaNodeHelper.getFirstChild(node, 25);
        if (params == null) {
            return 0;
        }
        int result = 0;
        AST child = node.getFirstChild();
        while (child != null) {
            ++result;
            child = child.getNextSibling();
        }
        return result;
    }

    protected int compareBeanNames(AST node1, AST node2) {
        String base2;
        MethodType type2;
        String name1 = JavaNodeHelper.getFirstChild(node1, 79).getText();
        String name2 = JavaNodeHelper.getFirstChild(node2, 79).getText();
        MethodType type1 = MethodType.valueOf(name1);
        if (type1 == (type2 = MethodType.valueOf(name2))) {
            return name1.compareTo(name2);
        }
        String base1 = NodeComparator.stripPrefix(name1);
        int result = base1.compareTo(base2 = NodeComparator.stripPrefix(name2));
        if (result == 0) {
            result = type1.compareTo(type2);
        } else {
            if (!type1.isBean()) {
                if (!type2.isBean()) {
                    result = name1.compareTo(name2);
                }
                result = type1.compareTo(type2);
            }
            if (!type2.isBean()) {
                result = type1.compareTo(type2);
            }
        }
        return result;
    }

    protected int compareClass(AST node1, AST node2) {
        int mod2;
        int mod1 = JavaNodeModifier.valueOf(node1);
        int result = this.compareModifiers(mod1, mod2 = JavaNodeModifier.valueOf(node2));
        if (result != 0) {
            return result;
        }
        return NodeComparator.compareNames(node1, node2);
    }

    protected int compareEnum(AST node1, AST node2) {
        int mod2;
        int mod1 = JavaNodeModifier.valueOf(node1);
        int result = this.compareModifiers(mod1, mod2 = JavaNodeModifier.valueOf(node2));
        if (result != 0) {
            return result;
        }
        return NodeComparator.compareNames(node1, node2);
    }

    protected int compareMethod(AST node1, AST node2) {
        int mod2;
        int mod1 = JavaNodeModifier.valueOf(JavaNodeHelper.getFirstChild(node1, 10));
        int result = this.compareModifiers(mod1, mod2 = JavaNodeModifier.valueOf(JavaNodeHelper.getFirstChild(node2, 10)));
        if (result != 0) {
            return result;
        }
        result = this._beanSorting ? this.compareBeanNames(node1, node2) : NodeComparator.compareNames(node1, node2);
        if (result != 0) {
            return result;
        }
        return this.compareParamCount(node1, node2);
    }

    protected int compareNodes(AST node1, AST node2) {
        int type2;
        int type1 = node1.getType();
        if (type1 == (type2 = node2.getType())) {
            switch (type1) {
                case 13: 
                case 14: 
                case 54: {
                    return this.compareMethod(node1, node2);
                }
                case 15: {
                    return this.compareVariable(node1, node2);
                }
                case 19: 
                case 20: {
                    return this.compareClass(node1, node2);
                }
                case 51: {
                    return this.compareEnum(node1, node2);
                }
                case 52: {
                    return NodeComparator.compareNames(node1, node2);
                }
                case 16: 
                case 17: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("Heck. I don't know about this type -- " + type1 + node1);
        }
        switch (type1) {
            case 14: {
                switch (type2) {
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: {
                        return 1;
                    }
                }
                return -1;
            }
            case 15: {
                switch (type2) {
                    case 16: 
                    case 17: {
                        return 1;
                    }
                }
                return -1;
            }
            case 13: {
                switch (type2) {
                    case 15: 
                    case 16: 
                    case 17: {
                        return 1;
                    }
                }
                return -1;
            }
            case 19: {
                return 1;
            }
            case 20: {
                switch (type2) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 51: {
                        return 1;
                    }
                }
                return -1;
            }
            case 54: {
                switch (type2) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 51: {
                        return 1;
                    }
                }
                return -1;
            }
            case 51: {
                switch (type2) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 54: {
                        return 1;
                    }
                }
                return -1;
            }
            case 17: {
                return -1;
            }
            case 16: {
                switch (type2) {
                    case 15: 
                    case 17: {
                        return 1;
                    }
                }
                return -1;
            }
        }
        throw new IllegalArgumentException("invalid node type given -- " + type1);
    }

    protected int compareParamCount(AST node1, AST node2) {
        int count2;
        int count1 = this.getParamCount(node1);
        if (count1 > (count2 = this.getParamCount(node2))) {
            return 1;
        }
        if (count1 < count2) {
            return -1;
        }
        return 0;
    }

    protected int compareVariable(AST node1, AST node2) {
        int mod2;
        int mod1 = JavaNodeModifier.valueOf(node1);
        int result = this.compareModifiers(mod1, mod2 = JavaNodeModifier.valueOf(node2));
        if (result != 0) {
            return result;
        }
        result = NodeComparator.compareTypes(node1, node2);
        if (result != 0) {
            return result;
        }
        return NodeComparator.compareNames(node1, node2);
    }

    protected static String stripPrefix(String name) {
        int length = name.length();
        if (length > 3) {
            if ((name.startsWith("get") || name.startsWith("set")) && Character.isUpperCase(name.charAt(3))) {
                return name.substring(3, length);
            }
            if (name.startsWith("is") && Character.isUpperCase(name.charAt(2))) {
                return name.substring(2, length);
            }
            return name;
        }
        if (length == 3 && name.startsWith("is") && Character.isUpperCase(name.charAt(2))) {
            return name.substring(2, length);
        }
        return name;
    }

    protected int compareModifiers(int mod1, int mod2) {
        if (!this._modifierSorting) {
            return 0;
        }
        ModifierType modifier1 = ModifierType.valueOf(mod1);
        ModifierType modifier2 = ModifierType.valueOf(mod2);
        if (modifier1 != null && modifier2 != null) {
            if (!modifier1.shouldSort(mod1)) {
                if (modifier2.shouldSort(mod2)) {
                    return 1;
                }
                return 0;
            }
            if (!modifier2.shouldSort(mod2)) {
                return -1;
            }
        }
        if (Modifier.isPublic(mod1) && !Modifier.isPublic(mod2)) {
            return -1;
        }
        if (Modifier.isProtected(mod1)) {
            if (Modifier.isPublic(mod2)) {
                return 1;
            }
            if (Modifier.isPrivate(mod2)) {
                return -1;
            }
            if (!Modifier.isProtected(mod2)) {
                return -1;
            }
        }
        if (Modifier.isPrivate(mod1) && !Modifier.isPrivate(mod2)) {
            return 1;
        }
        if (JavaNodeModifier.isFriendly(mod1)) {
            if (Modifier.isPrivate(mod2)) {
                return -1;
            }
            if (Modifier.isPublic(mod2) || Modifier.isProtected(mod2)) {
                return 1;
            }
        }
        if (Modifier.isAbstract(mod1) && !Modifier.isAbstract(mod2)) {
            return -1;
        }
        if (Modifier.isStatic(mod1) && !Modifier.isStatic(mod2)) {
            return -1;
        }
        if (Modifier.isFinal(mod1) && !Modifier.isFinal(mod2)) {
            return -1;
        }
        if (Modifier.isTransient(mod1) && !Modifier.isTransient(mod2)) {
            return -1;
        }
        return 0;
    }

    static int compareNames(AST node1, AST node2) {
        String ident1 = JavaNodeHelper.getFirstChild(node1, 79).getText();
        String ident2 = JavaNodeHelper.getFirstChild(node2, 79).getText();
        return ident1.compareTo(ident2);
    }

    static int compareTypes(AST node1, AST node2) {
        String ident1 = NodeComparator.getType(node1);
        String ident2 = NodeComparator.getType(node2);
        return ident1.compareTo(ident2);
    }

    private static String getType(AST node) {
        AST type = JavaNodeHelper.getFirstChild(node, 18);
        String ident = type.getFirstChild().getText();
        int offset = ident.lastIndexOf(46);
        if (offset == -1) {
            return ident;
        }
        return ident.substring(offset + 1);
    }
}

