/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.MethodCallPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.OperatorPrinter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.printer.WriterCache;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class DotPrinter
extends OperatorPrinter {
    private static final Printer INSTANCE = new DotPrinter();

    protected DotPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        AST rhs = this.printLeftHandSide(node, out);
        if (out.mode == 1) {
            boolean wrapLines = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP, true);
            boolean forceWrappingForChainedCalls = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_CHAINED_METHOD_CALL, false);
            if (wrapLines || forceWrappingForChainedCalls) {
                this.align(node, out);
            }
        }
        out.print(".", 80);
        this.printRightHandSide(rhs, out);
    }

    private int getLengthOfChainedCall(NodeWriter out, AST dot, JavaNode call, AST lastCall, WriterCache testers) throws IOException {
        AST elist;
        TestNodeWriter tester = testers.get();
        tester.reset(out, false);
        if (lastCall != call) {
            elist = dot.getNextSibling();
            PrinterFactory.create(elist, tester).print(elist, tester);
        } else {
            elist = lastCall.getFirstChild().getNextSibling();
            PrinterFactory.create(elist, tester).print(elist, tester);
        }
        AST child = dot.getFirstChild();
        switch (child.getType()) {
            case 32: {
                AST next = child.getNextSibling();
                PrinterFactory.create(next, tester).print(next, tester);
                break;
            }
            default: {
                PrinterFactory.create(child, tester).print(child, tester);
            }
        }
        int result = tester.maxColumn + 1;
        if (tester.line > 1) {
            result = -1;
        }
        testers.release(tester);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void align(AST node, NodeWriter out) throws IOException {
        boolean continuationIndent = AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_OPERATOR, false);
        if (out.state.parenScope.size() > 0 && ((ParenthesesScope)out.state.parenScope.getFirst()).chainCall != null) {
            ParenthesesScope scope = (ParenthesesScope)out.state.parenScope.getFirst();
            JavaNode parent = ((JavaNode)node).getParent();
            switch (parent.getType()) {
                case 32: {
                    boolean align = AbstractPrinter.settings.getBoolean(ConventionKeys.ALIGN_METHOD_CALL_CHAINS, true);
                    if (parent == scope.chainCall) return;
                    if (AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_CHAINED_METHOD_CALL, false)) {
                        if (!MethodCallPrinter.isOuterMethodCall(parent)) return;
                        out.printNewline();
                        int indentLength = out.getIndentLength();
                        if (align) {
                            out.print(out.getString(scope.chainOffset > indentLength ? scope.chainOffset - indentLength : scope.chainOffset), 175);
                            return;
                        } else if (continuationIndent) {
                            out.continuation = true;
                            this.printIndentation(out);
                            return;
                        } else {
                            this.printIndentation(out);
                        }
                        return;
                    }
                    int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
                    if (out.column > lineLength) {
                        out.printNewline();
                        if (continuationIndent) {
                            out.continuation = true;
                        }
                        this.indent(align, scope, out);
                        return;
                    }
                    JavaNode first = MethodCallPrinter.getLastMethodCall(parent);
                    int length = this.getLengthOfChainedCall(out, node, parent, first, out.testers);
                    if (length <= lineLength && length >= -1) return;
                    if (continuationIndent) {
                        out.continuation = true;
                    }
                    out.printNewline();
                    this.indent(align, scope, out);
                }
                default: {
                    return;
                }
            }
        } else {
            if (!AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_OPERATOR, false)) return;
            switch (((JavaNode)node).getParent().getType()) {
                case 80: {
                    return;
                }
                case 32: {
                    int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
                    if (out.column + 1 > lineLength) {
                        out.printNewline();
                        if (continuationIndent) {
                            out.continuation = true;
                        }
                        this.printIndentation(out);
                        return;
                    }
                    AST n = node.getFirstChild();
                    block7 : switch (n.getType()) {
                        case 108: {
                            while (n != null) {
                                switch (n.getType()) {
                                    case 109: {
                                        n = n.getNextSibling();
                                        break block7;
                                    }
                                }
                                n = n.getNextSibling();
                            }
                            break;
                        }
                        default: {
                            n = n.getNextSibling();
                        }
                    }
                    TestNodeWriter tester = out.testers.get();
                    tester.reset(out, false);
                    PrinterFactory.create(n, tester).print(n, tester);
                    if (tester.maxColumn > lineLength || tester.line > 1) {
                        out.printNewline();
                        out.state.markers.add(0, out.line);
                        if (continuationIndent) {
                            out.continuation = true;
                        }
                        this.printIndentation(out);
                    }
                    out.testers.release(tester);
                }
            }
        }
    }

    private void indent(boolean align, ParenthesesScope scope, NodeWriter out) throws IOException {
        if (align) {
            int indentLength = out.getIndentLength();
            out.print(out.getString(scope.chainOffset > indentLength ? scope.chainOffset - indentLength : scope.chainOffset), 175);
        } else if (out.continuation || !out.continuation && AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_OPERATOR, false)) {
            this.printIndentation(out);
        } else {
            this.printIndentation(out);
        }
    }
}

