/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.CommonAST;
import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.Recognizer;
import de.hunsicker.jalopy.language.TreeWalker;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.language.antlr.Node;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Environment;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.util.Lcs;
import de.hunsicker.util.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

final class JavadocPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new JavadocPrinter();
    private static final String DELIMETER = "|";
    private static final AST EMPTY_NODE = new CommonAST();
    private static final int NONE = 0;
    private static final int DESCRIPTION = 1;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String KEY_TAG_REMOVE_OBSOLETE = "TAG_REMOVE_OBSOLETE";
    private static final String KEY_TAG_ADD_MISSING = "TAG_ADD_MISSING";
    private static final String KEY_TAG_MISSPELLED_NAME = "TAG_MISSPELLED_NAME";
    private static final String KEY_GENERATE_COMMENT = "GENERATE_COMMENT";
    private static final String TAG_CPARA = "</p>";
    protected static Pattern _pattern = Pattern.compile("(?: )*([a-zA-z0-9_.]*)\\s*(.*)");
    private ThreadLocal _stringBreaker = new ThreadLocal(){

        protected Object initialValue() {
            return new BreakIterator();
        }
    };

    private JavadocPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) {
        throw new UnsupportedOperationException("use print(AST, AST, NodeWriter) instead");
    }

    public void print(AST node, AST comment, NodeWriter out) throws IOException {
        if (!out.newline) {
            out.printNewline();
        }
        out.javadocIndent = 0;
        int cfr_ignored_0 = out.line;
        boolean reformatComment = node.getType() == 19 || node.getType() == 15 || node.getType() == 14;
        boolean formatJavadoc = AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_PARSE, false);
        if ("<GENERATED_JAVADOC_COMMENT>".equals(comment.getText())) {
            String[] lines = StringHelper.split(comment.getFirstChild().getText(), DELIMETER);
            if (lines.length > 0) {
                out.state.args[0] = out.getFilename();
                out.state.args[1] = new Integer(out.line);
                out.state.args[2] = new Integer(out.getIndentLength() + 1);
                int i = 0;
                int size = lines.length - 1;
                while (i < size) {
                    out.print(lines[i], 6);
                    out.printNewline();
                    ++i;
                }
                out.print(lines[lines.length - 1], 6);
                Loggers.PRINTER_JAVADOC.l7dlog((Priority)Level.INFO, KEY_GENERATE_COMMENT, out.state.args, null);
            }
        } else if (!reformatComment) {
            int currentIndent = out.indentLevel;
            out.indentLevel = 0;
            out.print(comment.getText(), comment.getType());
            out.indentLevel = currentIndent;
        } else if (!formatJavadoc) {
            String[] lines = StringHelper.split(comment.getText(), out.originalLineSeparator);
            int i = 0;
            while (i < lines.length) {
                if (lines[i].trim().startsWith("*")) {
                    out.print(" " + lines[i].trim(), 6);
                } else {
                    out.print(lines[i], 6);
                }
                if (i + 1 != lines.length) {
                    out.printNewline();
                }
                ++i;
            }
        } else {
            Recognizer _recognizer = out.getCompositeFactory().getRecognizer();
            String t = comment.getText();
            _recognizer.setLine(node.getLine());
            _recognizer.setColumn(node.getColumn());
            _recognizer.parse(t, out.filename);
            comment = _recognizer.getParseTree();
            out.print(this.getTopString(node.getType()), 6);
            String bottomText = this.getBottomString(node.getType());
            String asterix = bottomText.substring(0, bottomText.indexOf(42) + 1);
            asterix = this.getAsterix();
            AST firstTag = null;
            String commentText = comment.getText();
            if (!AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_PARSE_DESCRIPTION, true)) {
                TestNodeWriter dummy = out.testers.get();
                firstTag = this.printDescriptionSection(node, comment, asterix, dummy);
                if (firstTag != EMPTY_NODE) {
                    commentText = commentText.substring(1, commentText.indexOf(firstTag.getText()));
                }
                out.testers.release(dummy);
                String[] lines = StringHelper.split(commentText, out.originalLineSeparator);
                if (lines.length == 1) {
                    lines[0] = lines[0].substring(3, lines[0].length() - 2);
                    out.print(lines[0], 6);
                } else if (lines.length > 0) {
                    lines[0] = lines[0].substring(3);
                    int i = 0;
                    int size = lines.length - 1;
                    while (i < size) {
                        out.print(lines[i], 6);
                        out.printNewline();
                        ++i;
                    }
                }
            } else {
                firstTag = this.printDescriptionSection(node, comment, asterix, out);
            }
            if (firstTag != EMPTY_NODE || AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS, false)) {
                this.printTagSection(node, comment, firstTag, asterix, out);
            }
            out.print(bottomText, 6);
        }
    }

    static List getValidTypeNames(AST node, int type) {
        switch (type) {
            case 25: {
                switch (node.getType()) {
                    case 13: 
                    case 14: {
                        break;
                    }
                    case 19: 
                    case 20: {
                        return JavadocPrinter.appendTypeNames(new ArrayList(4), node);
                    }
                    default: {
                        return Collections.EMPTY_LIST;
                    }
                }
                ArrayList<String> names = new ArrayList<String>(4);
                JavadocPrinter.appendTypeNames(names, node);
                AST child = JavaNodeHelper.getFirstChild(node, type).getFirstChild();
                while (child != null) {
                    switch (child.getType()) {
                        case 26: {
                            names.add(JavaNodeHelper.getFirstChild(child, 79).getText());
                        }
                    }
                    child = child.getNextSibling();
                }
                return names;
            }
            case 118: {
                final ArrayList<String> names = new ArrayList<String>(3);
                AST exceptions = JavaNodeHelper.getFirstChild(node, type);
                if (exceptions != null) {
                    AST child = exceptions.getFirstChild();
                    while (child != null) {
                        switch (child.getType()) {
                            case 79: {
                                names.add(child.getText());
                            }
                        }
                        child = child.getNextSibling();
                    }
                }
                TreeWalker walker = new TreeWalker(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    public void visit(AST aNode) {
                        switch (aNode.getType()) {
                            case 129: {
                                switch (aNode.getFirstChild().getFirstChild().getType()) {
                                    case 168: {
                                        String name = aNode.getFirstChild().getFirstChild().getFirstChild().getText();
                                        if (JavadocPrinter.isEnclosedWithTry((JavaNode)aNode) || names.contains(name)) return;
                                        names.add(name);
                                    }
                                }
                                return;
                            }
                        }
                    }
                };
                walker.walk(node);
                return names;
            }
        }
        return Collections.EMPTY_LIST;
    }

    static boolean isEnclosedWithTry(JavaNode node) {
        JavaNode parent = node.getParent();
        switch (parent.getType()) {
            case 13: 
            case 14: {
                return false;
            }
            case 133: {
                AST next = parent.getFirstChild().getNextSibling();
                if (next != null) {
                    switch (next.getType()) {
                        case 135: {
                            return true;
                        }
                    }
                }
                return false;
            }
        }
        switch (parent.getType()) {
            case 134: 
            case 135: {
                return JavadocPrinter.isEnclosedWithTry(parent.getParent());
            }
        }
        return JavadocPrinter.isEnclosedWithTry(parent);
    }

    private static List appendTypeNames(List names, AST node) {
        if (JavaNodeHelper.getFirstChild(node, 62) != null) {
            AST child = JavaNodeHelper.getFirstChild(node, 62).getFirstChild();
            while (child != null) {
                if (child.getType() == 63) {
                    names.add("<" + JavaNodeHelper.getFirstChild(child, 79).getText() + ">");
                }
                child = child.getNextSibling();
            }
        }
        return names;
    }

    private AST checkReturnTag(AST node, AST returnNode, NodeWriter out) {
        boolean needTag = false;
        AST child = node.getFirstChild();
        block3: while (child != null) {
            switch (child.getType()) {
                case 18: {
                    if (child.getFirstChild().getType() != 89) {
                        needTag = true;
                        break block3;
                    }
                }
                default: {
                    child = child.getNextSibling();
                }
            }
        }
        if (returnNode != null) {
            if (!needTag) {
                out.state.args[0] = out.getFilename();
                out.state.args[1] = new Integer(out.line);
                out.state.args[2] = new Integer(out.column);
                out.state.args[3] = "@return";
                out.state.args[4] = new Integer(((Node)returnNode).getStartLine());
                returnNode = null;
                Loggers.PRINTER_JAVADOC.l7dlog((Priority)Level.WARN, KEY_TAG_REMOVE_OBSOLETE, out.state.args, null);
            }
        } else if (needTag) {
            returnNode = this.createTag(node, 19, null, out.environment, out);
        }
        return returnNode;
    }

    private void checkTags(AST node, List tags, int type, String asterix, int last, NodeWriter out) {
        switch (type) {
            case 118: {
                if (AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS_THROWS, false)) break;
                return;
            }
        }
        List validNames = JavadocPrinter.getValidTypeNames(node, type);
        ArrayList validNamesCopy = new ArrayList(validNames);
        int capacity = (int)((double)tags.size() * 1.3);
        HashMap<String, AST> correct = new HashMap<String, AST>(capacity);
        ArrayList<AST> wrongOrObsolete = new ArrayList<AST>(capacity);
        int i = 0;
        int size = tags.size();
        while (i < size) {
            AST tag = (AST)tags.get(i);
            if (tag.getFirstChild() != null) {
                String description2 = tag.getFirstChild().getText().trim();
                String name = null;
                int offset = -1;
                offset = description2.indexOf(32);
                name = offset > -1 ? description2.substring(0, offset) : description2;
                if (validNamesCopy.contains(name)) {
                    correct.put(name, tag);
                    validNamesCopy.remove(name);
                } else {
                    wrongOrObsolete.add(tag);
                }
            } else {
                switch (tag.getType()) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 20: {
                        wrongOrObsolete.add(tag);
                    }
                }
            }
            ++i;
        }
        ArrayList<Object> result = new ArrayList<Object>(validNames);
        Collections.fill(result, null);
        for (Map.Entry entry : correct.entrySet()) {
            result.set(validNames.indexOf(entry.getKey()), entry.getValue());
        }
        if (validNames.size() != tags.size()) {
            AST tag;
            int i2 = 0;
            int size2 = wrongOrObsolete.size();
            while (i2 < size2) {
                int next = this.getNextEmptySlot(result);
                if (next == -1) {
                    int j = i2;
                    int s = wrongOrObsolete.size();
                    while (j < s) {
                        tag = (AST)wrongOrObsolete.get(j);
                        out.state.args[0] = out.getFilename();
                        out.state.args[1] = new Integer(out.line);
                        out.state.args[2] = new Integer(out.column);
                        out.state.args[3] = tag.getText();
                        out.state.args[4] = new Integer(((Node)tag).getStartLine());
                        out.state.args[5] = tag;
                        Loggers.PRINTER_JAVADOC.l7dlog((Priority)Level.WARN, KEY_TAG_REMOVE_OBSOLETE, out.state.args, null);
                        ++j;
                    }
                    break;
                }
                AST tag2 = (AST)wrongOrObsolete.get(i2);
                this.correctTagName(tag2, validNames, next, asterix, last, out);
                result.set(next, tag2);
                ++i2;
            }
            int emptySlots = validNames.size() - this.getEmptySlotCount(result);
            if (emptySlots < validNames.size()) {
                int i3 = emptySlots;
                int size3 = validNames.size();
                while (i3 < size3) {
                    int next = this.getNextEmptySlot(result);
                    String name = (String)validNames.get(next);
                    tag = null;
                    String tagName = null;
                    switch (type) {
                        case 25: {
                            tag = this.createTag(node, 18, name, out.environment, out);
                            result.set(next, tag);
                            tagName = "@param";
                            break;
                        }
                        case 118: {
                            tag = this.createTag(node, 16, name, out.environment, out);
                            result.set(next, tag);
                            tagName = "@throws";
                        }
                    }
                    out.state.args[0] = out.getFilename();
                    out.state.args[1] = new Integer(out.line + next + (this.shouldHaveNewlineBefore(tag, last) ? 1 : 0));
                    out.state.args[2] = new Integer(out.getIndentLength() + asterix.length() + 1);
                    out.state.args[3] = tagName;
                    out.state.args[4] = name;
                    Loggers.PRINTER_JAVADOC.l7dlog((Priority)Level.WARN, KEY_TAG_ADD_MISSING, out.state.args, null);
                    ++i3;
                }
            }
            tags.clear();
            tags.addAll(result);
        } else {
            int i4 = 0;
            int size4 = result.size();
            while (i4 < size4) {
                AST tag = (AST)result.get(i4);
                if (tag == null || tag.getFirstChild() == null) {
                    AST wrongTag = (AST)wrongOrObsolete.remove(0);
                    this.correctTagName(wrongTag, validNames, i4, asterix, last, out);
                    tag = wrongTag;
                }
                tags.set(i4, tag);
                ++i4;
            }
        }
    }

    private int correctTagName(AST wrongTag, List validNames, int index, String asterix, int last, NodeWriter out) {
        AST child = wrongTag.getFirstChild();
        if (child != null) {
            String text = child.getText().trim();
            String oldName = null;
            int offset = -1;
            offset = text.indexOf(32);
            if (offset > -1) {
                oldName = text.substring(0, offset);
            } else {
                oldName = text;
                offset = text.length();
            }
            String match = this.getMatch(oldName, validNames);
            String newName = null;
            if (match != null) {
                newName = match;
                index = validNames.indexOf(match);
            } else {
                newName = (String)validNames.get(index);
            }
            out.state.args[0] = out.getFilename();
            out.state.args[1] = new Integer(out.line + index + (this.shouldHaveNewlineBefore(wrongTag, last) ? 1 : 0));
            out.state.args[2] = new Integer(out.getIndentLength() + asterix.length() + 1);
            out.state.args[3] = oldName;
            out.state.args[4] = newName;
            Loggers.PRINTER_JAVADOC.l7dlog((Priority)Level.WARN, KEY_TAG_MISSPELLED_NAME, out.state.args, null);
            text = " " + newName + text.substring(offset);
            child.setText(text);
        } else {
            String newName = (String)validNames.get(index);
            String text = " " + newName;
            Node c = (Node)out.getJavaNodeFactory().create(42, text);
            wrongTag.setFirstChild(c);
        }
        return index;
    }

    private AST createTag(AST node, int type, String typeName, Environment environment, NodeWriter out) {
        AST tag = out.getJavaNodeFactory().create(type, EMPTY_STRING);
        if (typeName != null) {
            AST para = out.getJavaNodeFactory().create(42, this.getTagTemplateText(node, typeName, type, environment));
            tag.setFirstChild(para);
        } else {
            AST description2 = out.getJavaNodeFactory().create(42, this.getTagTemplateText(node, null, type, environment));
            tag.setFirstChild(description2);
        }
        return tag;
    }

    private void generalPrint(NodeWriter out, int nodeType, String text, String asterix) throws IOException {
        this.generalPrint(out, null, nodeType, text, asterix, -1);
    }

    private void generalPrint(NodeWriter out, AST node, String text, String asterix) throws IOException {
        this.generalPrint(out, node, -1, text, asterix, -1);
    }

    private void generalPrint(NodeWriter out, AST node, int nodeType, String text, String asterix, int length) throws IOException {
        boolean newLine = false;
        boolean newLineAfter = false;
        length = length > 0 ? (length += out.javadocIndent * out.indentSize) : out.javadocIndent * out.indentSize;
        if (nodeType < 0) {
            nodeType = node.getType();
        }
        switch (nodeType) {
            case 9: 
            case 11: {
                if (!out.newline) {
                    newLine = true;
                }
                ++out.javadocIndent;
                length += out.indentSize;
                break;
            }
            case 37: {
                newLineAfter = true;
            }
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 65: 
            case 84: {
                if (out.newline) break;
                newLine = true;
                break;
            }
            case 59: 
            case 61: 
            case 80: {
                ++out.javadocIndent;
                if (out.newline) break;
                newLine = true;
                break;
            }
            case 60: 
            case 62: {
                newLineAfter = true;
                newLine = true;
            }
            case 81: {
                if (!out.newline) {
                    newLine = true;
                }
                --out.javadocIndent;
                length -= out.indentSize;
                newLineAfter = true;
                break;
            }
            case 10: 
            case 12: {
                length -= out.indentSize;
                --out.javadocIndent;
                break;
            }
            case 85: {
                if (out.newline) break;
                newLine = true;
            }
        }
        int maxwidth = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80) - 3 - out.getIndentLength() - length;
        if (out.newline) {
            out.print(asterix, 6);
            if (length > -1) {
                out.print(out.getString(length + 1), 175);
            }
        }
        String[] lines = this.split(text, maxwidth, out.column, true);
        if (newLine) {
            out.printNewline();
            out.print(asterix, 6);
            if (length > -1) {
                out.print(out.getString(length + 1), 175);
            }
        }
        if (lines.length > 1) {
            int x = 0;
            while (x < lines.length) {
                out.print(lines[x], nodeType);
                if (x + 1 < lines.length) {
                    out.printNewline();
                    out.print(asterix, 6);
                    if (length > 0) {
                        out.print(out.getString(length + 1), 175);
                    }
                }
                ++x;
            }
        } else if (lines.length == 1) {
            out.print(lines[0], nodeType);
        }
        if (newLineAfter) {
            out.printNewline();
        }
    }

    private String getAsterix() {
        int asterix;
        String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_PARAM, " * @param $paramType$ DOCUMENT ME!");
        int description2 = StringHelper.indexOfNonWhitespace(text, (asterix = text.indexOf(42)) + 1);
        if (description2 > -1) {
            return text.substring(0, description2);
        }
        if (asterix > -1) {
            return text.substring(0, asterix + 1);
        }
        return EMPTY_STRING;
    }

    private String getBottomString(int type) {
        switch (type) {
            case 14: {
                return AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_BOTTOM, " */");
            }
            case 13: {
                return AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_BOTTOM, " */");
            }
            case 15: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_VARIABLE, "/**| * DOCUMENT ME!| */").trim();
                int offset = text.lastIndexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(offset + 1);
                }
                return " */";
            }
            case 19: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").trim();
                int offset = text.lastIndexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(offset + 1);
                }
                return " */";
            }
            case 20: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").trim();
                int offset = text.lastIndexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(offset + 1);
                }
                return " */";
            }
        }
        return " */";
    }

    private int getEmptySlotCount(List list) {
        int empty = 0;
        int i = 0;
        int size = list.size();
        while (i < size) {
            if (list.get(i) == null) {
                ++empty;
            }
            ++i;
        }
        return empty;
    }

    private String getMatch(String string, List list) {
        if (string == null) {
            return null;
        }
        if (list.contains(string)) {
            return string;
        }
        Lcs lcs = new Lcs();
        int i = 0;
        int size = list.size();
        while (i < size) {
            String tag = (String)list.get(i);
            lcs.init(string, tag);
            double similarity = lcs.getPercentage();
            if (similarity > 75.0) {
                return tag;
            }
            ++i;
        }
        return null;
    }

    private int getNextEmptySlot(List list) {
        int result = -1;
        int i = 0;
        int size = list.size();
        while (i < size) {
            if (list.get(i) == null) {
                return i;
            }
            ++i;
        }
        return result;
    }

    private int getParamCount(AST node) {
        int count = 0;
        if (JavaNodeHelper.getFirstChild(node, 25) != null) {
            AST param = JavaNodeHelper.getFirstChild(node, 25).getFirstChild();
            while (param != null) {
                ++count;
                param = param.getNextSibling();
            }
        }
        if (JavaNodeHelper.getFirstChild(node, 62) != null) {
            AST child = JavaNodeHelper.getFirstChild(node, 62).getFirstChild();
            while (child != null) {
                if (child.getType() == 63) {
                    ++count;
                }
                child = child.getNextSibling();
            }
        }
        return count;
    }

    private String getTagTemplateText(AST node, String typeName, int type, Environment environment) {
        switch (type) {
            case 18: {
                switch (node.getType()) {
                    case 14: {
                        String string = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_PARAM, " * @param $paramType$ DOCUMENT ME!");
                    }
                    case 13: 
                    case 19: 
                    case 20: {
                        String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_PARAM, " * @param $paramType$ DOCUMENT ME!");
                        int offset = text.indexOf(42);
                        environment.set(Environment.Variable.TYPE_PARAM.getName(), typeName);
                        if (offset > -1) {
                            text = text.substring(offset + 1).trim();
                        }
                        text = environment.interpolate(text);
                        environment.unset(Environment.Variable.TYPE_PARAM.getName());
                        return text;
                    }
                }
                throw new IllegalArgumentException("invalid node type to add @param tag -- " + node);
            }
            case 16: 
            case 17: {
                switch (node.getType()) {
                    case 14: {
                        String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_EXCEPTION, " * @throws $exceptionType$ DOCUMENT ME!");
                    }
                    case 13: {
                        String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_EXCEPTION, " * @throws $exceptionType$ DOCUMENT ME!");
                        int offset = text.indexOf(42);
                        environment.set(Environment.Variable.TYPE_EXCEPTION.getName(), typeName);
                        if (offset > -1) {
                            text = text.substring(offset + 1).trim();
                        }
                        text = environment.interpolate(text);
                        environment.unset(Environment.Variable.TYPE_EXCEPTION.getName());
                        return text;
                    }
                }
                throw new IllegalArgumentException("invalid node type to add @throws tag -- " + node);
            }
            case 19: {
                switch (node.getType()) {
                    case 14: {
                        String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_RETURN, " * @return DOCUMENT ME!");
                        int offset = text.indexOf(42);
                        if (offset > -1) {
                            text = text.substring(offset + 1).trim();
                        }
                        return text;
                    }
                }
                throw new IllegalArgumentException("invalid node type to add @return tag -- " + node);
            }
        }
        return EMPTY_STRING;
    }

    private String getTopString(int type) {
        switch (type) {
            case 14: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_TOP, "/**| * DOCUMENT ME!");
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return text;
            }
            case 13: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_TOP, "/**| * Creates a new $objectType$ object.");
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return text;
            }
            case 15: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_VARIABLE, "/**| * DOCUMENT ME!| */").trim();
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return "/**";
            }
            case 19: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").trim();
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return "/**";
            }
            case 20: {
                String text = AbstractPrinter.settings.get(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, "/**| * DOCUMENT ME!| *| * @author $author$| * @version $Revision$| */").trim();
                int offset = text.indexOf(DELIMETER);
                if (offset > -1) {
                    return text.substring(0, offset);
                }
                return "/**";
            }
        }
        return "/**";
    }

    private boolean hasInheritDoc(AST comment) {
        AST child = comment.getFirstChild();
        if (child != null) {
            switch (child.getType()) {
                case 28: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean isValidNode(AST node) {
        switch (node.getType()) {
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                return true;
            }
            case 15: {
                return !JavaNodeHelper.isLocalVariable(node);
            }
        }
        return false;
    }

    private String mergeChildren(AST node, String newLineString, String asterix) {
        StringBuffer buf = new StringBuffer(150);
        AST child = node;
        while (child != null) {
            switch (child.getType()) {
                case 9: 
                case 11: 
                case 43: 
                case 45: 
                case 47: 
                case 49: 
                case 51: 
                case 53: 
                case 59: 
                case 61: 
                case 63: 
                case 77: 
                case 80: 
                case 84: 
                case 86: 
                case 88: 
                case 90: 
                case 92: 
                case 94: 
                case 96: 
                case 98: 
                case 100: 
                case 102: 
                case 104: 
                case 106: 
                case 108: 
                case 110: 
                case 112: 
                case 114: 
                case 116: 
                case 118: 
                case 120: 
                case 123: 
                case 125: {
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild(), newLineString, asterix));
                    break;
                }
                case 65: 
                case 67: 
                case 69: {
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild(), newLineString, asterix));
                    buf.append(" ");
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    buf.append("{");
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild(), newLineString, asterix));
                    buf.append("}");
                    break;
                }
                case 79: {
                    throw new IllegalStateException("<pre> tag not supported within tag description");
                }
                case 39: {
                    buf.append(child.getText());
                    buf.append(newLineString);
                    buf.append(asterix);
                    break;
                }
                default: {
                    buf.append(child.getText());
                }
            }
            child = child.getNextSibling();
        }
        return buf.toString();
    }

    private void printBlockquote(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        node = this.printContent(node.getFirstChild(), asterix, out);
        this.generalPrint(out, node, node.getText(), asterix);
    }

    private void printComment(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
    }

    private void printCommentLines(String[] lines, String asterix, NodeWriter out) throws IOException {
        this.printCommentLines(lines, asterix, out, false);
    }

    private void printCommentLines(String[] lines, String asterix, NodeWriter out, boolean trim) throws IOException {
        int maxColumn = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        if (trim) {
            int i = 0;
            while (i < lines.length) {
                if (asterix != null && out.column + lines[i].length() > maxColumn) {
                    out.printNewline();
                    out.print(asterix, 42);
                }
                out.print(lines[i].trim(), 42);
                ++i;
            }
        } else {
            int i = 0;
            while (i < lines.length) {
                if (asterix != null && out.column + lines[i].length() > maxColumn) {
                    out.printNewline();
                    out.print(asterix, 42);
                }
                out.print(lines[i], 42);
                ++i;
            }
        }
    }

    private AST printContent(AST node, String asterix, NodeWriter out) throws IOException {
        AST next = EMPTY_NODE;
        AST child = node;
        block12: while (child != null) {
            block13: while (true) {
                switch (child.getType()) {
                    case 41: {
                        this.printComment(child, asterix, out);
                        break block13;
                    }
                    case 7: 
                    case 8: 
                    case 35: 
                    case 38: 
                    case 39: 
                    case 42: 
                    case 86: 
                    case 88: 
                    case 90: 
                    case 92: 
                    case 94: 
                    case 96: 
                    case 98: 
                    case 100: 
                    case 102: 
                    case 104: 
                    case 106: 
                    case 108: 
                    case 110: 
                    case 112: 
                    case 114: 
                    case 116: 
                    case 118: 
                    case 120: 
                    case 122: 
                    case 123: 
                    case 125: {
                        child = this.printText(child, asterix, out);
                        continue block13;
                    }
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        child = this.printText(child, asterix, out);
                        continue block13;
                    }
                    case 57: {
                        this.printParagraph(child, asterix, out);
                        break block13;
                    }
                    case 77: {
                        this.printBlockquote(child, asterix, out);
                        break block13;
                    }
                    case 37: {
                        this.generalPrint(out, child, child.getText(), asterix);
                        break block13;
                    }
                    case 43: 
                    case 45: 
                    case 47: 
                    case 49: 
                    case 51: 
                    case 53: {
                        this.printHeading(child, asterix, out);
                        break block13;
                    }
                    case 80: {
                        this.printTable(child, asterix, out);
                        break block13;
                    }
                    case 79: {
                        this.printPreformatted(child, asterix, out);
                        break block13;
                    }
                    case 59: 
                    case 61: 
                    case 63: {
                        this.printList(child, asterix, out);
                        break block13;
                    }
                    default: {
                        next = child;
                        break block12;
                    }
                }
                break;
            }
            child = child.getNextSibling();
        }
        return next;
    }

    private AST printDescriptionSection(AST node, AST comment, String asterix, NodeWriter out) throws IOException {
        switch (node.getType()) {
            case 15: {
                if (!AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_FIELDS_SHORT, true) || !this.printSingleLineDescription(node, comment, out)) break;
                return EMPTY_NODE;
            }
        }
        out.printNewline();
        out.print(asterix, 6);
        AST result = this.printContent(comment.getFirstChild(), asterix, out);
        if (!out.newline) {
            out.printNewline();
        }
        return result;
    }

    private void printHeading(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        if (node.getFirstChild() != null && (node = this.printText(node.getFirstChild(), asterix, out)) != EMPTY_NODE) {
            this.generalPrint(out, node, node.getText(), asterix);
        }
        out.last = 44;
    }

    private void printList(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        AST child = null;
        child = node.getFirstChild();
        while (child != null) {
            this.printListItem(child, asterix, out);
            child = child.getNextSibling();
        }
    }

    private void printListItem(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        AST newnode = this.printContent(node.getFirstChild(), asterix, out);
        if (newnode != EMPTY_NODE) {
            this.generalPrint(out, newnode, newnode.getText(), asterix);
        }
    }

    private void printNewlineBefore(AST tag, int last, String asterix, NodeWriter out) throws IOException {
        if (this.shouldHaveNewlineBefore(tag, last)) {
            if (!out.newline) {
                out.printNewline();
            }
            out.print(StringHelper.trimTrailing(asterix), 42);
            out.printNewline();
        }
    }

    private void printParagraph(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        if (node.getFirstChild() != null) {
            AST child = node.getFirstChild();
            block7: while (child != null) {
                block8: while (true) {
                    switch (child.getType()) {
                        case 7: 
                        case 8: 
                        case 35: 
                        case 38: 
                        case 39: 
                        case 42: 
                        case 86: 
                        case 88: 
                        case 90: 
                        case 92: 
                        case 94: 
                        case 96: 
                        case 98: 
                        case 100: 
                        case 102: 
                        case 104: 
                        case 106: 
                        case 108: 
                        case 110: 
                        case 112: 
                        case 114: 
                        case 116: 
                        case 118: 
                        case 120: 
                        case 123: 
                        case 125: {
                            child = this.printText(child, asterix, out);
                            continue block8;
                        }
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: {
                            out.print("{", 7);
                            child = this.printText(child, asterix, out);
                            out.print("}", 8);
                            continue block8;
                        }
                        case 77: {
                            this.printBlockquote(child, asterix, out);
                            break block8;
                        }
                        case 79: {
                            this.printPreformatted(child, asterix, out);
                            break block8;
                        }
                        case 59: 
                        case 61: 
                        case 63: {
                            this.printList(child, asterix, out);
                            break block8;
                        }
                        default: {
                            break block7;
                        }
                    }
                    break;
                }
                child = child.getNextSibling();
            }
            this.generalPrint(out, 58, TAG_CPARA, asterix);
        } else {
            this.generalPrint(out, 58, TAG_CPARA, asterix);
        }
        if (!out.newline) {
            out.printNewline();
        }
    }

    private void printPreformatted(AST node, String asterix, NodeWriter out) throws IOException {
        String[] lines = this.split(node.getText(), out.originalLineSeparator, '*');
        this.printCommentLines(lines, asterix, out);
        out.last = 79;
    }

    private int printReturnTag(AST tag, String asterix, int maxWidth, boolean added, int last, NodeWriter out) throws IOException {
        if (tag != null) {
            if (added) {
                out.state.args[0] = out.getFilename();
                out.state.args[1] = new Integer(out.line + (this.shouldHaveNewlineBefore(tag, last) ? 1 : 0));
                out.state.args[2] = new Integer(out.getIndentLength() + asterix.length() + 1);
                out.state.args[3] = "@return";
                out.state.args[4] = EMPTY_STRING;
                Loggers.PRINTER_JAVADOC.l7dlog((Priority)Level.WARN, KEY_TAG_ADD_MISSING, out.state.args, null);
            }
            return this.printTag(tag, asterix, maxWidth, last, out);
        }
        return last;
    }

    private boolean printSingleLineDescription(AST node, AST comment, NodeWriter out) throws IOException {
        StringBuffer buf = new StringBuffer();
        int maxwidth = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80) - 3 - out.getIndentLength();
        AST child = comment.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 32: 
                case 57: {
                    return false;
                }
                case 7: 
                case 8: 
                case 35: 
                case 38: 
                case 39: 
                case 42: {
                    buf.append(child.getText());
                    break;
                }
                case 86: 
                case 88: 
                case 90: 
                case 92: 
                case 94: 
                case 96: 
                case 98: 
                case 100: 
                case 102: 
                case 104: 
                case 106: 
                case 108: 
                case 110: 
                case 112: 
                case 114: 
                case 116: 
                case 118: 
                case 120: 
                case 123: 
                case 125: {
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild(), "", ""));
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    buf.append("{");
                    buf.append(child.getText());
                    AST part = child.getFirstChild();
                    while (part != null) {
                        buf.append(part.getText());
                        part = part.getNextSibling();
                    }
                    buf.append("}");
                }
            }
            if (buf.length() > maxwidth) {
                return false;
            }
            child = child.getNextSibling();
        }
        if (buf.length() < maxwidth) {
            out.print(" ", 6);
            out.print(buf.toString().trim(), 6);
            return true;
        }
        return false;
    }

    private void printTable(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        AST row = node.getFirstChild();
        while (row != null) {
            this.printTableRow(row, asterix, out);
            row = row.getNextSibling();
        }
    }

    private void printTableData(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        if (node.getFirstChild() != null) {
            AST nextNode = this.printContent(node.getFirstChild(), asterix, out);
            this.generalPrint(out, nextNode, nextNode.getText(), asterix);
        }
    }

    private void printTableRow(AST node, String asterix, NodeWriter out) throws IOException {
        this.generalPrint(out, node, node.getText(), asterix);
        AST cell = node.getFirstChild();
        while (cell != null) {
            this.printTableData(cell, asterix, out);
            cell = cell.getNextSibling();
        }
    }

    private int printTag(AST tag, String asterix, int maxwidth, int last, NodeWriter out) throws IOException {
        if (tag != null) {
            this.printNewlineBefore(tag, last, asterix, out);
            if (out.newline) {
                out.print(asterix, 6);
            }
            String ident = tag.getText();
            out.print(ident, 6);
            switch (tag.getType()) {
                case 25: {
                    AST child = tag.getFirstChild();
                    if (child == null) break;
                    String description2 = this.mergeChildren(child, out.lineSeparator, asterix);
                    switch (description2.charAt(0)) {
                        case ' ': 
                        case '<': 
                        case '{': {
                            out.print(" ", 6);
                        }
                    }
                    out.print(description2.trim(), 6);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 24: {
                    this.printTagDescription(tag.getFirstChild(), ident, asterix, maxwidth, true, out);
                    break;
                }
                default: {
                    this.printTagDescription(tag.getFirstChild(), ident, asterix, maxwidth, false, out);
                }
            }
            out.printNewline();
            return tag.getType();
        }
        return last;
    }

    private void printTagDescription(AST child, String name, String asterix, int maxwidth, boolean normalize, NodeWriter out) throws IOException {
        if (child != null) {
            Matcher matcher;
            String description2 = this.mergeChildren(child, out.lineSeparator, asterix);
            switch (description2.charAt(0)) {
                case ' ': 
                case '<': 
                case '{': {
                    out.print(" ", 6);
                }
            }
            if (normalize && description2.charAt(0) != '@' && (matcher = _pattern.matcher(description2)).matches() && matcher.group(1) != null) {
                StringBuffer buf = new StringBuffer(description2.length());
                buf.append(matcher.group(1));
                buf.append(" ");
                buf.append(matcher.group(2));
                description2 = buf.toString();
            }
            int length = name.length();
            String[] lines = this.split(description2.trim(), maxwidth - length - 1, 0, true);
            int i = 0;
            int size = lines.length - 1;
            while (i < size) {
                out.print(lines[i], 6);
                out.printNewline();
                out.print(asterix, 6);
                out.print(out.getString(length + 1), 175);
                ++i;
            }
            out.print(lines[lines.length - 1], 6);
        }
    }

    private void printTagSection(AST node, AST comment, AST firstTag, String asterix, NodeWriter out) throws IOException {
        ArrayList<AST> parameterTags = Collections.EMPTY_LIST;
        ArrayList<AST> annotationTags = Collections.EMPTY_LIST;
        AST serialTag = null;
        AST serialDataTag = null;
        ArrayList<AST> serialFieldsTags = Collections.EMPTY_LIST;
        AST sinceTag = null;
        ArrayList<AST> seesTags = Collections.EMPTY_LIST;
        AST versionTag = null;
        ArrayList<AST> customTags = Collections.EMPTY_LIST;
        ArrayList<AST> authorTags = Collections.EMPTY_LIST;
        AST deprecatedTag = null;
        AST returnTag = null;
        ArrayList<AST> exceptionTags = Collections.EMPTY_LIST;
        boolean checkTags = AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS, false);
        if (checkTags) {
            checkTags = this.shouldCheckTags(node, comment);
        }
        AST tag = firstTag;
        while (tag != null) {
            switch (tag.getType()) {
                case 18: {
                    if (parameterTags.isEmpty()) {
                        parameterTags = new ArrayList<AST>(4);
                    }
                    parameterTags.add(tag);
                    break;
                }
                case 22: {
                    serialTag = tag;
                    break;
                }
                case 23: {
                    serialDataTag = tag;
                    break;
                }
                case 24: {
                    if (serialFieldsTags.isEmpty()) {
                        serialFieldsTags = new ArrayList<AST>(4);
                    }
                    serialFieldsTags.add(tag);
                    break;
                }
                case 21: {
                    sinceTag = tag;
                    break;
                }
                case 20: {
                    if (seesTags.isEmpty()) {
                        seesTags = new ArrayList<AST>(4);
                    }
                    seesTags.add(tag);
                    if (!checkTags || tag.getNextSibling() != null || tag != firstTag) break;
                    checkTags = false;
                    break;
                }
                case 25: {
                    versionTag = tag;
                    break;
                }
                case 15: {
                    deprecatedTag = tag;
                    break;
                }
                case 14: {
                    if (authorTags.isEmpty()) {
                        authorTags = new ArrayList<AST>(4);
                    }
                    authorTags.add(tag);
                    break;
                }
                case 19: {
                    returnTag = tag;
                    break;
                }
                case 40: {
                    if (annotationTags.isEmpty()) {
                        annotationTags = new ArrayList<AST>(4);
                    }
                    annotationTags.add(tag);
                    break;
                }
                case 16: 
                case 17: {
                    if (exceptionTags.isEmpty()) {
                        exceptionTags = new ArrayList<AST>(4);
                    }
                    exceptionTags.add(tag);
                    break;
                }
                case 13: 
                case 32: {
                    if (customTags.isEmpty()) {
                        customTags = new ArrayList<AST>(5);
                    }
                    customTags.add(tag);
                }
            }
            tag = tag.getNextSibling();
        }
        int maxwidth = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80) - out.getIndentLength() - 3;
        int last = 0;
        if (comment.getFirstChild() != firstTag) {
            last = 1;
        } else if (checkTags) {
            out.print("DOCUMENT ME!", 42);
            out.printNewline();
            last = 1;
        }
        boolean returnTagAdded = false;
        boolean checkParameterTags = false;
        boolean checkThrowsTags = false;
        switch (node.getType()) {
            case 15: {
                last = this.printTag(serialTag, asterix, maxwidth, last, out);
                last = this.printTags(serialFieldsTags, asterix, maxwidth, last, out);
                break;
            }
            case 14: {
                if (checkTags) {
                    boolean tagPresent = returnTag != null;
                    returnTag = this.checkReturnTag(node, returnTag, out);
                    returnTagAdded = !tagPresent && returnTag != null;
                }
            }
            case 13: {
                last = this.printTag(serialDataTag, asterix, maxwidth, last, out);
            }
            case 19: 
            case 20: {
                if (node.getType() == 19 || node.getType() == 20) {
                    last = this.printTags(authorTags, asterix, maxwidth, last, out);
                    last = this.printTag(versionTag, asterix, maxwidth, last, out);
                    last = this.printTag(serialTag, asterix, maxwidth, last, out);
                }
                if (this.getParamCount(node) > 0) {
                    if (checkTags) {
                        if (parameterTags.isEmpty()) {
                            parameterTags = new ArrayList(5);
                        }
                        checkParameterTags = true;
                    }
                    last = checkParameterTags ? this.printTags(parameterTags, asterix, maxwidth, node, 25, last, out) : this.printTags(parameterTags, asterix, maxwidth, last, out);
                }
                switch (node.getType()) {
                    case 14: {
                        last = this.printReturnTag(returnTag, asterix, maxwidth, returnTagAdded, last, out);
                    }
                    case 13: {
                        if (checkTags) {
                            if (exceptionTags.isEmpty()) {
                                exceptionTags = new ArrayList();
                            }
                            checkThrowsTags = true;
                        }
                        last = checkThrowsTags ? this.printTags(exceptionTags, asterix, maxwidth, node, 118, last, out) : this.printTags(exceptionTags, asterix, maxwidth, last, out);
                    }
                }
            }
        }
        last = this.printTags(customTags, asterix, maxwidth, last, out);
        last = this.printTags(seesTags, asterix, maxwidth, last, out);
        last = this.printTag(sinceTag, asterix, maxwidth, last, out);
        last = this.printTag(deprecatedTag, asterix, maxwidth, last, out);
        last = this.printTags(annotationTags, asterix, maxwidth, last, out);
    }

    private int printTags(List tags, String asterix, int maxwidth, AST node, int tagType, int last, NodeWriter out) throws IOException {
        if (tagType != -1) {
            this.checkTags(node, tags, tagType, asterix, last, out);
        }
        return this.printTags(tags, asterix, maxwidth, last, out);
    }

    private int printTags(List tags, String asterix, int maxwidth, int last, NodeWriter out) throws IOException {
        int i = 0;
        int size = tags.size();
        while (i < size) {
            last = this.printTag((AST)tags.get(i), asterix, maxwidth, last, out);
            ++i;
        }
        return last;
    }

    private AST printText(AST node, String asterix, NodeWriter out) throws IOException {
        StringBuffer buf = new StringBuffer(200);
        AST next = EMPTY_NODE;
        AST child = node;
        block9: while (child != null) {
            switch (child.getType()) {
                case 41: {
                    this.printComment(child, asterix, out);
                    break;
                }
                case 7: 
                case 8: 
                case 35: 
                case 38: 
                case 39: 
                case 42: 
                case 122: {
                    buf.append(child.getText());
                    break;
                }
                case 86: 
                case 88: 
                case 90: 
                case 92: 
                case 94: 
                case 96: 
                case 98: 
                case 100: 
                case 102: 
                case 104: 
                case 106: 
                case 108: 
                case 110: 
                case 112: 
                case 114: 
                case 116: 
                case 118: 
                case 120: 
                case 123: 
                case 125: {
                    buf.append(child.getText());
                    buf.append(this.mergeChildren(child.getFirstChild(), out.lineSeparator, asterix));
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    buf.append("{");
                    buf.append(child.getText());
                    AST part = child.getFirstChild();
                    while (part != null) {
                        switch (part.getType()) {
                            case 123: {
                                buf.append(' ');
                            }
                        }
                        buf.append(part.getText());
                        part = part.getNextSibling();
                    }
                    buf.append("}");
                    break;
                }
                default: {
                    next = child;
                    break block9;
                }
            }
            child = child.getNextSibling();
        }
        if (buf.length() > 0) {
            this.generalPrint(out, node, buf.toString().trim(), asterix);
        }
        return next;
    }

    private boolean shouldCheckTags(AST node, AST comment) {
        return this.isValidNode(node) && !this.hasInheritDoc(comment);
    }

    private boolean shouldHaveNewlineBefore(AST tag, int last) {
        boolean result = false;
        block0 : switch (last) {
            case 1: {
                result = true;
                break;
            }
            case 0: {
                break;
            }
            default: {
                switch (tag.getType()) {
                    case 16: 
                    case 17: {
                        switch (last) {
                            case 16: 
                            case 17: {
                                break block0;
                            }
                        }
                        result = true;
                        break block0;
                    }
                    case 25: {
                        break block0;
                    }
                    case 13: 
                    case 14: 
                    case 18: 
                    case 32: {
                        if (last == tag.getType()) break block0;
                        result = true;
                        break block0;
                    }
                    case 19: {
                        result = true;
                        break block0;
                    }
                    case 20: {
                        if (last == tag.getType()) break block0;
                        result = true;
                        break block0;
                    }
                    default: {
                        switch (last) {
                            case 14: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 25: {
                                result = true;
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    private String[] split(String str, String delim, char character) {
        if (character > '\uffffffff') {
            String line;
            int startOffset = 0;
            int endOffset = -1;
            int sepLength = delim.length();
            ArrayList<String> lines = new ArrayList<String>(15);
            while ((endOffset = str.indexOf(delim, startOffset)) > -1) {
                line = str.substring(startOffset, endOffset);
                lines.add(this.trimLeadingWhitespace(line, character));
                startOffset = endOffset + sepLength;
            }
            if (startOffset > 0) {
                line = this.trimLeadingWhitespace(str.substring(startOffset), character);
                lines.add(line);
            } else {
                lines.add(this.trimLeadingWhitespace(str, character));
            }
            return lines.toArray(EMPTY_STRING_ARRAY);
        }
        return StringHelper.split(str, delim);
    }

    private String[] split(String str, int width, int columnStart, boolean trim) {
        ArrayList<String> lines = new ArrayList<String>();
        if (trim) {
            str = str.trim();
        }
        if (str.length() + columnStart < width) {
            lines.add(str);
        } else {
            BreakIterator iterator = (BreakIterator)this._stringBreaker.get();
            try {
                iterator.setText(str);
                int lineStart = 0;
                int nextStart = iterator.next();
                int prevStart = 0;
                block6: while (true) {
                    if (nextStart - lineStart + columnStart < width && nextStart != -10) {
                        prevStart = nextStart;
                        nextStart = iterator.next();
                        switch (iterator._type) {
                            case 2: {
                                prevStart = nextStart + 4;
                                break;
                            }
                            default: {
                                continue block6;
                            }
                        }
                    }
                    if (prevStart == 0) {
                        prevStart = nextStart;
                    }
                    if (nextStart == -10) {
                        if (prevStart - lineStart + (str.length() - prevStart) + columnStart < width) {
                            lines.add(str.substring(lineStart, str.length()).trim());
                        } else if (prevStart > 0 && prevStart != -10) {
                            if (trim) {
                                lines.add(str.substring(lineStart, prevStart).trim());
                                lines.add(str.substring(prevStart).trim());
                            } else {
                                lines.add(str.substring(lineStart, prevStart));
                                lines.add(str.substring(prevStart));
                            }
                        } else if (trim) {
                            lines.add(str.substring(lineStart).trim());
                        } else {
                            lines.add(str.substring(lineStart));
                        }
                        prevStart = str.length();
                    } else if (trim) {
                        lines.add(str.substring(lineStart, prevStart).trim());
                    } else {
                        lines.add(str.substring(lineStart, prevStart));
                    }
                    lineStart = prevStart;
                    prevStart = 0;
                    columnStart = 0;
                    if (lineStart >= str.length()) break;
                }
            }
            finally {
                iterator.reset();
            }
        }
        return lines.toArray(EMPTY_STRING_ARRAY);
    }

    private String trimLeadingWhitespace(String str, char character) {
        int off = StringHelper.indexOfNonWhitespace(str);
        if (off > -1 && str.charAt(off) == character) {
            return str.substring(off + 1);
        }
        return str;
    }

    private static class BreakIterator {
        private static final int WHITESPACE = 1;
        private static final int BREAK = 2;
        public static final int DONE = -10;
        private static final String TAG_BREAK = "<br>";
        private static final String TAG_BREAK_WELL = "<br/>";
        int _type;
        private String _text;
        private int _end = -1;
        private int _pos = -1;

        public int getBreakType() {
            return this._type;
        }

        public int next() {
            this._type = 1;
            this._pos = this._text.indexOf(32, this._end + 1);
            if (this._pos > -1) {
                int br;
                int tab = this._text.indexOf(9, this._end + 1);
                if (tab > -1 && tab < this._pos) {
                    this._pos = tab;
                }
                if ((br = this._text.indexOf(TAG_BREAK, this._end + 1)) == -1) {
                    br = this._text.indexOf(TAG_BREAK_WELL, this._end + 1);
                }
                if (br > -1 && br < this._pos) {
                    this._pos = br;
                    this._type = 2;
                }
            }
            if (this._pos == -1) {
                return -10;
            }
            this._end = this._pos;
            return this._pos;
        }

        public void reset() {
            this._text = null;
            this._end = -1;
            this._pos = -1;
        }

        public void setText(String text) {
            this._text = text;
        }
    }
}

