/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.jalopy.language.CompositeFactory;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.PrinterState;
import de.hunsicker.jalopy.printer.WriterCache;
import java.io.IOException;

final class TestNodeWriter
extends NodeWriter {
    int length;
    int maxColumn;
    boolean hasIndent = false;

    TestNodeWriter(WriterCache writer, CompositeFactory factory, NodeWriter source) {
        super(factory);
        this.mode = 2;
        this.testers = writer;
        this.filename = source.filename;
    }

    public int getLength() {
        return this.length;
    }

    public void close() throws IOException {
        super.close();
        this.reset();
        if (this.state != null) {
            this.state.dispose();
        }
        this.state = null;
    }

    public void flush() throws IOException {
        super.flush();
        this.reset();
    }

    public int print(String string, int type) throws IOException {
        int l;
        if (this.newline) {
            l = this.indentLevel * this.indentSize;
            this.addColumn(l);
            this.length += l;
            this.newline = false;
        }
        l = string.length();
        this.length += l;
        this.addColumn(l);
        this.last = type;
        return 1;
    }

    public void printNewline() throws IOException {
        this.newline = true;
        this.column = 1;
        ++this.line;
    }

    public void reset() {
        this.length = 0;
        this.line = 1;
        this.column = 1;
        this.maxColumn = 1;
        this.indentLevel = 0;
        if (this.state != null) {
            this.state.reset();
        } else {
            this.state = new PrinterState(this);
        }
        this.hasIndent = false;
    }

    public void reset(NodeWriter out, boolean newline1) {
        this.reset();
        this.indentLevel = out.indentLevel;
        this.maxColumn = this.length = out.column;
        this.column = this.length;
        if (out.state.markers.isMarked()) {
            Marker m = out.state.markers.getLast();
            this.state.markers.add(m.line, m.column);
        }
        if (newline1) {
            try {
                this.printNewline();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addColumn(int amount) {
        this.column += amount;
        if (this.column > this.maxColumn) {
            this.maxColumn = this.column;
        }
    }

    public void indent() {
        this.hasIndent = true;
        super.indent();
    }

    public void unindent() {
    }
}

