/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.swing.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public final class SwingHelper {
    private SwingHelper() {
    }

    public static GridBagConstraints setConstraints(GridBagConstraints constraints, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets, int ipadx, int ipady) {
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = gridwidth;
        constraints.gridheight = gridheight;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.anchor = anchor;
        constraints.fill = fill;
        constraints.insets.top = insets.top;
        constraints.insets.bottom = insets.bottom;
        constraints.insets.left = insets.left;
        constraints.insets.right = insets.right;
        constraints.ipadx = ipadx;
        constraints.ipady = ipady;
        return constraints;
    }

    public static void setMenuText(AbstractButton item, String text, boolean useMnemonic) {
        int i = text.indexOf(38);
        if (i < 0) {
            item.setText(text);
        } else {
            item.setText(String.valueOf(text.substring(0, i)) + text.substring(i + 1));
            if (useMnemonic) {
                item.setMnemonic(text.charAt(i + 1));
            }
        }
    }

    public static Frame getOwnerFrame(Component component) {
        Window owner;
        Window window = SwingUtilities.windowForComponent(component);
        Frame mother = null;
        if (window != null && (owner = window.getOwner()) != null && owner instanceof Frame) {
            mother = (Frame)owner;
        }
        return mother;
    }

    public static int getTableHeight(JTable table) {
        int result = 0;
        int rowHeight = 0;
        int i = 0;
        int rows = table.getRowCount();
        while (i < rows) {
            int height = table.getRowHeight(i);
            result += height;
            if (height > rowHeight) {
                rowHeight = height;
            }
            ++i;
        }
        return result + rowHeight + table.getRowCount() * table.getRowMargin();
    }

    public static JButton createButton(String text, boolean parse) {
        JButton button = new JButton();
        if (parse) {
            SwingHelper.setMenuText(button, text, true);
        } else {
            button.setText(text);
        }
        return button;
    }

    public static JButton createButton(String text) {
        return SwingHelper.createButton(text, true);
    }

    public static final int showJFileChooser(JFileChooser chooser, Component parent, String approveButtonText) {
        if (approveButtonText != null) {
            chooser.setApproveButtonText(approveButtonText);
            chooser.setDialogType(2);
        }
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        String title = chooser.getDialogTitle();
        if (title == null) {
            title = chooser.getUI().getDialogTitle(chooser);
        }
        final JDialog dialog = new JDialog(frame, title, true);
        dialog.setDefaultCloseOperation(2);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)chooser, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        chooser.rescanCurrentDirectory();
        final int[] retValue = new int[]{1};
        ActionListener l = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (ev.getActionCommand() == "ApproveSelection") {
                    retValue[0] = 0;
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        chooser.addActionListener(l);
        dialog.show();
        return retValue[0];
    }
}

