/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.Putval;
import com.sap.dbtech.util.MemIndirection;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class DataPart
extends MemIndirection {
    private static final int maxArgCount = Short.MAX_VALUE;
    private int argCount = 0;
    private int extent = 0;
    private int massExtent = 0;
    private boolean isFull = false;
    StructuredMem originalMem;
    RequestPacket requestPacket;

    DataPart(StructuredMem structuredMem, RequestPacket requestPacket) {
        super(structuredMem);
        this.originalMem = structuredMem.getPointer(0);
        this.requestPacket = requestPacket;
    }

    public void addArg(int n, int n2) {
        ++this.argCount;
        this.extent = Math.max(this.extent, n + n2);
    }

    public void close() {
        int n = -14;
        this.originalMem.putInt2(this.argCount, n);
        this.requestPacket.closePart(this.massExtent + this.extent, this.argCount);
    }

    public void closeArrayPart(int n) {
        int n2 = -14;
        this.originalMem.putInt2(n, n2);
        this.requestPacket.closePart(this.massExtent + this.extent * n, n);
    }

    public boolean fillWithStream(InputStream inputStream, StructuredMem structuredMem, Putval putval) throws SQLException {
        int n = this.size() - this.extent - 8;
        if (n <= 0) {
            structuredMem.putInt1(3, 27);
            return false;
        }
        int n2 = this.extent;
        byte[] byArray = new byte[4096];
        boolean bl = false;
        try {
            while (!bl && n > 0) {
                int n3 = inputStream.read(byArray, 0, Math.min(n, 4096));
                if (n3 == -1) {
                    bl = true;
                    continue;
                }
                this.putBytes(byArray, this.extent, n3);
                this.extent += n3;
                n -= n3;
            }
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
        }
        if (bl) {
            structuredMem.putInt1(2, 27);
        } else {
            structuredMem.putInt1(0, 27);
        }
        structuredMem.putInt4(this.massExtent + n2 + 1, 32);
        structuredMem.putInt4(this.extent - n2, 36);
        putval.markRequestedChunk(this.getPointer(n2), this.extent - n2);
        return bl;
    }

    public void markEmptyStream(StructuredMem structuredMem) {
        structuredMem.putInt1(2, 27);
        structuredMem.putInt4(this.massExtent + this.extent + 1, 32);
        structuredMem.putInt4(0, 36);
    }

    public boolean fillWithReader(Reader reader, StructuredMem structuredMem, Putval putval) throws SQLException {
        int n = (this.size() - this.extent) / 2;
        if (n <= 0) {
            structuredMem.putInt1(3, 27);
            return false;
        }
        int n2 = this.extent;
        char[] cArray = new char[4096];
        boolean bl = false;
        try {
            while (!bl && n > 0) {
                int n3 = reader.read(cArray, 0, Math.min(n, 4096));
                if (n3 == -1) {
                    bl = true;
                    continue;
                }
                this.putBigUnicode(cArray, this.extent, n3 * 2);
                this.extent += n3 * 2;
                n -= n3;
            }
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
        }
        if (bl) {
            structuredMem.putInt1(2, 27);
        } else {
            structuredMem.putInt1(0, 27);
        }
        structuredMem.putInt4(this.massExtent + n2 + 1, 32);
        structuredMem.putInt4(this.extent - n2, 36);
        putval.markRequestedChunk(this.getPointer(n2), this.extent - n2);
        return bl;
    }

    public boolean hasRoomFor(int n, int n2) {
        return this.argCount < Short.MAX_VALUE && this.size() - this.extent > n + n2;
    }

    public boolean hasRoomFor(int n) {
        return this.argCount < Short.MAX_VALUE && this.size() - this.extent > n;
    }

    public void putNull(int n, int n2) {
        this.putInt1(-1, n - 1);
        this.putBytes(new byte[n2], n);
        this.addArg(n, n2);
    }

    public int getExtent() {
        return this.extent;
    }

    public void setFirstPart() {
        this.requestPacket.addPartAttribute(4);
    }

    public void setLastPart() {
        this.requestPacket.addPartAttribute(1);
    }

    public void moveRecordBase() {
        this.moveBase(this.extent);
        this.massExtent += this.extent;
        this.extent = 0;
    }
}

