/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.app;

import ise.antelope.app.AboutDialog;
import ise.antelope.app.AntelopeGUILogHandler;
import ise.antelope.app.AntelopeSyntaxUtilities;
import ise.antelope.app.FindDialog;
import ise.antelope.app.OptionChooser;
import ise.antelope.app.OptionSettings;
import ise.antelope.app.StatusBar;
import ise.antelope.app.SyntaxChooser;
import ise.antelope.app.jedit.FindAndReplace;
import ise.antelope.app.jedit.JEditTextArea;
import ise.antelope.app.jedit.SyntaxDocument;
import ise.antelope.app.jedit.TextAreaDefaults;
import ise.antelope.app.jedit.XMLTokenMarker;
import ise.antelope.common.AntelopeOptions;
import ise.antelope.common.AntelopePanel;
import ise.antelope.common.CommonHelper;
import ise.antelope.common.CommonHelperWrapper;
import ise.antelope.common.Constants;
import ise.antelope.launcher.WhereIsAntDialog;
import ise.library.FileUtilities;
import ise.library.FontDialog;
import ise.library.GUIUtils;
import ise.library.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class Antelope
extends JFrame
implements CommonHelper {
    private static String usage = "java ise.antelope.Antelope build_file";
    private AntelopePanel _antelope_panel = null;
    private JSplitPane _split_pane = null;
    private JEditTextArea _editor;
    private JScrollPane _scroller;
    private JTabbedPane _tabs;
    private Font _font = null;
    private JMenu _file_menu = null;
    private JMenu _recent_menu = null;
    private File _build_file = null;
    private StatusBar status = null;
    private String[] args = null;

    public Antelope() {
        this.init(null);
    }

    public Antelope(String[] stringArray) {
        this.init(stringArray);
    }

    public void init(String[] stringArray) {
        Object object;
        this.args = stringArray;
        Log.log("init");
        this.setTitle("Antelope");
        File file = null;
        if (this.args != null && this.args.length > 0 && !(file = new File(this.args[0])).exists()) {
            JOptionPane.showMessageDialog(this, "Build file " + this.args[0] + " does not exist.", "Build File Not Found", 2);
            file = null;
        }
        this._tabs = new JTabbedPane();
        if (file == null && (object = Constants.PREFS.get("lastOpenFile", null)) != null) {
            file = new File((String)object);
        }
        Log.log("next create antelope panel");
        this._antelope_panel = new AntelopePanel(file, new CommonHelperWrapper(this), false);
        Log.log("created antelope panel");
        this._antelope_panel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string == null || string.length() == 0) {
                    return;
                }
                Antelope.this.status.setStatus(string);
            }
        });
        this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("images/red_ant.gif")).getImage());
        object = new JPanel(new BorderLayout());
        this._split_pane = new JSplitPane(1, this._antelope_panel, this._tabs);
        ((Container)object).add((Component)this._split_pane, "Center");
        this.status = new StatusBar();
        ((Container)object).add((Component)this.status, "South");
        this.setContentPane((Container)object);
        String string = Constants.PREFS.get("fontFamily", "Monospaced");
        int n = Constants.PREFS.getInt("fontStyle", 0);
        int n2 = Constants.PREFS.getInt("fontSize", 12);
        this._font = new Font(string, n, n2);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        this._file_menu = new JMenu("File");
        this._file_menu.setMnemonic(70);
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic(69);
        JMenu jMenu2 = new JMenu("Output");
        jMenu2.setMnemonic(79);
        JMenu jMenu3 = new JMenu("Options");
        jMenu3.setMnemonic(77);
        JMenu jMenu4 = new JMenu("Help");
        jMenu4.setMnemonic(72);
        JMenuItem jMenuItem = new JMenuItem("New Build File", new ImageIcon(this.getClass().getClassLoader().getResource("images/New16.gif")));
        JMenuItem jMenuItem2 = new JMenuItem("Open Build File", new ImageIcon(this.getClass().getClassLoader().getResource("images/Open16.gif")));
        JMenuItem jMenuItem3 = new JMenuItem("Save Build File", new ImageIcon(this.getClass().getClassLoader().getResource("images/Save16.gif")));
        JMenuItem jMenuItem4 = new JMenuItem("Exit", new ImageIcon(this.getClass().getClassLoader().getResource("images/Stop16.gif")));
        final JMenuItem jMenuItem5 = new JMenuItem("Undo", new ImageIcon(this.getClass().getClassLoader().getResource("images/Undo16.gif")));
        final JMenuItem jMenuItem6 = new JMenuItem("Redo", new ImageIcon(this.getClass().getClassLoader().getResource("images/Redo16.gif")));
        JMenuItem jMenuItem7 = new JMenuItem("Cut", new ImageIcon(this.getClass().getClassLoader().getResource("images/Cut16.gif")));
        JMenuItem jMenuItem8 = new JMenuItem("Copy", new ImageIcon(this.getClass().getClassLoader().getResource("images/Copy16.gif")));
        JMenuItem jMenuItem9 = new JMenuItem("Paste", new ImageIcon(this.getClass().getClassLoader().getResource("images/Paste16.gif")));
        JMenuItem jMenuItem10 = new JMenuItem("Find", new ImageIcon(this.getClass().getClassLoader().getResource("images/Find16.gif")));
        final JMenuItem jMenuItem11 = new JMenuItem("Replace", new ImageIcon(this.getClass().getClassLoader().getResource("images/Replace16.gif")));
        JMenuItem jMenuItem12 = new JMenuItem("Save Output", new ImageIcon(this.getClass().getClassLoader().getResource("images/Save16.gif")));
        JMenuItem jMenuItem13 = new JMenuItem("Clear Output", new ImageIcon(this.getClass().getClassLoader().getResource("images/New16.gif")));
        JMenuItem jMenuItem14 = new JMenuItem("Font...");
        JMenuItem jMenuItem15 = new JMenuItem("Editor...");
        JMenuItem jMenuItem16 = new JMenuItem("Syntax...");
        JMenuItem jMenuItem17 = new JMenuItem("Ant...");
        JMenuItem jMenuItem18 = new JMenuItem("Build File Options...");
        JMenuItem jMenuItem19 = new JMenuItem("Help", new ImageIcon(this.getClass().getClassLoader().getResource("images/Help16.gif")));
        JMenuItem jMenuItem20 = new JMenuItem("About", new ImageIcon(this.getClass().getClassLoader().getResource("images/About16.gif")));
        jMenuItem.setMnemonic(78);
        jMenuItem2.setMnemonic(79);
        jMenuItem3.setMnemonic(83);
        jMenuItem13.setMnemonic(78);
        jMenuItem14.setMnemonic(70);
        jMenuItem19.setMnemonic(72);
        jMenuItem20.setMnemonic(65);
        jMenuItem5.setMnemonic(90);
        jMenuItem6.setMnemonic(89);
        jMenuItem7.setMnemonic(88);
        jMenuItem8.setMnemonic(67);
        jMenuItem9.setMnemonic(86);
        jMenuItem10.setMnemonic(70);
        jMenuItem11.setMnemonic(82);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem13.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem19.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        jMenuItem20.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenuItem10.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenuItem11.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this._file_menu.add(jMenuItem);
        this._file_menu.add(jMenuItem2);
        this._file_menu.add(jMenuItem3);
        this._file_menu.addSeparator();
        this._file_menu.add(jMenuItem4);
        this._file_menu.addSeparator();
        this.adjustRecentFilesMenu();
        jMenu.add(jMenuItem5);
        jMenu.add(jMenuItem6);
        jMenu.addSeparator();
        jMenu.add(jMenuItem7);
        jMenu.add(jMenuItem8);
        jMenu.add(jMenuItem9);
        jMenu.addSeparator();
        jMenu.add(jMenuItem10);
        jMenu.add(jMenuItem11);
        jMenuItem11.setVisible(false);
        jMenu2.add(jMenuItem12);
        jMenu2.add(jMenuItem13);
        jMenu3.add(jMenuItem14);
        jMenu3.add(jMenuItem16);
        jMenu3.add(jMenuItem15);
        jMenu3.add(jMenuItem18);
        jMenu3.add(jMenuItem17);
        jMenu4.add(jMenuItem19);
        jMenu4.add(jMenuItem20);
        jMenuBar.add(this._file_menu);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = Antelope.this.createProject();
                if (file != null) {
                    Antelope.this._antelope_panel.openBuildFile(file);
                }
            }
        });
        jMenuItem.addActionListener(this.getEditButtonAction());
        jMenuItem2.addActionListener(this._antelope_panel.getOpenActionListener());
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Antelope.this.saveBuildFile();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Antelope.this.exit(0);
            }
        });
        jMenuItem19.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = this.getClass().getClassLoader().getResource("manual/index.html");
                    AboutDialog aboutDialog = new AboutDialog((Frame)Antelope.this, "Help", uRL, true);
                    GUIUtils.fillScreen(aboutDialog);
                    aboutDialog.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jMenuItem20.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = this.getClass().getClassLoader().getResource("about.html");
                    AboutDialog aboutDialog = new AboutDialog((Frame)Antelope.this, "About", uRL, true);
                    GUIUtils.center(Antelope.this, aboutDialog);
                    aboutDialog.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        Log.log("next create gui log handler");
        final AntelopeGUILogHandler antelopeGUILogHandler = new AntelopeGUILogHandler(false);
        antelopeGUILogHandler.setFont(this._font);
        this._antelope_panel.addLogHandler(antelopeGUILogHandler);
        Log.log("log handler created");
        final JTextComponent jTextComponent = antelopeGUILogHandler.getTextComponent();
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Antelope.this._tabs.getSelectedIndex();
                if (n == 0) {
                    FindDialog findDialog = new FindDialog(Antelope.this, jTextComponent);
                    GUIUtils.center(Antelope.this, findDialog);
                    findDialog.setVisible(true);
                } else if (n == 1) {
                    FindAndReplace findAndReplace = new FindAndReplace(Antelope.this, 0, Antelope.this._editor);
                    GUIUtils.center(Antelope.this, findAndReplace);
                    findAndReplace.setVisible(true);
                }
            }
        });
        jMenuItem11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Antelope.this._tabs.getSelectedIndex();
                if (n == 1) {
                    FindAndReplace findAndReplace = new FindAndReplace(Antelope.this, 1, Antelope.this._editor);
                    GUIUtils.center(Antelope.this, findAndReplace);
                    findAndReplace.setVisible(true);
                }
            }
        });
        jMenuItem14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Font font = FontDialog.showFontDialog(Antelope.this, Antelope.this._font);
                if (font != null) {
                    Antelope.this._font = font;
                    Constants.PREFS.put("fontFamily", Antelope.this._font.getFamily());
                    Constants.PREFS.putInt("fontStyle", Antelope.this._font.getStyle());
                    Constants.PREFS.putInt("fontSize", Antelope.this._font.getSize());
                    Antelope.this._editor.getPainter().setFont(font);
                    antelopeGUILogHandler.setFont(font);
                }
            }
        });
        jMenuItem16.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SyntaxChooser syntaxChooser = SyntaxChooser.showDialog(Antelope.this);
                if (syntaxChooser.getStyles() != null) {
                    Antelope.this._editor.getPainter().setStyles(syntaxChooser.getStyles());
                }
            }
        });
        jMenuItem15.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionChooser optionChooser = OptionChooser.showDialog(Antelope.this, Antelope.this._editor);
            }
        });
        jMenuItem18.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Antelope.this._antelope_panel.setOptionsPanel(AntelopeOptions.showDialog(Antelope.this._antelope_panel, Antelope.this));
            }
        });
        jMenuItem17.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WhereIsAntDialog whereIsAntDialog = new WhereIsAntDialog();
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JOptionPane.showMessageDialog(Antelope.this, "Antelope must be restarted before this change takes effect.\nRestart now?", "Ant Changed", 1);
                    }
                };
                whereIsAntDialog.addActionListener(actionListener);
                whereIsAntDialog.setVisible(true);
            }
        });
        this._tabs.add("Output", antelopeGUILogHandler.getPanel());
        jMenuItem12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Document document = antelopeGUILogHandler.getTextComponent().getDocument();
                    String string = document.getText(0, document.getLength());
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setDialogTitle("Save Output");
                    int n = jFileChooser.showSaveDialog(Antelope.this);
                    if (n == 1) {
                        return;
                    }
                    File file = jFileChooser.getSelectedFile();
                    StringReader stringReader = new StringReader(string);
                    FileWriter fileWriter = new FileWriter(file);
                    FileUtilities.copyToWriter(stringReader, fileWriter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        jMenuItem13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Document document = antelopeGUILogHandler.getTextComponent().getDocument();
                    document.remove(0, document.getLength());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this._editor = new JEditTextArea();
        this._editor.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                int n = caretEvent.getDot();
                Antelope.this.status.setLine(Antelope.this._editor.getLineOfOffset(n) + 1, Antelope.this._editor.getLineCount());
            }
        });
        OptionSettings optionSettings = new OptionSettings();
        optionSettings.load();
        optionSettings.apply(this._editor);
        this._editor.setTokenMarker(new XMLTokenMarker());
        this._editor.getPainter().setStyles(AntelopeSyntaxUtilities.getStoredStyles());
        this._font = new Font(Constants.PREFS.get("fontFamily", "dialog"), Constants.PREFS.getInt("fontStyle", 0), Constants.PREFS.getInt("fontSize", 12));
        this._editor.getPainter().setFont(this._font);
        this._editor.setCaretPosition(0);
        this._editor.scrollToCaret();
        this._tabs.add("Edit", this._editor);
        this._tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = Antelope.this._tabs.getSelectedIndex();
                if (n == 0) {
                    antelopeGUILogHandler.getTextComponent().requestFocus();
                    jMenuItem11.setVisible(false);
                } else {
                    jMenuItem11.setVisible(true);
                }
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Antelope.this._editor.undo();
                jMenuItem5.setEnabled(Antelope.this._editor.canUndo());
                jMenuItem6.setEnabled(Antelope.this._editor.canRedo());
            }
        });
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Antelope.this._editor.redo();
                jMenuItem5.setEnabled(Antelope.this._editor.canUndo());
                jMenuItem6.setEnabled(Antelope.this._editor.canRedo());
            }
        });
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Antelope.this._editor.cut();
            }
        });
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Antelope.this._editor.copy();
            }
        });
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Antelope.this._editor.paste();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Antelope.this.loadBuildFile();
            }
        });
        this.loadBuildFile();
        this._antelope_panel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Antelope.this.loadBuildFile();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Antelope.this.exit(0);
            }
        });
        jMenuItem5.setEnabled(this._editor.canUndo());
        jMenuItem6.setEnabled(this._editor.canRedo());
        Log.log("next pack");
        this.pack();
        jTextComponent.requestFocus();
        int n3 = Constants.PREFS.getInt("app_x", 0);
        int n4 = Constants.PREFS.getInt("app_y", 0);
        int n5 = Constants.PREFS.getInt("app_w", 0);
        int n6 = Constants.PREFS.getInt("app_h", 0);
        if (n5 == 0 || n6 == 0) {
            GUIUtils.fillScreen(this);
        } else {
            this.setBounds(n3, n4, n5, n6);
        }
        Log.log("bounds set");
        int n7 = Constants.PREFS.getInt("divider_location", 0);
        if (n7 == 0) {
            this._split_pane.setDividerLocation(0.25);
        } else {
            this._split_pane.setDividerLocation(n7);
        }
        this.setVisible(true);
        Log.log("set visible");
        this.status.setStatus("Antelope ready.");
        Log.log("ready");
    }

    private void exit(int n) {
        try {
            Rectangle rectangle = this.getBounds();
            Constants.PREFS.putInt("app_x", rectangle.x);
            Constants.PREFS.putInt("app_y", rectangle.y);
            Constants.PREFS.putInt("app_w", rectangle.width);
            Constants.PREFS.putInt("app_h", rectangle.height);
            Constants.PREFS.putInt("divider_location", this._split_pane.getDividerLocation());
            Constants.PREFS.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._antelope_panel.close();
        System.exit(n);
    }

    private File createProject() {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Create Build File");
            int n = jFileChooser.showOpenDialog(this);
            if (n == 1) {
                return null;
            }
            String string = System.getProperty("line.separator");
            File file = jFileChooser.getSelectedFile();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<project name=\"\" default=\"default\" basedir=\".\">");
            stringBuffer.append(string);
            stringBuffer.append("   <target name=\"default\"/>");
            stringBuffer.append(string);
            stringBuffer.append("</project>");
            StringReader stringReader = new StringReader(stringBuffer.toString());
            FileUtilities.copyToWriter(stringReader, new FileWriter(file));
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void loadBuildFile() {
        File file = this._antelope_panel.getBuildFile();
        if (file == null) {
            return;
        }
        this.openFile(file);
    }

    public void openFile(File file) {
        final File file2 = file;
        if (file2 == null) {
            return;
        }
        if (file2.isDirectory()) {
            return;
        }
        if (file2.equals(this._build_file)) {
            return;
        }
        try {
            FileReader fileReader = new FileReader(file2);
            StringWriter stringWriter = new StringWriter();
            FileUtilities.copyToWriter(fileReader, stringWriter);
            TextAreaDefaults textAreaDefaults = TextAreaDefaults.getDefaults();
            SyntaxDocument syntaxDocument = textAreaDefaults.document;
            syntaxDocument.putProperty(SyntaxDocument.FILE, file2);
            syntaxDocument.remove(0, syntaxDocument.getLength());
            syntaxDocument.insertString(0, stringWriter.toString(), null);
            this._editor.setDocument(syntaxDocument);
            this._editor.setCaretPosition(0);
            this._editor.scrollToCaret();
            this.setTitle("Antelope: " + file2.getAbsolutePath());
            this._editor.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    Antelope.this.setTitle("Antelope: " + file2.getAbsolutePath() + "*");
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    Antelope.this.setTitle("Antelope: " + file2.getAbsolutePath() + "*");
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    Antelope.this.setTitle("Antelope: " + file2.getAbsolutePath() + "*");
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveBuildFile() {
        SyntaxDocument syntaxDocument = (SyntaxDocument)this._editor.getDocument();
        File file = (File)syntaxDocument.getProperty(SyntaxDocument.FILE);
        if (file == null) {
            return;
        }
        int n = this._editor.getCaretPosition();
        try {
            StringReader stringReader = new StringReader(this._editor.getText());
            FileWriter fileWriter = new FileWriter(file);
            FileUtilities.copyToWriter(stringReader, fileWriter);
            this._antelope_panel.reload();
            this.setTitle("Antelope: " + file.getAbsolutePath());
            this._editor.setCaretPosition(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ArrayList getRecentFilesList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = Constants.PREFS.get("recent_list", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        StringBuffer stringBuffer = new StringBuffer();
        MenuItemListener menuItemListener = new MenuItemListener();
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            if (!file.exists()) {
                try {
                    object = Constants.PREFS.node(String.valueOf(file.hashCode()));
                    ((Preferences)object).removeNode();
                }
                catch (Exception exception) {}
                continue;
            }
            object = new JMenuItem(string2);
            ((AbstractButton)object).addActionListener(menuItemListener);
            arrayList.add(object);
            stringBuffer.append(string2).append(File.pathSeparator);
        }
        Constants.PREFS.put("recent_list", stringBuffer.toString());
        return arrayList;
    }

    private void adjustRecentFilesMenu() {
        for (int i = this._file_menu.getItemCount() - 1; i > 5; --i) {
            this._file_menu.remove(i);
        }
        ArrayList arrayList = this.getRecentFilesList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this._file_menu.add((JMenuItem)iterator.next());
        }
    }

    public void setTargetExecutionThread(Thread thread) {
    }

    public void updateGUI() {
        int n = this._tabs.getSelectedIndex();
        if (n == 1) {
            this._tabs.setSelectedIndex(0);
        }
        this._tabs.setSelectedIndex(1);
        this.setVisible(true);
    }

    public boolean canSaveBeforeRun() {
        return false;
    }

    public void saveBeforeRun() {
    }

    public void clearErrorSource() {
    }

    public boolean canShowEditButton() {
        return true;
    }

    public ActionListener getEditButtonAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Antelope.this._tabs.setSelectedIndex(1);
            }
        };
    }

    public ActionListener getRunButtonAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Antelope.this._tabs.setSelectedIndex(0);
            }
        };
    }

    public ActionListener getTraceButtonAction() {
        return this.getRunButtonAction();
    }

    public ClassLoader getAntClassLoader() {
        return null;
    }

    public List getAntJarList() {
        return null;
    }

    public void reloadAnt() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        switch (actionEvent.getID()) {
            case 470226: {
                if (actionEvent.getSource() instanceof Point) {
                    Point point = (Point)actionEvent.getSource();
                    int n = this._editor.getLineStartOffset(point.x - 1);
                    this._editor.setCaretPosition(n);
                    this._editor.scrollToCaret();
                    break;
                }
                try {
                    String string = actionEvent.getActionCommand();
                    String string2 = this._editor.getText();
                    Pattern pattern = Pattern.compile("(<target)(.+?)(>)", 32);
                    Matcher matcher = pattern.matcher(string2);
                    while (matcher.find()) {
                        String string3;
                        int n = matcher.start();
                        int n2 = matcher.end();
                        if (n < 0 || n2 < 0 || (string3 = string2.substring(n, n2)).indexOf("name=\"" + string + "\"") <= 0) continue;
                        this._editor.setCaretPosition(n);
                        this._editor.scrollToCaret();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 550927: {
                break;
            }
            case 810217: {
                this.adjustRecentFilesMenu();
            }
        }
    }

    public static void main(String[] stringArray) {
        Log.log("main");
        try {
            Class.forName("ise.antelope.common.Constants");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Antelope antelope = new Antelope();
        antelope.init(stringArray);
    }

    public class MenuItemListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Log.log("MenuItemListener.actionPerformed");
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getText();
            Log.log("MenuItemListener, filename is " + string);
            Antelope.this._antelope_panel.openBuildFile(new File(string));
            Log.log("MenuItemListener, after openBuildFile");
        }
    }
}

