/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.app;

import ise.antelope.app.jedit.JEditTextArea;
import ise.antelope.app.jedit.TextAreaPainter;
import ise.antelope.common.Constants;
import java.awt.Color;

public class OptionSettings {
    private boolean caretBlinks = true;
    private Color caretColor = Color.black;
    private int electricScroll = 3;
    private int tabSize = 4;
    private boolean useSmartHome = false;
    private Color selectionColor = new Color(0xCCCCFF);
    private Color lineHighlightColor = new Color(0xE0E0E0);
    private boolean showLineHighlight = true;
    private Color bracketHighlightColor = Color.black;
    private boolean showBracketHighlight = false;
    private Color eolMarkerColor = new Color(39321);
    private boolean showEolMarker = false;
    private boolean useNativeLF = false;

    public boolean getCaretBlinks() {
        return this.caretBlinks;
    }

    public void setCaretBlinks(boolean bl) {
        this.caretBlinks = bl;
    }

    public Color getCaretColor() {
        return this.caretColor;
    }

    public void setCaretColor(Color color) {
        this.caretColor = color;
    }

    public int getElectricScroll() {
        return this.electricScroll;
    }

    public void setElectricScroll(int n) {
        this.electricScroll = n;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int n) {
        this.tabSize = n;
    }

    public boolean useSmartHome() {
        return this.useSmartHome;
    }

    public void setUseSmartHome(boolean bl) {
        this.useSmartHome = bl;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
    }

    public Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public void setLineHighlightColor(Color color) {
        this.lineHighlightColor = color;
    }

    public boolean showLineHighlight() {
        return this.showLineHighlight;
    }

    public void setShowLineHighlight(boolean bl) {
        this.showLineHighlight = bl;
    }

    public Color getBracketHighlightColor() {
        return this.bracketHighlightColor;
    }

    public void setBracketHighlightColor(Color color) {
        this.bracketHighlightColor = color;
    }

    public boolean showBracketHighlight() {
        return this.showBracketHighlight;
    }

    public void setShowBracketHighlight(boolean bl) {
        this.showBracketHighlight = bl;
    }

    public Color getEolMarkerColor() {
        return this.eolMarkerColor;
    }

    public void setEolMarkerColor(Color color) {
        this.eolMarkerColor = color;
    }

    public boolean showEolMarker() {
        return this.showEolMarker;
    }

    public void setShowEolMarker(boolean bl) {
        this.showEolMarker = bl;
    }

    public void setUseNativeLookAndFeel(boolean bl) {
        this.useNativeLF = bl;
    }

    public boolean getUseNativeLookAndFeel() {
        return this.useNativeLF;
    }

    public void load() {
        this.caretBlinks = Constants.PREFS.getBoolean("caret_blinks", true);
        this.caretColor = new Color(Constants.PREFS.getInt("caret_color", 0));
        this.electricScroll = Constants.PREFS.getInt("electric_scroll_height", 3);
        this.useSmartHome = Constants.PREFS.getBoolean("smart_home", false);
        this.tabSize = Constants.PREFS.getInt("tab_size", 4);
        this.selectionColor = new Color(Constants.PREFS.getInt("selection_color", 0xCCCCFF));
        this.lineHighlightColor = new Color(Constants.PREFS.getInt("line_hilite_color", 0xE0E0E0));
        this.showLineHighlight = Constants.PREFS.getBoolean("show_line_hilite", true);
        this.bracketHighlightColor = new Color(Constants.PREFS.getInt("bracket_hilite_color", 0));
        this.showBracketHighlight = Constants.PREFS.getBoolean("show_bracket_hilite", false);
        this.eolMarkerColor = new Color(Constants.PREFS.getInt("eol_marker_color", 39321));
        this.showEolMarker = Constants.PREFS.getBoolean("show_eol_marker", false);
        this.useNativeLF = Constants.PREFS.getBoolean("use_native_look_and_feel", false);
    }

    public void save() {
        Constants.PREFS.putBoolean("caret_blinks", this.getCaretBlinks());
        Constants.PREFS.putInt("caret_color", this.getCaretColor().getRGB());
        Constants.PREFS.putInt("electric_scroll_height", this.getElectricScroll());
        Constants.PREFS.putBoolean("smart_home", this.useSmartHome());
        Constants.PREFS.putInt("tab_size", this.tabSize);
        Constants.PREFS.putInt("selection_color", this.getSelectionColor().getRGB());
        Constants.PREFS.putInt("line_hilite_color", this.getLineHighlightColor().getRGB());
        Constants.PREFS.putBoolean("show_line_hilite", this.showLineHighlight());
        Constants.PREFS.putInt("bracket_hilite_color", this.getBracketHighlightColor().getRGB());
        Constants.PREFS.putBoolean("show_bracket_hilite", this.showBracketHighlight());
        Constants.PREFS.putInt("eol_marker_color", this.getEolMarkerColor().getRGB());
        Constants.PREFS.putBoolean("show_eol_marker", this.showEolMarker());
        Constants.PREFS.putBoolean("use_native_look_and_feel", this.getUseNativeLookAndFeel());
    }

    public void apply(JEditTextArea jEditTextArea) {
        TextAreaPainter textAreaPainter = jEditTextArea.getPainter();
        textAreaPainter.setCaretColor(this.getCaretColor());
        jEditTextArea.setElectricScroll(this.getElectricScroll());
        jEditTextArea.getDocument().putProperty("tabSize", new Integer(this.tabSize));
        jEditTextArea.putClientProperty("InputHandler.homeEnd", new Boolean(this.useSmartHome()));
        textAreaPainter.setSelectionColor(this.getSelectionColor());
        textAreaPainter.setLineHighlightColor(this.getLineHighlightColor());
        textAreaPainter.setLineHighlightEnabled(this.showLineHighlight());
        textAreaPainter.setBracketHighlightEnabled(this.showBracketHighlight());
        textAreaPainter.setBracketHighlightColor(this.getBracketHighlightColor());
        textAreaPainter.setEOLMarkersPainted(this.showEolMarker());
        textAreaPainter.setEOLMarkerColor(this.getEolMarkerColor());
    }
}

