/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class AntFileHandler
extends Handler {
    private FileWriter writer;
    private File file;
    private String lSep = System.getProperty("line.separator");

    public AntFileHandler(File file) throws IOException {
        this(file, false);
    }

    public AntFileHandler(File file, boolean bl) throws IOException {
        this.file = file;
        this.writer = new FileWriter(file, bl);
    }

    public String getFile() {
        return this.file.getAbsolutePath();
    }

    public void publish(LogRecord logRecord) {
        try {
            String string = logRecord.getMessage();
            this.writer.write(string + this.lSep);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isLoggable(LogRecord logRecord) {
        Object[] objectArray = logRecord.getParameters();
        if (objectArray == null || objectArray.length == 0) {
            return true;
        }
        String string = (String)objectArray[0];
        String string2 = string + "." + this.getFile();
        String string3 = System.getProperty(string2);
        if (string3 == null) {
            return true;
        }
        return !(string3 = string3.toLowerCase()).equals("off") && !string3.equals("false") && !string3.equals("no");
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

