/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.common;

import ise.antelope.common.AntInputHandler;
import ise.antelope.common.AntLogger;
import ise.antelope.common.AntPerformanceListener;
import ise.antelope.common.AntProgressListener;
import ise.antelope.common.AntUtils;
import ise.antelope.common.AntelopeOptions;
import ise.antelope.common.AntelopeProperties;
import ise.antelope.common.CommonHelper;
import ise.antelope.common.CommonHelperWrapper;
import ise.antelope.common.Constants;
import ise.antelope.common.MenuItemListener;
import ise.antelope.common.OptionSettings;
import ise.antelope.common.SAXPanel;
import ise.antelope.common.SAXTreeNode;
import ise.antelope.common.TraceTarget;
import ise.library.DeckPanel;
import ise.library.GUIUtils;
import ise.library.KappaLayout;
import ise.library.Log;
import ise.library.PrivilegedAccessor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;

public class AntelopePanel
extends JPanel {
    private Preferences _prefs = Constants.PREFS;
    private OptionSettings _settings = null;
    private AntLogger _build_logger = null;
    private AntPerformanceListener _performance_listener = null;
    private Project _project = null;
    private HashMap _property_files = null;
    private Target _unnamed_target = null;
    private Map _targets = null;
    private ArrayList _buttons = null;
    private ArrayList _execute_targets = null;
    private DeckPanel _center_panel = null;
    private JPanel _button_panel = null;
    private JTabbedPane _tabs = null;
    private SAXPanel _sax_panel = null;
    private JPanel _control_panel = null;
    private JToggleButton _run_btn = null;
    private JToggleButton _trace_btn = null;
    private JToggleButton _edit_btn = null;
    private JButton _props_btn = null;
    private JButton _options_btn = null;
    private JButton _reload_btn = null;
    private JCheckBox _multi = new JCheckBox("Multiple targets");
    private AbstractButton _default_btn = null;
    private JScrollPane _scroller = null;
    private JPanel _btn_container = null;
    private JTextField _project_name = null;
    private File _last_directory = null;
    private File _build_file = null;
    private boolean _trace = false;
    private boolean _edit = false;
    private Thread _runner = null;
    private Thread _target_runner = null;
    private ArrayList _last_ran_targets = null;
    private AntelopeOptions _options = null;
    private JMenu _recent = null;
    private boolean _use_internal_menu = true;
    private Logger _logger = null;
    private Handler _console = null;
    private Level _log_level = Level.ALL;
    private ArrayList _listeners = null;
    private CommonHelper _helper = null;
    private AntProgressListener _progress = null;
    private Color GREEN = new Color(0, 153, 51);
    private String IMPLICIT_TARGET_NAME = "&lt;implicit&gt;";
    private ActionListener _cb_listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (AntelopePanel.this._execute_targets == null) {
                AntelopePanel.this._execute_targets = new ArrayList();
            }
            if (jCheckBox.isSelected()) {
                AntelopePanel.this._execute_targets.add(jCheckBox);
                jCheckBox.setText(jCheckBox.getActionCommand() + " (" + AntelopePanel.this._execute_targets.size() + ")");
            } else {
                AntelopePanel.this._execute_targets.remove(jCheckBox);
                jCheckBox.setText(jCheckBox.getActionCommand());
                for (int i = 0; i < AntelopePanel.this._execute_targets.size(); ++i) {
                    jCheckBox = (JCheckBox)AntelopePanel.this._execute_targets.get(i);
                    jCheckBox.setText(jCheckBox.getActionCommand() + " (" + (i + 1) + ")");
                }
            }
        }
    };
    private ActionListener _execute_listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ActionEvent actionEvent2 = actionEvent;
            final AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            String string = actionEvent2.getActionCommand();
            if (AntelopePanel.this._runner != null && AntelopePanel.this._runner.isAlive()) {
                AntelopePanel.this._target_runner = null;
                AntelopePanel.this._runner.interrupt();
                return;
            }
            if (AntelopePanel.this._trace) {
                AntelopePanel.this.log("");
                Hashtable hashtable = AntelopePanel.this._project.getTargets();
                TraceTarget traceTarget = new TraceTarget();
                Target target = (Target)hashtable.get(string);
                AntelopePanel.this.log(traceTarget.traceTarget(target));
                return;
            }
            if (AntelopePanel.this._edit) {
                AntelopePanel.this._helper.actionPerformed(new ActionEvent(this, 470226, string));
                return;
            }
            AntelopePanel.this._runner = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    Component[] componentArray;
                    block17: {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        if (AntUtils.getAntVersion() == 1.6 && AntelopePanel.this._unnamed_target != null) {
                            arrayList.add(AntelopePanel.this._unnamed_target.getName());
                        }
                        Iterator iterator = AntelopePanel.this._execute_targets.iterator();
                        while (iterator.hasNext()) {
                            componentArray = (JCheckBox)iterator.next();
                            arrayList.add(componentArray.getActionCommand());
                        }
                        if (AntelopePanel.this._settings.getAutoReload() || AntelopePanel.this.shouldReload()) {
                            String string;
                            Object object;
                            int n;
                            try {
                                AntelopePanel.this.reload();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            componentArray = AntelopePanel.this._button_panel.getComponents();
                            for (n = 0; n < componentArray.length; ++n) {
                                object = (AbstractButton)componentArray[n];
                                if (!(object instanceof JCheckBox) || arrayList.contains(string = ((AbstractButton)object).getActionCommand())) continue;
                                arrayList.remove(string);
                            }
                            object = arrayList.iterator();
                            block8: while (object.hasNext()) {
                                string = (String)object.next();
                                for (n = 0; n < componentArray.length; ++n) {
                                    AbstractButton abstractButton2 = (AbstractButton)componentArray[n];
                                    if (!string.equals(abstractButton2.getActionCommand())) continue;
                                    abstractButton2.doClick();
                                    continue block8;
                                }
                            }
                        }
                        componentArray = abstractButton.getForeground();
                        abstractButton.setForeground(Color.RED);
                        AntelopePanel.this.saveBeforeRun();
                        try {
                            try {
                                if (AntelopePanel.this._settings.getShowPerformanceOutput() && AntelopePanel.this._performance_listener != null) {
                                    AntelopePanel.this._performance_listener.reset();
                                }
                                if (AntUtils.getAntVersion() == 1.6 && AntelopePanel.this._unnamed_target != null) {
                                    arrayList.add(AntelopePanel.this._unnamed_target.getName());
                                }
                                AntelopePanel.this.executeTargets(this, arrayList);
                            }
                            catch (Exception exception) {
                                AntelopePanel.this._project.fireBuildFinished((Throwable)exception);
                                Object var9_11 = null;
                                if (AntelopePanel.this._settings.getShowPerformanceOutput() && AntelopePanel.this._performance_listener != null) {
                                    AntelopePanel.this.log(AntelopePanel.this._performance_listener.getPerformanceStatistics());
                                    AntelopePanel.this._performance_listener.reset();
                                }
                                AntelopePanel.this._build_logger.close();
                                abstractButton.setForeground((Color)componentArray);
                                abstractButton.setSelected(false);
                                return;
                            }
                            Object var9_10 = null;
                            if (!AntelopePanel.this._settings.getShowPerformanceOutput()) break block17;
                        }
                        catch (Throwable throwable) {
                            Object var9_12 = null;
                            if (AntelopePanel.this._settings.getShowPerformanceOutput() && AntelopePanel.this._performance_listener != null) {
                                AntelopePanel.this.log(AntelopePanel.this._performance_listener.getPerformanceStatistics());
                                AntelopePanel.this._performance_listener.reset();
                            }
                            AntelopePanel.this._build_logger.close();
                            abstractButton.setForeground((Color)componentArray);
                            abstractButton.setSelected(false);
                            throw throwable;
                        }
                        if (AntelopePanel.this._performance_listener != null) {
                            AntelopePanel.this.log(AntelopePanel.this._performance_listener.getPerformanceStatistics());
                            AntelopePanel.this._performance_listener.reset();
                        }
                    }
                    AntelopePanel.this._build_logger.close();
                    abstractButton.setForeground((Color)componentArray);
                    abstractButton.setSelected(false);
                }

                public void interrupt() {
                    if (!this.isAlive()) {
                        return;
                    }
                    super.interrupt();
                    AntelopePanel.this.log(Level.SEVERE, "=====> BUILD INTERRUPTED <=====");
                }
            };
            AntelopePanel.this._target_runner = AntelopePanel.this._runner;
            AntelopePanel.this._runner.start();
        }
    };
    private ActionListener _button_listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ActionEvent actionEvent2 = actionEvent;
            String string = actionEvent2.getActionCommand();
            if (AntelopePanel.this._runner != null && AntelopePanel.this._runner.isAlive()) {
                AntelopePanel.this._runner.interrupt();
                return;
            }
            if (AntelopePanel.this._trace) {
                AntelopePanel.this.log("");
                Hashtable hashtable = AntelopePanel.this._project.getTargets();
                TraceTarget traceTarget = new TraceTarget();
                Target target = (Target)hashtable.get(string);
                AntelopePanel.this.log(traceTarget.traceTarget(target));
                return;
            }
            if (AntelopePanel.this._edit) {
                AntelopePanel.this._helper.actionPerformed(new ActionEvent(this, 470226, string));
                return;
            }
            if (AntelopePanel.this._settings.getAutoReload() || AntelopePanel.this.shouldReload()) {
                AntelopePanel.this.reload();
            }
            AntelopePanel.this.executeTarget(string);
        }
    };

    public AntelopePanel() {
        this(null, null, true);
    }

    public AntelopePanel(CommonHelperWrapper commonHelperWrapper) {
        this(null, commonHelperWrapper, true);
    }

    public AntelopePanel(File file, CommonHelperWrapper commonHelperWrapper, boolean bl) {
        this(file, commonHelperWrapper, bl, null);
    }

    public AntelopePanel(List list) {
        switch (list.size()) {
            case 0: {
                this.init(null, null, true, null);
                break;
            }
            case 1: {
                this.init(null, (CommonHelperWrapper)list.get(0), true, null);
                break;
            }
            case 3: {
                this.init((File)list.get(0), (CommonHelperWrapper)list.get(1), (Boolean)list.get(2), null);
                break;
            }
            case 4: {
                File file = (File)list.get(0);
                CommonHelperWrapper commonHelperWrapper = (CommonHelperWrapper)list.get(1);
                boolean bl = (Boolean)list.get(2);
                List list2 = (List)list.get(3);
                this.init(file, commonHelperWrapper, bl, list2);
            }
        }
    }

    public AntelopePanel(File file, CommonHelperWrapper commonHelperWrapper, boolean bl, List list) {
        this.init(file, commonHelperWrapper, bl, list);
    }

    private void init(File file, CommonHelperWrapper commonHelperWrapper, boolean bl, List list) {
        Object object;
        this.setLayout(new BorderLayout());
        this._helper = commonHelperWrapper;
        this._use_internal_menu = bl;
        this.setPrefs(file);
        try {
            Class.forName("ise.library.GUIUtils");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        try {
            Class.forName("javax.xml.parsers.SAXParserFactory");
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(GUIUtils.getRootJFrame(this), "<html>Error:<br>" + exception.getMessage(), "Ant Error", 0);
        }
        try {
            this.getClass().getClassLoader().getResource("ise/antelope/tasks/antlib.xml");
            this.getClass().getClassLoader().getResource("ise/antelope/tasks/antelope.taskdefs");
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(GUIUtils.getRootJFrame(this), "<html>Error:<br>" + exception.getMessage(), "Ant Error", 0);
        }
        this._control_panel = new JPanel();
        Insets insets = new Insets(1, 1, 1, 1);
        this._run_btn = new JToggleButton();
        this._run_btn.setToolTipText("Run target mode");
        this._run_btn.setMargin(insets);
        this._run_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AntelopePanel.this._edit = false;
                AntelopePanel.this._trace = false;
                AntelopePanel.this._center_panel.show("panel");
                AntelopePanel.this._button_panel.setBackground(Color.WHITE);
            }
        });
        if (this._helper != null && this._helper.getRunButtonAction() != null) {
            this._run_btn.addActionListener(this._helper.getRunButtonAction());
        }
        this._run_btn.setSelected(true);
        this._trace_btn = new JToggleButton();
        this._trace_btn.setMargin(insets);
        this._trace_btn.setToolTipText("Trace mode");
        this._trace_btn.setSelected(this._trace);
        this._trace_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AntelopePanel.this._trace = true;
                AntelopePanel.this._edit = false;
                AntelopePanel.this._center_panel.show("panel");
                AntelopePanel.this._button_panel.setBackground(Color.BLUE);
            }
        });
        if (this._helper != null && this._helper.getTraceButtonAction() != null) {
            this._trace_btn.addActionListener(this._helper.getTraceButtonAction());
        }
        this._edit_btn = new JToggleButton();
        this._edit_btn.setMargin(insets);
        this._edit_btn.setToolTipText("Edit mode");
        this._edit_btn.setSelected(this._edit);
        if (this._helper != null && (object = this._helper.getEditButtonAction()) != null) {
            this._edit_btn.addActionListener((ActionListener)object);
        }
        this._edit_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AntelopePanel.this._edit = true;
                AntelopePanel.this._trace = false;
                AntelopePanel.this._center_panel.show("tree");
            }
        });
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this._run_btn);
        ((ButtonGroup)object).add(this._trace_btn);
        ((ButtonGroup)object).add(this._edit_btn);
        this._props_btn = new JButton();
        this._props_btn.setMargin(insets);
        this._props_btn.setToolTipText("Show current build properties for Ant");
        this._props_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AntelopePanel.this.showProperties();
            }
        });
        this._options_btn = new JButton();
        this._options_btn.setMargin(insets);
        this._options_btn.setToolTipText("Show output display options");
        this._options_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AntelopePanel.this._options = AntelopeOptions.showDialog(AntelopePanel.this, AntelopePanel.this._helper);
            }
        });
        this._reload_btn = new JButton();
        this._reload_btn.setMargin(insets);
        this._reload_btn.setToolTipText("Reload current build file");
        this._reload_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AntelopePanel.this.reload();
            }
        });
        this._control_panel.setLayout(new GridLayout(2, 3, 1, 1));
        this._control_panel.add(this._run_btn);
        this._control_panel.add(this._trace_btn);
        this._control_panel.add(this._edit_btn);
        this._control_panel.add(this._props_btn);
        this._control_panel.add(this._options_btn);
        this._control_panel.add(this._reload_btn);
        this.showButtonText(this._settings.getShowButtonText());
        this.showButtonIcon(this._settings.getShowButtonIcon());
        this._project_name = new JTextField(){

            public void setText(String string) {
                if (string != null && string.length() > 0) {
                    super.setText("Ant Project: " + string);
                } else {
                    super.setText("");
                }
            }
        };
        this._project_name.setEditable(false);
        this._project_name.setText("None");
        this._progress = new AntProgressListener();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this._control_panel, "North");
        jPanel.add((Component)this._progress, "Center");
        jPanel.add((Component)this._project_name, "South");
        this.add((Component)jPanel, "South");
        this._recent = this.getRecentFilesMenu();
        if (this._use_internal_menu) {
            Object object2;
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Open");
            if (list != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    jMenu.add((JMenuItem)object2.next());
                }
            }
            jMenuItem.addActionListener(this.getOpenActionListener());
            jMenu.add(jMenuItem);
            object2 = new JMenuItem("Reload");
            ((AbstractButton)object2).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AntelopePanel.this.reload();
                }
            });
            jMenu.add((JMenuItem)object2);
            jMenu.add(this._recent);
            jMenuBar.add(jMenu);
            this.add((Component)jMenuBar, "North");
        }
        this._multi.setToolTipText("Execute multiple targets sequentially");
        this._multi.setSelected(this._settings.getMultipleTargets());
        this._multi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AntelopePanel.this.openBuildFile(AntelopePanel.this._build_file);
            }
        });
        this.initLogger();
        this.openBuildFile(file);
    }

    public void executeTarget(String string) {
        final String string2 = string;
        this._target_runner = this._runner = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Color color;
                Component component;
                block13: {
                    Component[] componentArray = AntelopePanel.this._button_panel.getComponents();
                    component = null;
                    for (int i = 0; i < componentArray.length; ++i) {
                        if (!string2.equals(((AbstractButton)componentArray[i]).getActionCommand())) continue;
                        component = (AbstractButton)componentArray[i];
                        break;
                    }
                    color = null;
                    if (component != null) {
                        color = component.getForeground();
                        ((JComponent)component).setForeground(Color.RED);
                    }
                    AntelopePanel.this.saveBeforeRun();
                    try {
                        try {
                            if (AntelopePanel.this._settings.getShowPerformanceOutput() && AntelopePanel.this._performance_listener != null) {
                                AntelopePanel.this._performance_listener.reset();
                            }
                            ArrayList<String> arrayList = new ArrayList<String>();
                            if (AntUtils.getAntVersion() == 1.6 && AntelopePanel.this._unnamed_target != null) {
                                arrayList.add("");
                            }
                            if (!string2.equals(AntelopePanel.this.IMPLICIT_TARGET_NAME)) {
                                arrayList.add(string2);
                            }
                            AntelopePanel.this.executeTargets(this, arrayList);
                        }
                        catch (Exception exception) {
                            AntelopePanel.this._project.fireBuildFinished((Throwable)exception);
                            Object var7_8 = null;
                            if (AntelopePanel.this._settings.getShowPerformanceOutput() && AntelopePanel.this._performance_listener != null) {
                                AntelopePanel.this.log(AntelopePanel.this._performance_listener.getPerformanceStatistics());
                                AntelopePanel.this._performance_listener.reset();
                            }
                            AntelopePanel.this._build_logger.close();
                            if (component == null) return;
                            if (color == null) return;
                            ((JComponent)component).setForeground(color);
                            ((AbstractButton)component).setSelected(false);
                            return;
                        }
                        Object var7_7 = null;
                        if (!AntelopePanel.this._settings.getShowPerformanceOutput()) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        if (AntelopePanel.this._settings.getShowPerformanceOutput() && AntelopePanel.this._performance_listener != null) {
                            AntelopePanel.this.log(AntelopePanel.this._performance_listener.getPerformanceStatistics());
                            AntelopePanel.this._performance_listener.reset();
                        }
                        AntelopePanel.this._build_logger.close();
                        if (component == null) throw throwable;
                        if (color == null) throw throwable;
                        ((JComponent)component).setForeground(color);
                        ((AbstractButton)component).setSelected(false);
                        throw throwable;
                    }
                    if (AntelopePanel.this._performance_listener != null) {
                        AntelopePanel.this.log(AntelopePanel.this._performance_listener.getPerformanceStatistics());
                        AntelopePanel.this._performance_listener.reset();
                    }
                }
                AntelopePanel.this._build_logger.close();
                if (component == null) return;
                if (color == null) return;
                ((JComponent)component).setForeground(color);
                ((AbstractButton)component).setSelected(false);
            }

            public void interrupt() {
                if (!this.isAlive()) {
                    return;
                }
                super.interrupt();
                AntelopePanel.this.log(Level.SEVERE, "=====> BUILD INTERRUPTED <=====");
            }
        };
        this._runner.start();
    }

    private void executeTargets(Thread thread, ArrayList arrayList) throws Exception {
        this._last_ran_targets = arrayList;
        this.clearErrorSource();
        this._build_logger.open();
        this._build_logger.setMessageOutputLevel(this._settings.getMessageOutputLevel());
        this._build_logger.SHOW_BUILD_EVENTS = this._settings.getShowBuildEvents();
        this._build_logger.SHOW_TARGET_EVENTS = this._settings.getShowTargetEvents();
        this._build_logger.SHOW_TASK_EVENTS = this._settings.getShowTaskEvents();
        this._build_logger.SHOW_LOG_MSGS = this._settings.getShowLogMessages();
        System.setProperty("org.apache.tools.ant.ProjectHelper", "org.apache.tools.ant.helper.ProjectHelper2");
        this._progress.setExecutingTarget(this._project, arrayList);
        if (this._helper != null && thread != null) {
            this._helper.setTargetExecutionThread(thread);
        }
        this.log(" ");
        this._project.fireBuildStarted();
        if (this._unnamed_target != null) {
            Log.log("executing implicit target");
            this._unnamed_target.execute();
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("") && this._unnamed_target != null) continue;
            Log.log("executing target " + string);
            this._project.executeTarget(string);
            if (this._target_runner == thread) continue;
            break;
        }
        this._project.fireBuildFinished(null);
        System.setProperty("org.apache.tools.ant.ProjectHelper", "ise.antelope.common.AntelopeProjectHelper2");
    }

    public void executeDefaultTarget() {
        if (this._default_btn != null) {
            this.executeTarget(this._default_btn.getActionCommand());
        }
    }

    public void executeLastRanTargets() {
        if (this._last_ran_targets != null) {
            if (this._unnamed_target != null) {
                this._last_ran_targets.remove(this._unnamed_target.getName());
            }
            Iterator iterator = this._last_ran_targets.iterator();
            while (iterator.hasNext()) {
                this.executeTarget((String)iterator.next());
            }
        }
    }

    private void saveBeforeRun() {
        if (this._helper != null && this._settings.getSaveBeforeRun()) {
            this._helper.saveBeforeRun();
        }
    }

    private void clearErrorSource() {
        if (this._helper != null) {
            this._helper.clearErrorSource();
        }
    }

    public ActionListener getOpenActionListener() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser;
                int n;
                if (AntelopePanel.this._last_directory == null && AntelopePanel.this._build_file != null) {
                    AntelopePanel.this._last_directory = AntelopePanel.this._build_file.getParentFile();
                }
                if ((n = (jFileChooser = AntelopePanel.this._last_directory == null ? new JFileChooser() : new JFileChooser(AntelopePanel.this._last_directory)).showOpenDialog(AntelopePanel.this)) == 1) {
                    return;
                }
                AntelopePanel.this._build_file = jFileChooser.getSelectedFile();
                if (AntelopePanel.this._build_file != null) {
                    AntelopePanel.this._last_directory = AntelopePanel.this._build_file.getParentFile();
                    AntelopePanel.this.openBuildFile(AntelopePanel.this._build_file);
                }
            }
        };
        return actionListener;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(File file) {
        if (this._listeners == null) {
            return;
        }
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, file.getAbsolutePath());
            Iterator iterator = this._listeners.iterator();
            while (iterator.hasNext()) {
                ActionListener actionListener = (ActionListener)iterator.next();
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public File getBuildFile() {
        return this._build_file;
    }

    public void reload() {
        if (this._build_file != null) {
            this.openBuildFile(this._build_file);
        }
    }

    private void loadPropertyFiles() {
        if (this._sax_panel != null) {
            this._property_files = this._sax_panel.getModel().getPropertyFiles();
            if (this._property_files == null) {
                return;
            }
            HashMap<File, Object> hashMap = new HashMap<File, Object>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator<Object> iterator = this._property_files.keySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                Object k = iterator.next();
                if (k == null) continue;
                File file = null;
                if (k instanceof File) {
                    file = (File)k;
                    object = (Long)this._property_files.get(file);
                    hashMap.put(file, object);
                    continue;
                }
                if (this._project == null) continue;
                object = k.toString();
                String string = object;
                if (((String)object).startsWith("${") && ((String)object).endsWith("}")) {
                    string = string.substring(2, string.length() - 1);
                }
                if ((string = this._project.getProperty(string)) != null) {
                    file = new File(string);
                }
                if (file != null && !file.exists()) {
                    file = new File(this._project.getBaseDir(), string);
                }
                if (file == null || !file.exists()) continue;
                hashMap.put(file, new Long(file.lastModified()));
                arrayList.add(object);
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                hashMap.remove(iterator.next());
            }
            this._property_files = hashMap;
        }
    }

    public boolean shouldReload() {
        if (this._property_files == null) {
            return false;
        }
        Iterator iterator = this._property_files.keySet().iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            Long l = (Long)this._property_files.get(file);
            if (l == null || l.longValue() == file.lastModified()) continue;
            return true;
        }
        return false;
    }

    public void openBuildFile(String string) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        this.openBuildFile(file);
    }

    public void openBuildFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        boolean bl = !file.equals(this._build_file);
        this._build_file = file;
        try {
            KappaLayout.Constraints constraints = KappaLayout.createConstraint();
            constraints.s = "w";
            constraints.p = 1;
            if (this._center_panel == null) {
                this._center_panel = new DeckPanel();
                this.add((Component)this._center_panel, "Center");
            } else {
                this._center_panel.removeAll();
            }
            if (this._button_panel == null) {
                this._button_panel = new JPanel(new KappaLayout());
                this._button_panel.setBackground(Color.white);
                this._button_panel.setBorder(new EmptyBorder(3, 3, 3, 3));
                this._scroller = new JScrollPane(this._button_panel);
                this._scroller.getVerticalScrollBar().setUnitIncrement(50);
                this._btn_container = new JPanel(new BorderLayout());
                this._btn_container.add((Component)this._scroller, "Center");
                JPanel jPanel = new JPanel();
                this._btn_container.add((Component)this._multi, "South");
            } else {
                this._button_panel.removeAll();
                this._button_panel.setLayout(new KappaLayout());
            }
            this._center_panel.add("panel", this._btn_container);
            if (this._sax_panel == null) {
                this._sax_panel = new SAXPanel(this._helper);
            }
            boolean bl2 = this._sax_panel.openBuildFile(this._build_file);
            this._center_panel.add("tree", this._sax_panel);
            if (bl2) {
                if (this._edit_btn.isSelected()) {
                    this._center_panel.last();
                } else {
                    this._center_panel.first();
                }
                this._run_btn.setEnabled(true);
                this._trace_btn.setEnabled(true);
                this._edit_btn.setEnabled(true);
                this._props_btn.setEnabled(true);
                this._options_btn.setEnabled(true);
            } else {
                this._center_panel.last();
                this._run_btn.setEnabled(false);
                this._trace_btn.setEnabled(false);
                this._props_btn.setEnabled(false);
                this._options_btn.setEnabled(false);
            }
            try {
                Constants.PREFS.put("lastOpenFile", file.getAbsolutePath());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.adjustRecentFiles(file);
            this.adjustRecentFilesMenu();
            this.saveConfigurationSettings();
            if (bl2) {
                try {
                    Object object;
                    Object object2;
                    String string;
                    Object object3;
                    this._project = this.createProject(this._build_file);
                    this.loadPropertyFiles();
                    Object var5_8 = null;
                    if (bl) {
                        this._multi.setSelected(this._settings.getMultipleTargets());
                    }
                    if (this._multi.isSelected()) {
                        object3 = new JButton("Execute");
                        this._button_panel.add((Component)object3, constraints);
                        ((AbstractButton)object3).addActionListener(this._execute_listener);
                        ++constraints.y;
                    }
                    if ((object3 = this._project.getProperty("ant.project.name")) == null || ((String)object3).equals("")) {
                        object3 = "<unnamed project>";
                    }
                    this._project_name.setText((String)object3);
                    Hashtable hashtable = this._project.getTargets();
                    if (hashtable == null || hashtable.size() == 0) {
                        return;
                    }
                    Object object4 = hashtable.keySet().iterator();
                    while (object4.hasNext()) {
                        Log.log("target in targets: " + object4.next());
                    }
                    this._unnamed_target = null;
                    Log.log("+++++ AntUtils.getAntVersion: " + AntUtils.getAntVersion());
                    if (AntUtils.getAntVersion() >= 1.6) {
                        object4 = hashtable.keySet().iterator();
                        while (object4.hasNext()) {
                            if (!object4.next().toString().equals("")) continue;
                            this._unnamed_target = (Target)hashtable.get("");
                        }
                    }
                    this._targets = this._settings.getSortTargets() ? new TreeMap(Collator.getInstance()) : new LinkedHashMap();
                    object4 = this._sax_panel.getTargets();
                    Iterator<Object> iterator = object4.keySet().iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        if (string == null || string.equals("")) continue;
                        object2 = (Target)hashtable.get(string);
                        if (object2 == null) {
                            object = (SAXTreeNode)object4.get(string);
                            if (((SAXTreeNode)object).isImported()) {
                                string = ((SAXTreeNode)object).getAttributeValue("name");
                                object2 = (Target)hashtable.get(string);
                            }
                            if (object2 == null) continue;
                        }
                        object = object2.getDescription();
                        if (this._settings.getShowAllTargets()) {
                            this._targets.put(string, object2);
                            continue;
                        }
                        if (string.indexOf(".") > 0 && this._settings.getShowTargetsWDot()) {
                            this._targets.put(string, object2);
                            continue;
                        }
                        if (string.indexOf(".") > 0 && !this._settings.getShowTargetsWDot()) continue;
                        if (string.startsWith("-") && this._settings.getShowTargetsWDash()) {
                            this._targets.put(string, object2);
                            continue;
                        }
                        if (string.startsWith("-") && !this._settings.getShowTargetsWDash()) continue;
                        if ((object == null || ((String)object).equals("")) && this._settings.getShowTargetsWODesc()) {
                            this._targets.put(string, object2);
                            continue;
                        }
                        if ((object == null || ((String)object).equals("")) && !this._settings.getShowTargetsWODesc() || string.indexOf(".") != -1 || object == null) continue;
                        this._targets.put(string, object2);
                    }
                    if (this._unnamed_target != null) {
                        this._targets.put(this.IMPLICIT_TARGET_NAME, this._unnamed_target);
                    }
                    this._buttons = new ArrayList();
                    this._execute_targets = new ArrayList();
                    iterator = this._targets.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object object5;
                        AbstractButton abstractButton;
                        Object object6;
                        string = (String)iterator.next();
                        object2 = (Target)this._targets.get(string);
                        if (object2 == null) continue;
                        object = object2.getDescription();
                        if (object == null) {
                            object = string;
                        }
                        if (this._multi.isSelected()) {
                            if (string.equals(this.IMPLICIT_TARGET_NAME)) continue;
                            object6 = (SAXTreeNode)object4.get(string);
                            abstractButton = new JCheckBox();
                            object5 = "<html>";
                            if (object6 == null) {
                                object5 = (String)object5 + "<i>";
                            } else {
                                if (((SAXTreeNode)object6).isPrivate()) {
                                    object5 = (String)object5 + "<i>";
                                }
                                if (((SAXTreeNode)object6).isDefaultTarget()) {
                                    abstractButton.setForeground(this.GREEN);
                                }
                            }
                            object5 = (String)object5 + string;
                            abstractButton.setText((String)object5);
                            abstractButton.addActionListener(this._cb_listener);
                            abstractButton.setBackground(this._button_panel.getBackground());
                            if (((SAXTreeNode)object6).isDefaultTarget()) {
                                this._default_btn = abstractButton;
                            }
                        } else {
                            object6 = "<html>";
                            object5 = (SAXTreeNode)object4.get(string);
                            abstractButton = new JButton();
                            if (object5 == null) {
                                object6 = (String)object6 + (this.isPrivate((Target)object2) ? "<i>" : "");
                            } else {
                                if (((SAXTreeNode)object5).isPrivate()) {
                                    object6 = (String)object6 + "<i>";
                                }
                                if (((SAXTreeNode)object5).isDefaultTarget()) {
                                    abstractButton.setForeground(this.GREEN);
                                }
                            }
                            object6 = (String)object6 + string;
                            abstractButton.setText((String)object6);
                            abstractButton.addActionListener(this._button_listener);
                            if (object5 != null && ((SAXTreeNode)object5).isDefaultTarget()) {
                                this._default_btn = abstractButton;
                            }
                        }
                        abstractButton.setActionCommand(string);
                        abstractButton.setToolTipText((String)object);
                        this._button_panel.add((Component)abstractButton, constraints);
                        this._buttons.add(abstractButton);
                        ++constraints.y;
                    }
                    if (bl && this._multi.isSelected()) {
                        iterator = this._settings.getMultipleTargetList().iterator();
                        while (iterator.hasNext()) {
                            string = (String)iterator.next();
                            object2 = this._buttons.iterator();
                            while (object2.hasNext()) {
                                object = (AbstractButton)object2.next();
                                if (!((AbstractButton)object).getActionCommand().equals(string)) continue;
                                ((AbstractButton)object).doClick();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AntelopePanel.this._button_panel.validate();
                    AntelopePanel.this.validate();
                    AntelopePanel.this.repaint();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fireEvent(this._build_file);
    }

    public Project createProject(File file) throws Exception {
        if (file == null || !file.exists()) {
            return null;
        }
        this.setPrefs(file);
        Project project = new Project();
        System.setProperty("org.apache.tools.ant.ProjectHelper", "ise.antelope.common.AntelopeProjectHelper2");
        try {
            Object object;
            Object object2;
            List list;
            String string;
            ClassLoader classLoader = this._helper.getAntClassLoader();
            project.setCoreLoader(classLoader);
            project.addBuildListener((BuildListener)this._build_logger);
            project.addBuildListener((BuildListener)this._progress);
            if (this._settings.getShowPerformanceOutput()) {
                if (this._performance_listener == null) {
                    this._performance_listener = new AntPerformanceListener();
                }
                project.addBuildListener((BuildListener)this._performance_listener);
            }
            this.setInputHandler(project, "ise.antelope.common.AntInputHandler");
            project.init();
            project.setUserProperty("ant.file", file.getAbsolutePath());
            project.setProperty("ant.version", Main.getAntVersion());
            String string2 = AntUtils.getAntHome();
            if (string2 != null) {
                project.setProperty("ant.home", string2);
            }
            if ((string = AntUtils.getAntLibDirs()) != null) {
                project.setProperty("ant.library.dir", string);
            }
            if ((list = this._helper.getAntJarList()) != null) {
                Comparable<StringBuffer> comparable;
                object2 = new ArrayList();
                object = project.getProperty("java.class.path");
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    object2.add(new File(stringTokenizer.nextToken()));
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    comparable = new File((String)iterator.next());
                    if (object2.contains(comparable)) continue;
                    object2.add(comparable);
                }
                comparable = new StringBuffer();
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    ((StringBuffer)comparable).append(((File)iterator.next()).getAbsolutePath()).append(File.pathSeparator);
                }
                object = ((StringBuffer)comparable).toString();
                project.setProperty("java.class.path", (String)object);
                System.setProperty("java.class.path", (String)object);
            }
            object2 = this.getPrefs().node("ant_user_props");
            object = ((Preferences)object2).keys();
            for (int i = 0; i < ((String[])object).length; ++i) {
                project.setUserProperty(object[i], ((Preferences)object2).get(object[i], ""));
            }
            ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
            project.addReference("ant.projectHelper", (Object)projectHelper);
            projectHelper.parse(project, (Object)file);
            return project;
        }
        catch (Exception exception) {
            Log.log(exception);
            exception.printStackTrace(System.out);
            JOptionPane.showMessageDialog(GUIUtils.getRootJFrame(this), "<html>Error:<br>" + exception.getMessage(), "Ant Error", 0);
            throw exception;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Log.log(noClassDefFoundError);
            noClassDefFoundError.printStackTrace(System.out);
            JOptionPane.showMessageDialog(GUIUtils.getRootJFrame(this), "<html>Error: No Class Definition Found for<br>" + noClassDefFoundError.getMessage() + "<br><p>This is most likely caused by a required third-party<br>" + "jar file not being in the class path.", "Ant Error", 0);
            throw new Exception(noClassDefFoundError.getMessage());
        }
    }

    private void setInputHandler(Project project, String string) {
        try {
            AntInputHandler antInputHandler = new AntInputHandler(this);
            PrivilegedAccessor.invokeMethod((Object)project, "setInputHandler", new Object[]{antInputHandler});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Project getAntProject() {
        return this._project;
    }

    public void showProperties() {
        if (this._project != null) {
            AntelopeProperties antelopeProperties = new AntelopeProperties(this);
            antelopeProperties.showProperties(this._project);
        }
    }

    private boolean isPrivate(Target target) {
        if (target == null) {
            return true;
        }
        String string = target.getName();
        if (string.indexOf(".") > 0) {
            return true;
        }
        if (string.startsWith("-")) {
            return true;
        }
        String string2 = target.getDescription();
        return string2 == null || string2.equals("");
    }

    private void setPrefs(File file) {
        if (this._settings != null) {
            this._settings.load(file);
        } else {
            this._settings = new OptionSettings(file);
        }
        this._prefs = this._settings.getPrefs();
    }

    public Preferences getPrefs() {
        return this._prefs;
    }

    public void setUseInternalMenu(boolean bl) {
        this._use_internal_menu = bl;
    }

    public boolean useInternalMenu() {
        return this._use_internal_menu;
    }

    public JMenu getRecentFilesMenu() {
        JMenu jMenu = new JMenu("Recent Files");
        String string = "";
        try {
            string = Constants.PREFS.get("recent_list", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                String string = jMenuItem.getText();
                File file = new File(string);
                AntelopePanel.this.openBuildFile(file);
            }
        };
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            JMenuItem jMenuItem = new JMenuItem(stringTokenizer.nextToken());
            jMenuItem.addActionListener(actionListener);
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public ArrayList getRecentFilesList() {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        String string = "";
        try {
            string = Constants.PREFS.get("recent_list", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            JMenuItem jMenuItem = new JMenuItem(string2);
            jMenuItem.addActionListener(new MenuItemListener(this, string2));
            arrayList.add(jMenuItem);
        }
        return arrayList;
    }

    private void adjustRecentFilesMenu() {
        this._recent.removeAll();
        ArrayList arrayList = this.getRecentFilesList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this._recent.add((JMenuItem)iterator.next());
        }
    }

    private void adjustRecentFiles(File file) {
        String string = "";
        try {
            string = Constants.PREFS.get("recent_list", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string.startsWith(file.getAbsolutePath())) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String string2 = file.getAbsolutePath();
        if (arrayList.contains(string2)) {
            arrayList.remove(string2);
        }
        arrayList.add(0, string2);
        if (arrayList.size() > 10) {
            arrayList = new ArrayList(arrayList.subList(0, 10));
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append(File.pathSeparator);
        }
        try {
            Constants.PREFS.put("recent_list", stringBuffer.toString());
            Constants.PREFS.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._helper.actionPerformed(new ActionEvent(this, 810217, file.getAbsolutePath()));
    }

    private void saveConfigurationSettings() {
        this._settings.setMultipleTargets(this._multi.isSelected());
        if (this._buttons != null && this._multi.isSelected()) {
            Serializable serializable;
            TreeSet<Serializable> treeSet = new TreeSet<Serializable>(new Comparator(){

                public int compare(Object object, Object object2) {
                    int n;
                    AbstractButton abstractButton = (AbstractButton)object;
                    AbstractButton abstractButton2 = (AbstractButton)object2;
                    String string = abstractButton.getText();
                    String string2 = abstractButton2.getText();
                    string = string.substring(0, string.length() - 1);
                    string = string.substring(string.lastIndexOf("(") + 1);
                    string2 = string2.substring(0, string2.length() - 1);
                    string2 = string2.substring(string2.lastIndexOf("(") + 1);
                    int n2 = Integer.parseInt(string);
                    if (n2 < (n = Integer.parseInt(string2))) {
                        return -1;
                    }
                    if (n2 == n) {
                        return 0;
                    }
                    return 1;
                }
            });
            Iterator iterator = this._buttons.iterator();
            while (iterator.hasNext()) {
                serializable = (AbstractButton)iterator.next();
                if (!((AbstractButton)serializable).isSelected()) continue;
                treeSet.add(serializable);
            }
            iterator = treeSet.iterator();
            serializable = new ArrayList();
            while (iterator.hasNext()) {
                String string = ((AbstractButton)iterator.next()).getActionCommand();
                ((ArrayList)serializable).add(string);
            }
            this._settings.setMultipleTargetList((ArrayList)serializable);
        }
        if (this._prefs != null) {
            try {
                this._prefs.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected Component getOptionsPanel() {
        return this._options;
    }

    public void setOptionsPanel(AntelopeOptions antelopeOptions) {
        this._options = antelopeOptions;
    }

    public boolean getUseErrorParsing() {
        return this._settings.getUseErrorParsing();
    }

    public void showButtonText(boolean bl) {
        if (bl) {
            this._run_btn.setText("Run");
            this._trace_btn.setText("Trace");
            this._edit_btn.setText("Edit");
            this._props_btn.setText("Properties");
            this._options_btn.setText("Options");
            this._reload_btn.setText("Reload");
        } else {
            this._run_btn.setText("");
            this._trace_btn.setText("");
            this._edit_btn.setText("");
            this._props_btn.setText("");
            this._options_btn.setText("");
            this._reload_btn.setText("");
        }
    }

    public boolean getShowButtonText() {
        return this._settings.getShowButtonText();
    }

    public void showButtonIcon(boolean bl) {
        if (bl) {
            URL uRL = this.getClass().getClassLoader().getResource("images/Play16.gif");
            ImageIcon imageIcon = null;
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
            this._run_btn.setIcon(imageIcon);
            uRL = this.getClass().getClassLoader().getResource("images/Zoom16.gif");
            imageIcon = null;
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
            this._trace_btn.setIcon(imageIcon);
            uRL = this.getClass().getClassLoader().getResource("images/Edit16.gif");
            imageIcon = null;
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
            this._edit_btn.setIcon(imageIcon);
            uRL = this.getClass().getClassLoader().getResource("images/Information16.gif");
            imageIcon = null;
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
            this._props_btn.setIcon(imageIcon);
            uRL = this.getClass().getClassLoader().getResource("images/Properties16.gif");
            imageIcon = null;
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
            this._options_btn.setIcon(imageIcon);
            uRL = this.getClass().getClassLoader().getResource("images/Refresh16.gif");
            imageIcon = null;
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
            this._reload_btn.setIcon(imageIcon);
        } else {
            this._run_btn.setIcon(null);
            this._trace_btn.setIcon(null);
            this._edit_btn.setIcon(null);
            this._props_btn.setIcon(null);
            this._options_btn.setIcon(null);
            this._reload_btn.setIcon(null);
        }
    }

    public boolean getShowButtonIcon() {
        return this._settings.getShowButtonIcon();
    }

    private void initLogger() {
        this._logger = Logger.getLogger("ise.antelope.Antelope");
        this._logger.setUseParentHandlers(false);
        this._build_logger = new AntLogger();
        Handler[] handlerArray = this._logger.getHandlers();
        try {
            for (int i = 0; i < handlerArray.length; ++i) {
                Handler handler = handlerArray[i];
                if (!(handler instanceof ConsoleHandler)) continue;
                this._logger.removeHandler(handler);
            }
        }
        catch (Throwable throwable) {
            Log.log((Object)this, throwable);
        }
        this._logger.setLevel(Level.ALL);
    }

    public void setLogLevel(Level level) {
        this._log_level = level;
    }

    public void addLogHandler(Handler handler) {
        if (handler == null) {
            return;
        }
        if (this._logger == null) {
            this.initLogger();
        }
        handler.setLevel(this._log_level);
        this._logger.removeHandler(handler);
        this._logger.addHandler(handler);
    }

    public void removeLogHandler(Handler handler) {
        if (this._logger == null) {
            return;
        }
        this._logger.removeHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllLogHandlers() {
        if (this._logger == null) {
            return;
        }
        Logger logger = this._logger;
        synchronized (logger) {
            Handler[] handlerArray = this._logger.getHandlers();
            for (int i = 0; i < handlerArray.length; ++i) {
                this._logger.removeHandler(handlerArray[i]);
            }
        }
    }

    private void log(String string) {
        this.log(Level.INFO, string);
    }

    private void log(Level level, String string) {
        this._logger.log(level, string);
    }

    public void close() {
        this.saveConfigurationSettings();
        this.removeAllLogHandlers();
        try {
            Constants.PREFS.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

