/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Find
extends Task {
    private String findIn = null;
    private String regex = null;
    private String property = null;
    private int group = 0;
    private boolean dotall = false;
    private boolean caseInsensitive = false;
    private boolean multiLine = false;
    private boolean unicodeCase = false;
    private boolean canonEq = false;
    private boolean comments = false;
    private boolean unixLines = false;
    private boolean allMatches = false;
    private String separator = System.getProperty("line.separator");

    public void setIn(String string) {
        this.findIn = string;
    }

    public void setRegex(String string) {
        this.regex = string;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setGroup(int n) {
        this.group = n;
    }

    public void setDotall(boolean bl) {
        this.dotall = bl;
    }

    public void setCaseinsensitive(boolean bl) {
        this.caseInsensitive = bl;
    }

    public void setMultiline(boolean bl) {
        this.multiLine = bl;
    }

    public void setUnicodecase(boolean bl) {
        this.unicodeCase = bl;
    }

    public void setCanoneq(boolean bl) {
        this.canonEq = bl;
    }

    public void setComments(boolean bl) {
        this.comments = bl;
    }

    public void setUnixlines(boolean bl) {
        this.unixLines = bl;
    }

    public void setAllmatches(boolean bl) {
        this.allMatches = bl;
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public void execute() {
        if (this.findIn == null) {
            throw new BuildException("'in' is required");
        }
        if (this.regex == null) {
            throw new BuildException("'regex' is required");
        }
        if (this.property == null) {
            throw new BuildException("'property' is required");
        }
        int n = 0;
        if (this.dotall) {
            n += 32;
        }
        if (this.caseInsensitive) {
            n += 2;
        }
        if (this.multiLine) {
            n += 8;
        }
        if (this.unicodeCase) {
            n += 64;
        }
        if (this.canonEq) {
            n += 128;
        }
        if (this.comments) {
            n += 4;
        }
        if (this.unixLines) {
            ++n;
        }
        try {
            String string;
            Pattern pattern = Pattern.compile(this.regex, n);
            Matcher matcher = pattern.matcher(this.findIn);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            if (this.allMatches) {
                while (matcher.find()) {
                    String string2 = matcher.group(this.group);
                    if (string2 == null) continue;
                    stringBuffer.append(string2).append(this.separator);
                    ++n2;
                }
            } else if (matcher.find() && (string = matcher.group(this.group)) != null) {
                stringBuffer.append(string);
            }
            if (stringBuffer.length() > 0) {
                this.getProject().setUserProperty(this.property, stringBuffer.toString());
                if (this.allMatches) {
                    this.getProject().setUserProperty(this.property + "_count", String.valueOf(n2));
                }
            } else {
                this.log("No match.");
            }
        }
        catch (Exception exception) {
            throw new BuildException(exception.getMessage());
        }
    }
}

