/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Grep {
    private String findIn = null;
    private String regex = null;
    private int group = 0;
    private boolean dotall = false;
    private boolean caseInsensitive = false;
    private boolean multiLine = false;
    private boolean unicodeCase = false;
    private boolean canonEq = false;
    private boolean comments = false;
    private boolean unixLines = false;
    private boolean allMatches = false;
    private String separator = System.getProperty("line.separator");
    private String grep_match = null;
    private int count = 0;
    private List matches = new ArrayList();

    public void setIn(String string) {
        this.findIn = string;
    }

    public void setRegex(String string) {
        this.regex = string;
    }

    public void setGroup(int n) {
        this.group = n;
    }

    public void setDotall(boolean bl) {
        this.dotall = bl;
    }

    public void setCaseinsensitive(boolean bl) {
        this.caseInsensitive = bl;
    }

    public void setMultiline(boolean bl) {
        this.multiLine = bl;
    }

    public void setUnicodecase(boolean bl) {
        this.unicodeCase = bl;
    }

    public void setCanoneq(boolean bl) {
        this.canonEq = bl;
    }

    public void setComments(boolean bl) {
        this.comments = bl;
    }

    public void setUnixlines(boolean bl) {
        this.unixLines = bl;
    }

    public void setAllmatches(boolean bl) {
        this.allMatches = bl;
    }

    public int getCount() {
        return this.matches.size();
    }

    public String getMatch() {
        return this.grep_match;
    }

    public Iterator getMatches() {
        return this.matches.iterator();
    }

    public String getMatch(int n) {
        return n < 0 || n >= this.matches.size() ? null : (String)this.matches.get(n);
    }

    public void setSeparator(String string) {
        this.separator = string;
    }

    public String grep() {
        if (this.findIn == null) {
            throw new IllegalArgumentException("'in' is required");
        }
        if (this.regex == null) {
            throw new IllegalArgumentException("'regex' is required");
        }
        int n = 0;
        if (this.dotall) {
            n += 32;
        }
        if (this.caseInsensitive) {
            n += 2;
        }
        if (this.multiLine) {
            n += 8;
        }
        if (this.unicodeCase) {
            n += 64;
        }
        if (this.canonEq) {
            n += 128;
        }
        if (this.comments) {
            n += 4;
        }
        if (this.unixLines) {
            ++n;
        }
        try {
            String string;
            Pattern pattern = Pattern.compile(this.regex, n);
            Matcher matcher = pattern.matcher(this.findIn);
            StringBuffer stringBuffer = new StringBuffer();
            this.matches = new ArrayList();
            if (this.allMatches) {
                while (matcher.find()) {
                    String string2 = matcher.group(this.group);
                    if (string2 == null) continue;
                    stringBuffer.append(string2).append(this.separator);
                    this.matches.add(string2);
                }
            } else if (matcher.find() && (string = matcher.group(this.group)) != null) {
                stringBuffer.append(string);
                this.matches.add(string);
            }
            this.grep_match = stringBuffer.length() > 0 ? stringBuffer.toString() : null;
            return this.grep_match;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }
}

