/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.BooleanConditionTask;
import ise.antelope.tasks.Break;
import ise.antelope.tasks.Breakable;
import ise.antelope.tasks.ElseTask;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class IfTask
extends Task
implements TaskContainer,
Breakable {
    private boolean exists = true;
    private String value = null;
    private String name = null;
    private Task else_task = null;
    private Task condition_task = null;
    private Vector tasks = new Vector();
    private boolean doBreak = false;

    public void init() {
        this.getProject().addTaskDefinition("else", ElseTask.class);
        this.getProject().addTaskDefinition("bool", BooleanConditionTask.class);
        this.getProject().addTaskDefinition("break", Break.class);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setExists(String string) {
        this.getProject();
        this.exists = Project.toBoolean((String)string);
    }

    public void setBreak(boolean bl) {
        this.doBreak = bl;
    }

    public void addBreak(Break break_) {
        this.addTask(break_);
    }

    public void addElse(ElseTask elseTask) {
        this.addTask(elseTask);
    }

    public void addBool(BooleanConditionTask booleanConditionTask) {
        this.addTask((Task)booleanConditionTask);
    }

    public boolean doBreak() {
        return this.doBreak;
    }

    public void maybeConfigure() throws BuildException {
        if (this.isInvalid()) {
            super.maybeConfigure();
        } else {
            this.getRuntimeConfigurableWrapper().maybeConfigure(this.getProject(), false);
        }
    }

    public void addTask(Task task) {
        if (task instanceof ElseTask) {
            if (this.else_task == null) {
                this.else_task = task;
                return;
            }
            throw new BuildException("Only one <else> allowed per If.");
        }
        if (task instanceof BooleanConditionTask) {
            if (this.condition_task == null) {
                this.condition_task = task;
                return;
            }
            throw new BuildException("Only one <bool> allowed per If.");
        }
        this.tasks.addElement(task);
    }

    public void execute() throws BuildException {
        if (this.condition_task == null) {
            if (this.name == null || this.name.equals("")) {
                throw new BuildException("The 'name' attribute is required.");
            }
            String string = this.getProject().getProperty(this.name);
            if (this.exists && string == null) {
                this.doElse();
                return;
            }
            if (!this.exists && string != null) {
                this.doElse();
                return;
            }
            if (this.value != null) {
                if (string == null) {
                    this.doElse();
                    return;
                }
                if (string != null && !string.equals(this.value)) {
                    this.doElse();
                    return;
                }
            }
            this.doIf();
        } else if (((BooleanConditionTask)this.condition_task).eval()) {
            this.doIf();
        } else {
            this.doElse();
        }
    }

    private void doIf() throws BuildException {
        Enumeration enumeration = this.tasks.elements();
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            if (task instanceof Breakable) {
                task.perform();
                if (!((Breakable)task).doBreak()) continue;
                this.setBreak(true);
                return;
            }
            task.perform();
        }
    }

    private void doElse() throws BuildException {
        if (this.else_task == null) {
            return;
        }
        this.else_task.perform();
    }
}

