/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.password.PasswordHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PasswordHandlerTask
extends Task {
    private String in = null;
    private String out = null;
    private String mode = null;
    private String seed = null;

    public void setIn(String string) {
        this.in = string;
    }

    public void setOut(String string) {
        this.out = string;
    }

    public void setMode(String string) {
        if (string == null || !string.equals("encrypt") && !string.equals("decrypt")) {
            throw new BuildException("Invalid mode, must be either 'encrypt' or 'decrypt'");
        }
        this.mode = string;
    }

    public void setSeed(String string) {
        this.seed = string;
    }

    public void execute() {
        if (this.in == null) {
            throw new BuildException("'in' is required");
        }
        if (this.out == null) {
            throw new BuildException("'out' is required");
        }
        if (this.mode == null) {
            this.mode = "decrypt";
        }
        try {
            PasswordHandler passwordHandler = null;
            passwordHandler = this.seed != null ? new PasswordHandler(this.seed) : new PasswordHandler();
            String string = "";
            if (this.mode.equals("encrypt")) {
                string = passwordHandler.encrypt(this.in);
            } else if (this.mode.equals("decrypt")) {
                string = passwordHandler.decrypt(this.in);
            } else {
                throw new BuildException("Invalid mode, must be either 'encrypt' or 'decrypt'");
            }
            this.getProject().setUserProperty(this.out, string);
        }
        catch (Exception exception) {
            throw new BuildException(exception.getMessage());
        }
    }
}

