/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SplitTask
extends Task {
    private String prefix = "x";
    private int bytes = -1;
    private int lines = 1000;
    private String value = null;
    private File file = null;
    private File outputDir = null;
    private boolean failOnError = true;

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setBytes(int n) {
        this.bytes = n;
        this.lines = -1;
    }

    public void setSize(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        string = string.toLowerCase();
        String string2 = string.substring(string.length() - 1);
        int n = 1;
        string = string.substring(0, string.length() - 1);
        if (string2.equals("b")) {
            n = 512;
        } else if (string2.equals("k")) {
            n = 1024;
        } else if (string2.equals("m")) {
            n = 0x100000;
        } else {
            string = string + string2;
        }
        try {
            int n2 = Integer.parseInt(string) * n;
            this.setBytes(n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("Invalid size parameter.");
        }
    }

    public void setLines(int n) {
        this.lines = n;
        this.bytes = -1;
    }

    public void setProperty(String string) {
        String string2 = this.getProject().getProperty(string);
        if (string2 == null || string2.equals("")) {
            throw new BuildException("Property " + string + " has no value.");
        }
        this.setValue(string2);
    }

    public void setValue(String string) {
        if (string == null || string.equals("")) {
            throw new BuildException("Value is null or empty.");
        }
        this.value = string;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setOutputdir(File file) {
        this.outputDir = file;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void execute() throws BuildException {
        if (this.value == null && this.file == null) {
            throw new BuildException("Must have property, value, or file.");
        }
        if (this.file == null && this.outputDir == null) {
            throw new BuildException("Must have output directory.");
        }
        if (this.value != null && this.file != null) {
            throw new BuildException("Must not have more than one of property, value, or file.");
        }
        try {
            if (this.value != null) {
                this.splitValue();
            } else {
                this.splitFile();
            }
        }
        catch (Exception exception) {
            if (this.failOnError) {
                throw new BuildException(exception.getMessage());
            }
            this.log(exception.getMessage());
        }
    }

    private void splitValue() throws Exception {
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IOException("Unable to create output directory.");
        }
        StringReader stringReader = new StringReader(this.value);
        int n = 0;
        int n2 = 0;
        if (this.bytes > 0) {
            char[] cArray = new char[this.bytes];
            while (n > -1 && (n = stringReader.read(cArray, 0, this.bytes)) != -1) {
                FileWriter fileWriter = new FileWriter(new File(this.outputDir, this.prefix + "." + String.valueOf(n2)));
                fileWriter.write(cArray, 0, n);
                fileWriter.flush();
                fileWriter.close();
                ++n2;
            }
        } else {
            this.splitByLines(stringReader);
        }
    }

    private void splitFile() throws IOException {
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.toString());
        }
        if (this.file.length() == 0L) {
            throw new BuildException("Zero length file.");
        }
        if (this.outputDir == null) {
            this.outputDir = this.file.getParentFile();
        }
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IOException("Unable to create output directory.");
        }
        int n = 0;
        if (this.bytes > 0) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
            int n2 = 0;
            byte[] byArray = new byte[this.bytes];
            while (n2 > -1 && (n2 = bufferedInputStream.read(byArray, 0, this.bytes)) != -1) {
                FileOutputStream fileOutputStream = new FileOutputStream(new File(this.outputDir, this.prefix + "." + String.valueOf(n)));
                fileOutputStream.write(byArray, 0, n2);
                fileOutputStream.flush();
                fileOutputStream.close();
                ++n;
            }
        } else {
            this.splitByLines(new FileReader(this.file));
        }
    }

    private void splitByLines(Reader reader) throws IOException {
        int n = 0;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        String string = lineNumberReader.readLine();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(this.outputDir, this.prefix + "." + String.valueOf(n))));
        while (string != null) {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            if (lineNumberReader.getLineNumber() % this.lines == 0) {
                bufferedWriter.flush();
                bufferedWriter.close();
                bufferedWriter = new BufferedWriter(new FileWriter(new File(this.outputDir, this.prefix + "." + String.valueOf(++n))));
            }
            string = lineNumberReader.readLine();
        }
        bufferedWriter.flush();
        bufferedWriter.close();
    }
}

