/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.AssertException;
import ise.antelope.tasks.TestStatisticAccumulator;
import ise.library.ascii.MessageBox;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class TestCase
extends Task
implements TestStatisticAccumulator {
    private boolean enabled = true;
    private boolean assertEnabled = true;
    private Target setUp = null;
    private Target tearDown = null;
    private Vector testTargets = new Vector();
    private Vector failures = new Vector();
    private boolean failOnError = false;
    private boolean showSummary = true;
    private boolean showOutput = true;
    private File testFile = null;
    private String test_name = "";
    private int tests_passed = 0;
    private int tests_failed = 0;
    private int tests_warning = 0;

    public void init() {
        super.init();
        this.setTaskName("testcase");
    }

    public int getTestCaseCount() {
        return this.testTargets.size();
    }

    public int getRanCount() {
        return this.tests_passed + this.tests_warning + this.tests_failed;
    }

    public int getFailedCount() {
        return this.tests_failed;
    }

    public int getWarningCount() {
        return this.tests_warning;
    }

    public int getPassedCount() {
        return this.tests_passed;
    }

    public Enumeration getFailures() {
        return this.failures.elements();
    }

    public void setShowoutput(boolean bl) {
        this.showOutput = bl;
    }

    public void setShowsummary(boolean bl) {
        this.showSummary = bl;
    }

    public void setFile(File file) {
        this.testFile = file;
    }

    public void setAssertsenabled(boolean bl) {
        this.assertEnabled = bl;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public String getName() {
        return this.test_name;
    }

    public void setName(String string) {
        this.test_name = string;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        CharSequence charSequence;
        String string;
        if (!this.enabled) {
            return;
        }
        if (this.testFile == null) {
            throw ProjectHelper.addLocationToBuildException((BuildException)new BuildException("missing file for testcase"), (Location)this.getLocation());
        }
        if (!this.testFile.exists()) {
            throw ProjectHelper.addLocationToBuildException((BuildException)new BuildException("file not found for testcase: " + this.testFile), (Location)this.getLocation());
        }
        String string2 = string = this.assertEnabled ? "true" : "false";
        if (this.assertEnabled) {
            this.getProject().setProperty("ant.enable.asserts", string);
        }
        Project project = new Project();
        this.initializeProject(project);
        try {
            ProjectHelper.configureProject((Project)project, (File)this.testFile);
        }
        catch (BuildException buildException) {
            throw ProjectHelper.addLocationToBuildException((BuildException)buildException, (Location)this.getLocation());
        }
        if (this.test_name == null || this.test_name.equals("")) {
            this.test_name = project.getName();
        }
        if (this.test_name == null || this.test_name.equals("")) {
            this.test_name = this.testFile.getName();
        }
        if (this.showOutput) {
            this.log(MessageBox.box("Starting test: " + this.test_name));
        }
        Hashtable hashtable = project.getTargets();
        Enumeration<Object> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            charSequence = (String)enumeration.nextElement();
            if (((String)charSequence).equals("setUp")) {
                this.setUp = (Target)hashtable.get(charSequence);
                continue;
            }
            if (((String)charSequence).equals("tearDown")) {
                this.tearDown = (Target)hashtable.get(charSequence);
                continue;
            }
            if (((String)charSequence).startsWith("test")) {
                this.testTargets.addElement(hashtable.get(charSequence));
                continue;
            }
            if (((String)charSequence).lastIndexOf(".") <= 0 || !((String)charSequence).substring(((String)charSequence).lastIndexOf(".") + 1).startsWith("test")) continue;
            this.testTargets.addElement(hashtable.get(charSequence));
        }
        if (this.setUp != null) {
            this.setUp.execute();
        }
        charSequence = new StringBuffer();
        enumeration = this.testTargets.elements();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            try {
                project.executeTarget(target.getName());
                if (this.showOutput) {
                    this.log(target.getName() + " passed.");
                }
                ++this.tests_passed;
            }
            catch (Exception exception) {
                String string3;
                block25: {
                    block26: {
                        string3 = "ERROR: ";
                        if (!(exception instanceof AssertException)) break block26;
                        int n = ((AssertException)((Object)exception)).getLevel();
                        if (n == 0) {
                            ++this.tests_failed;
                            break block25;
                        } else if (n == 1) {
                            ++this.tests_warning;
                            string3 = "WARNING: ";
                            break block25;
                        } else {
                            if (!this.showOutput) continue;
                            this.log(target.getName() + ": " + exception.getMessage());
                            continue;
                        }
                    }
                    ++this.tests_failed;
                }
                if (this.showOutput) {
                    this.log(string3 + target.getName() + " failed: " + exception.getMessage());
                }
                this.failures.addElement(string3 + this.test_name + ": " + target.getName() + " failed: " + exception.getMessage());
                if (!this.failOnError) continue;
                throw new BuildException(exception.getMessage());
            }
        }
        if (this.tearDown != null) {
            this.tearDown.execute();
        }
        this.addAlmostAll(this.getProject(), project.getProperties());
        if (this.showSummary) {
            this.log(this.getSummary());
        }
    }

    public String getSummary() {
        String string = (this.test_name == null ? "Test" : this.test_name) + " Results";
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        if (this.failures.size() > 0) {
            String string3 = "Errors";
            StringBuffer stringBuffer2 = new StringBuffer();
            Enumeration enumeration = this.failures.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer2.append((String)enumeration.nextElement()).append(string2);
            }
            int n = MessageBox.getMaxWidth();
            MessageBox.setMaxWidth(n - 8);
            stringBuffer.append(MessageBox.box(string3, stringBuffer2));
            MessageBox.setMaxWidth(n);
            stringBuffer.append(string2);
        }
        stringBuffer.append("Ran:     ").append(this.getRanCount()).append(" out of ").append(this.getTestCaseCount()).append(" tests.").append(string2);
        stringBuffer.append("Passed:  ").append(this.getPassedCount()).append(string2);
        stringBuffer.append("Warning: ").append(this.getWarningCount()).append(string2);
        stringBuffer.append("Failed:  ").append(this.getFailedCount()).append(string2);
        return MessageBox.box(string, stringBuffer);
    }

    private void initializeProject(Project project) {
        project.setBaseDir(this.getProject().getBaseDir());
        project.setInputHandler(this.getProject().getInputHandler());
        Iterator iterator = this.getProject().getBuildListeners().iterator();
        while (iterator.hasNext()) {
            project.addBuildListener((BuildListener)iterator.next());
        }
        this.getProject().initSubProject(project);
        this.getProject().copyInheritedProperties(project);
        this.getProject().copyUserProperties(project);
        this.addAlmostAll(project, this.getProject().getProperties());
    }

    private void addAlmostAll(Project project, Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if ("basedir".equals(string) || "ant.file".equals(string)) continue;
            String string2 = hashtable.get(string).toString();
            if (project.getProperty(string) != null) continue;
            project.setNewProperty(string, string2);
        }
    }
}

