/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks.password;

import ise.antelope.tasks.password.PasswordHandlerException;
import ise.antelope.tasks.util.Base64;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

public class PasswordHandler {
    public static final String DESEDE = "DESede";
    public static final String DEFAULT_KEY = "The quick brown fox jumped over the lazy dog.";
    private static final String ENCODING = "UTF8";
    private KeySpec keySpec;
    private SecretKeyFactory keyFactory;
    private Cipher cipher;

    public PasswordHandler() throws PasswordHandlerException {
        this(DEFAULT_KEY);
    }

    public PasswordHandler(String string) throws PasswordHandlerException {
        if (string == null) {
            throw new IllegalArgumentException("Encrypt key cannot be null.");
        }
        if (string.trim().length() < 32) {
            throw new IllegalArgumentException("Encrypt key cannot be less than 32 characters.");
        }
        try {
            byte[] byArray = string.getBytes(ENCODING);
            this.keySpec = new DESedeKeySpec(byArray);
            this.keyFactory = SecretKeyFactory.getInstance(DESEDE);
            this.cipher = Cipher.getInstance(DESEDE);
        }
        catch (Exception exception) {
            throw new PasswordHandlerException(exception);
        }
    }

    public String encrypt(String string) throws PasswordHandlerException {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Password cannot be null or empty.");
        }
        try {
            SecretKey secretKey = this.keyFactory.generateSecret(this.keySpec);
            this.cipher.init(1, secretKey);
            byte[] byArray = string.getBytes(ENCODING);
            byte[] byArray2 = this.cipher.doFinal(byArray);
            return Base64.encodeBytes(byArray2);
        }
        catch (Exception exception) {
            throw new PasswordHandlerException(exception);
        }
    }

    public String decrypt(String string) throws PasswordHandlerException {
        if (string == null || string.trim().length() <= 0) {
            throw new IllegalArgumentException("Encrypted password cannot be null or empty.");
        }
        try {
            SecretKey secretKey = this.keyFactory.generateSecret(this.keySpec);
            this.cipher.init(2, secretKey);
            byte[] byArray = Base64.decode(string);
            byte[] byArray2 = this.cipher.doFinal(byArray);
            return new String(byArray2);
        }
        catch (Exception exception) {
            throw new PasswordHandlerException(exception);
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "abcdef1234567890";
            System.out.println("original: " + string.toString());
            System.out.println("original length: " + string.length());
            PasswordHandler passwordHandler = new PasswordHandler();
            String string2 = passwordHandler.encrypt(string.toString());
            System.out.println("encrypted: " + string2);
            System.out.println("encrypted length: " + string2.length());
            if (string2.length() >= 32) {
                System.exit(0);
            }
            passwordHandler = new PasswordHandler();
            String string3 = passwordHandler.decrypt(string2);
            System.out.println("decrypted: " + string3);
            if (string.toString().compareTo(string3) != 0) {
                throw new Exception("test failed!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

