/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks.typedefs.file;

import ise.antelope.tasks.typedefs.file.FileOp;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FileList
implements FileOp {
    private String what = "files";
    private String separator = ",";
    private boolean includepath = true;

    public void setSeparator(String string) {
        if (string != null) {
            this.separator = string;
        }
    }

    public void setIncludepath(boolean bl) {
        this.includepath = bl;
    }

    public void setWhat(String string) {
        if (string == null || string.equals("files")) {
            this.what = "files";
            return;
        }
        if (string.equals("dirs")) {
            this.what = "dirs";
            return;
        }
        if (string.equals("all")) {
            this.what = "all";
            return;
        }
        this.what = "files";
    }

    public String execute(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        if (!file.isDirectory()) {
            return file.toString();
        }
        List<File> list = Arrays.asList(file.listFiles());
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<File> iterator = list.iterator();
        while (iterator.hasNext()) {
            File file2 = iterator.next();
            if (!(this.what.equals("files") && file2.isFile() || this.what.equals("dirs") && file2.isDirectory()) && !this.what.equals("all")) continue;
            String string = this.includepath ? file2.getAbsolutePath() : file2.getName();
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(this.separator);
        }
        return stringBuffer.toString();
    }
}

