/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks.util.math;

import ise.antelope.tasks.util.math.Math;
import ise.antelope.tasks.util.math.Num;
import java.util.Enumeration;
import java.util.Vector;

public class Op {
    private String datatype = null;
    Vector nums = new Vector();
    Vector ops = new Vector();
    String operation = null;
    private boolean _strict = false;

    public Op() {
    }

    public Op(String string) {
        this.setOp(string);
    }

    public Op(String string, String string2) {
        this.setOp(string);
        this.setDatatype(string2);
    }

    public void setOp(String string) {
        this.operation = string.equals("+") ? "add" : (string.equals("-") ? "subtract" : (string.equals("*") || string.equals("x") ? "multiply" : (string.equals("/") || string.equals("\ufffd") ? "divide" : (string.equals("%") || string.equals("\\") ? "mod" : string))));
    }

    public void addConfiguredNum(Num num) {
        this.nums.addElement(num);
    }

    public void setDatatype(String string) {
        if (!(string.equals("int") || string.equals("long") || string.equals("float") || string.equals("double") || string.equals("bigint") || string.equals("bigdecimal"))) {
            throw new IllegalArgumentException("Invalid datatype: " + string + ". Must be one of int, long, float, double, bigint, or bigdouble.");
        }
        this.datatype = string;
    }

    public void addConfiguredOp(Op op) {
        if (this.datatype != null) {
            op.setDatatype(this.datatype);
        }
        this.addConfiguredNum(op.calculate());
    }

    public void setStrict(boolean bl) {
        this._strict = bl;
    }

    public Num calculate() {
        Object object;
        if (this.operation == null) {
            throw new RuntimeException("Operation not specified.");
        }
        String[] stringArray = new String[this.nums.size()];
        Enumeration enumeration = this.nums.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object = (Num)enumeration.nextElement();
            if (this.datatype != null) {
                ((Num)object).setDatatype(this.datatype);
            }
            stringArray[n++] = ((Num)object).toString();
        }
        object = new Math(this._strict);
        Number number = null;
        number = ((Math)object).calculate(this.operation, this.datatype, stringArray);
        if (number == null) {
            throw new ArithmeticException("math error");
        }
        Num num = new Num();
        num.setValue(number.toString());
        num.setDatatype(this.datatype);
        return num;
    }
}

