/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class KappaLayout
implements LayoutManager2,
Serializable {
    protected int _preferred_width = 0;
    protected int _preferred_height = 0;
    protected boolean _size_unknown = true;
    protected int _col_count = 0;
    protected int _row_count = 0;
    protected Hashtable _constraints = new Hashtable();
    protected Hashtable _table = null;
    protected Dimension _0dim = new Dimension(0, 0);
    protected Hashtable _components = null;
    protected int[] _col_widths;
    protected int[] _row_heights;
    protected Vector _same_width_cols;
    protected Vector _same_height_rows;
    protected boolean _stretch = false;
    public static final int N = 1;
    public static final int NE = 2;
    public static final int E = 3;
    public static final int SE = 4;
    public static final int S = 5;
    public static final int SW = 6;
    public static final int W = 7;
    public static final int NW = 8;
    public static final int R = Integer.MAX_VALUE;

    public KappaLayout() {
        this(false);
    }

    public KappaLayout(boolean bl) {
        this._stretch = bl;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-------------------------------\n");
        stringBuffer.append(this.getClass().getName() + ":\n");
        stringBuffer.append("columns=" + this._col_count);
        stringBuffer.append(", rows=" + this._row_count);
        stringBuffer.append(", cells=" + this._col_count * this._row_count + "\n");
        stringBuffer.append("preferred width=" + this._preferred_width);
        stringBuffer.append(", preferred height=" + this._preferred_height + "\n");
        if (this._col_widths != null) {
            stringBuffer.append("column widths (left to right):");
            for (n = 0; n < this._col_widths.length; ++n) {
                stringBuffer.append(this._col_widths[n] + ",");
            }
        }
        if (this._row_heights != null) {
            stringBuffer.append("\nrow heights (top to bottom):");
            for (n = 0; n < this._row_heights.length; ++n) {
                stringBuffer.append(this._row_heights[n] + ",");
            }
        }
        if (this._constraints != null) {
            stringBuffer.append("\ncomponent count=" + this._constraints.size());
            stringBuffer.append("\ncomponents (no order):\n");
            Enumeration enumeration = this._constraints.keys();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(enumeration.nextElement() + "\n");
            }
        }
        stringBuffer.append("-------------------------------\n");
        return stringBuffer.toString();
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component component) {
        if (component == null) {
            return;
        }
        Object object = component.getTreeLock();
        synchronized (object) {
            if (this._constraints != null) {
                Object v;
                Object k;
                this._constraints.remove(component);
                if (this._components == null) {
                    return;
                }
                Enumeration enumeration = this._components.keys();
                while (enumeration.hasMoreElements()) {
                    k = enumeration.nextElement();
                    v = this._constraints.get(k);
                    if (v == null || !v.equals(component)) continue;
                    this._components.remove(k);
                    break;
                }
                enumeration = this._table.keys();
                while (enumeration.hasMoreElements()) {
                    k = enumeration.nextElement();
                    v = this._constraints.get(k);
                    if (v == null || !v.equals(component)) continue;
                    this._table.remove(k);
                    break;
                }
                this._size_unknown = true;
                this.calculateDimensions();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            this._size_unknown = true;
            this.calculateDimensions();
            Insets insets = container.getInsets();
            dimension.width = this._preferred_width + insets.left + insets.right;
            dimension.height = this._preferred_height + insets.top + insets.bottom;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            return this.preferredLayoutSize(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.getSize().width - (insets.left + insets.right);
            int n2 = container.getSize().height - (insets.top + insets.bottom);
            int n3 = insets.left;
            int n4 = insets.top;
            int n5 = 0;
            int n6 = 0;
            this.calculateDimensions();
            if (this._stretch) {
                if (n > this._preferred_width && this._col_count > 1) {
                    n5 = (n - this._preferred_width) / (this._col_count - 1);
                }
                if (n2 > this._preferred_height && this._row_count > 1) {
                    n6 = (n2 - this._preferred_height) / (this._row_count - 1);
                }
            }
            Point point = new Point();
            for (int i = 0; i < this._col_count; ++i) {
                point.x = i;
                n4 = insets.top;
                if (i > 0) {
                    n3 += Math.abs(this._col_widths[i - 1]);
                    if (this._stretch && i < this._col_count) {
                        n3 += n5;
                    }
                }
                block14: for (int j = 0; j < this._row_count; ++j) {
                    int n7;
                    int n8;
                    Component component;
                    point.y = j;
                    if (j > 0) {
                        n4 += Math.abs(this._row_heights[j - 1]);
                        if (this._stretch && j < this._row_count) {
                            n4 += n6;
                        }
                    }
                    if ((component = (Component)this._components.get(point)) == null || !component.isVisible()) continue;
                    Dimension dimension = component.getPreferredSize();
                    Constraints constraints = (Constraints)this._constraints.get(component);
                    int n9 = 0;
                    if (constraints.w == Integer.MAX_VALUE) {
                        for (n8 = i; n8 < this._col_count; ++n8) {
                            n9 += Math.abs(this._col_widths[n8]);
                        }
                    } else {
                        for (n8 = i; n8 < i + constraints.w; ++n8) {
                            n9 += Math.abs(this._col_widths[n8]);
                        }
                    }
                    n8 = 0;
                    if (constraints.h == Integer.MAX_VALUE) {
                        for (n7 = i; n7 < this._row_count; ++n7) {
                            n8 += Math.abs(this._row_heights[n7]);
                        }
                    } else {
                        for (n7 = j; n7 < j + constraints.h; ++n7) {
                            n8 += Math.abs(this._row_heights[n7]);
                        }
                    }
                    if (constraints.s.indexOf("w") != -1) {
                        dimension.width = n9 - constraints.p * 2;
                    }
                    if (constraints.s.indexOf("h") != -1) {
                        dimension.height = n8 - constraints.p * 2;
                    }
                    n7 = n9 - dimension.width;
                    int n10 = n8 - dimension.height;
                    switch (constraints.a) {
                        case 1: {
                            component.setBounds(n3 += n7 / 2, n4 += constraints.p, dimension.width, dimension.height);
                            n3 -= n7 / 2;
                            n4 -= constraints.p;
                            continue block14;
                        }
                        case 2: {
                            component.setBounds(n3 += n7 - constraints.p, n4 += constraints.p, dimension.width, dimension.height);
                            n3 -= n7 - constraints.p;
                            n4 -= constraints.p;
                            continue block14;
                        }
                        case 3: {
                            component.setBounds(n3 += n7 - constraints.p, n4 += n10 / 2, dimension.width, dimension.height);
                            n3 -= n7 - constraints.p;
                            n4 -= n10 / 2;
                            continue block14;
                        }
                        case 4: {
                            component.setBounds(n3 += n7 - constraints.p, n4 += n10 - constraints.p, dimension.width, dimension.height);
                            n3 -= n7 - constraints.p;
                            n4 -= n10 - constraints.p;
                            continue block14;
                        }
                        case 5: {
                            component.setBounds(n3 += n7 / 2, n4 += n10 - constraints.p, dimension.width, dimension.height);
                            n3 -= n7 / 2;
                            n4 -= n10 - constraints.p;
                            continue block14;
                        }
                        case 6: {
                            component.setBounds(n3 += constraints.p, n4 += n10 - constraints.p, dimension.width, dimension.height);
                            n3 -= constraints.p;
                            n4 -= n10 - constraints.p;
                            continue block14;
                        }
                        case 7: {
                            component.setBounds(n3 += constraints.p, n4 += n10 / 2, dimension.width, dimension.height);
                            n3 -= constraints.p;
                            n4 -= n10 / 2;
                            continue block14;
                        }
                        case 8: {
                            component.setBounds(n3 += constraints.p, n4 += constraints.p, dimension.width, dimension.height);
                            n3 -= constraints.p;
                            n4 -= constraints.p;
                            continue block14;
                        }
                        default: {
                            component.setBounds(n3 += n7 / 2, n4 += n10 / 2, dimension.width, dimension.height);
                            n3 -= n7 / 2;
                            n4 -= n10 / 2;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            Strut strut;
            String string;
            if (component == null) {
                throw new IllegalArgumentException("No component.");
            }
            if (object == null) {
                throw new IllegalArgumentException("No constraint.");
            }
            if (object instanceof Constraints) {
                Strut strut2;
                Constraints constraints = (Constraints)object;
                this._constraints.put(component, constraints.clone());
                if (component instanceof Strut && (strut2 = (Strut)component).isRigid()) {
                    Dimension dimension = strut2.getSize();
                    if (dimension.width > 0) {
                        this.setColumnWidth(constraints.x, dimension.width);
                    }
                    if (dimension.height > 0) {
                        this.setRowHeight(constraints.y, dimension.height);
                    }
                }
                this._size_unknown = true;
                return;
            }
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("Illegal constraint object.");
            }
            Vector<String> vector = new Vector<String>();
            String string2 = object.toString();
            while (string2.length() > 0) {
                int n = string2.indexOf(44);
                if (n != -1) {
                    string = string2.substring(0, n);
                    string2 = string2.substring(n + 1);
                } else {
                    string = string2;
                    string2 = "";
                }
                if (string != null) {
                    string = string.trim();
                }
                if (string != null && string.length() > 0) {
                    vector.addElement(string);
                    continue;
                }
                vector.addElement("-1");
            }
            Constraints constraints = new Constraints();
            Enumeration enumeration = vector.elements();
            if (enumeration.hasMoreElements()) {
                string = enumeration.nextElement().toString();
                try {
                    constraints.x = Integer.parseInt(string);
                    if (constraints.x < 0) {
                        constraints.x = 0;
                    }
                }
                catch (Exception exception) {
                    constraints.x = 0;
                }
            }
            if (enumeration.hasMoreElements()) {
                string = enumeration.nextElement().toString();
                try {
                    constraints.y = Integer.parseInt(string);
                    if (constraints.y < 0) {
                        constraints.y = 0;
                    }
                }
                catch (Exception exception) {
                    constraints.y = 0;
                }
            }
            if (enumeration.hasMoreElements()) {
                string = enumeration.nextElement().toString();
                if (string.equalsIgnoreCase("R")) {
                    constraints.w = Integer.MAX_VALUE;
                } else {
                    try {
                        constraints.w = Integer.parseInt(string);
                        if (constraints.w < 1) {
                            constraints.w = 1;
                        }
                    }
                    catch (Exception exception) {
                        constraints.w = 1;
                    }
                }
            }
            if (enumeration.hasMoreElements()) {
                string = enumeration.nextElement().toString();
                if (string.equalsIgnoreCase("R")) {
                    constraints.h = Integer.MAX_VALUE;
                } else {
                    try {
                        constraints.h = Integer.parseInt(string);
                        if (constraints.h < 1) {
                            constraints.h = 1;
                        }
                    }
                    catch (Exception exception) {
                        constraints.h = 1;
                    }
                }
            }
            if (enumeration.hasMoreElements()) {
                string = enumeration.nextElement().toString().trim();
                constraints.a = string.equalsIgnoreCase("N") || string.equals("1") ? 1 : (string.equalsIgnoreCase("NE") || string.equals("2") ? 2 : (string.equalsIgnoreCase("E") || string.equals("3") ? 3 : (string.equalsIgnoreCase("SE") || string.equals("4") ? 4 : (string.equalsIgnoreCase("S") || string.equals("5") ? 5 : (string.equalsIgnoreCase("SW") || string.equals("6") ? 6 : (string.equalsIgnoreCase("W") || string.equals("7") ? 7 : (string.equalsIgnoreCase("NW") || string.equals("8") ? 8 : 0)))))));
            }
            if (enumeration.hasMoreElements()) {
                string = enumeration.nextElement().toString().trim().toLowerCase();
                constraints.s = string.equals("w") || string.equals("h") || string.equals("wh") || string.equals("hw") ? string : "0";
            }
            if (enumeration.hasMoreElements()) {
                string = enumeration.nextElement().toString();
                try {
                    constraints.p = Integer.parseInt(string);
                    if (constraints.p < 0) {
                        constraints.p = 0;
                    }
                }
                catch (Exception exception) {
                    constraints.p = 0;
                }
            }
            this._constraints.put(component, constraints);
            if (component instanceof Strut && (strut = (Strut)component).isRigid()) {
                Dimension dimension = strut.getSize();
                if (dimension.width > 0) {
                    this.setColumnWidth(constraints.x, dimension.width);
                }
                if (dimension.height > 0) {
                    this.setRowHeight(constraints.y, dimension.height);
                }
            }
            this._size_unknown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension maximumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            return this.preferredLayoutSize(container);
        }
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    protected void calculateDimensions() {
        int n;
        int n2;
        int[] nArray;
        if (!this._size_unknown) {
            return;
        }
        this._preferred_width = 0;
        this._preferred_height = 0;
        Dimension dimension = null;
        this.countColumns();
        this.countRows();
        if (this._table == null) {
            this._table = new Hashtable(23, 0.75f);
        } else {
            this._table.clear();
        }
        if (this._components == null) {
            this._components = new Hashtable(23, 0.75f);
        } else {
            this._components.clear();
        }
        if (this._col_widths != null) {
            nArray = new int[this._col_widths.length];
            System.arraycopy(this._col_widths, 0, nArray, 0, this._col_widths.length);
            this._col_widths = new int[this._col_count];
            System.arraycopy(nArray, 0, this._col_widths, 0, Math.min(nArray.length, this._col_widths.length));
        } else {
            this._col_widths = new int[this._col_count];
        }
        if (this._row_heights != null) {
            nArray = new int[this._row_heights.length];
            System.arraycopy(this._row_heights, 0, nArray, 0, this._row_heights.length);
            this._row_heights = new int[this._row_count];
            System.arraycopy(nArray, 0, this._row_heights, 0, Math.min(nArray.length, this._row_heights.length));
        } else {
            this._row_heights = new int[this._row_count];
        }
        Enumeration<Object> enumeration = this._constraints.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            Constraints constraints = (Constraints)this._constraints.get(component);
            if (constraints.w == Integer.MAX_VALUE) {
                constraints.w = this._col_count - constraints.x;
            }
            if (constraints.h == Integer.MAX_VALUE) {
                constraints.h = this._row_count - constraints.y;
            }
            this._components.put(new Point(constraints.x, constraints.y), component);
            dimension = new Dimension(component.getPreferredSize().width, component.getPreferredSize().height);
            dimension.width += constraints.p * 2;
            dimension.height += constraints.p * 2;
            dimension.width /= constraints.w;
            dimension.height /= constraints.h;
            for (n2 = constraints.x; n2 < constraints.x + constraints.w; ++n2) {
                for (int i = constraints.y; i < constraints.y + constraints.h; ++i) {
                    this._table.put(new Point(n2, i), dimension);
                }
            }
        }
        int n3 = 0;
        for (int i = 0; i < this._col_count; ++i) {
            for (n2 = 0; n2 < this._row_count; ++n2) {
                Dimension dimension2 = (Dimension)this._table.get(new Point(i, n2));
                if (dimension2 == null) {
                    dimension2 = this._0dim;
                }
                n3 = Math.max(dimension2.width, n3);
            }
            if (this._col_widths[i] >= 0) {
                this._col_widths[i] = n3;
                this._preferred_width += n3;
            } else {
                this._preferred_width += Math.abs(this._col_widths[i]);
            }
            n3 = 0;
        }
        if (this._same_width_cols != null) {
            enumeration = this._same_width_cols.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray2 = (int[])enumeration.nextElement();
                n2 = nArray2[0];
                for (n = 0; n < nArray2.length; ++n) {
                    if (nArray2[n] >= this._col_widths.length) continue;
                    n2 = Math.max(n2, this._col_widths[nArray2[n]]);
                }
                for (n = 0; n < nArray2.length; ++n) {
                    if (nArray2[n] >= this._col_widths.length) continue;
                    this._preferred_width += n2 - this._col_widths[nArray2[n]];
                    this._col_widths[nArray2[n]] = n2;
                }
            }
        }
        int n4 = 0;
        for (n2 = 0; n2 < this._row_count; ++n2) {
            for (n = 0; n < this._col_count; ++n) {
                Dimension dimension3 = (Dimension)this._table.get(new Point(n, n2));
                if (dimension3 == null) {
                    dimension3 = this._0dim;
                }
                n4 = Math.max(dimension3.height, n4);
            }
            if (this._row_heights[n2] >= 0) {
                this._row_heights[n2] = n4;
                this._preferred_height += n4;
            } else {
                this._preferred_height += Math.abs(this._row_heights[n2]);
            }
            n4 = 0;
        }
        if (this._same_height_rows != null) {
            enumeration = this._same_height_rows.elements();
            while (enumeration.hasMoreElements()) {
                int n5;
                int[] nArray3 = (int[])enumeration.nextElement();
                n = nArray3[0];
                for (n5 = 0; n5 < nArray3.length; ++n5) {
                    if (nArray3[n5] >= this._row_heights.length) continue;
                    n = Math.max(n, this._row_heights[nArray3[n5]]);
                }
                for (n5 = 0; n5 < nArray3.length; ++n5) {
                    if (nArray3[n5] >= this._row_heights.length) continue;
                    this._preferred_height += n - this._row_heights[nArray3[n5]];
                    this._row_heights[nArray3[n5]] = n;
                }
            }
        }
        this._size_unknown = false;
    }

    private void countColumns() {
        Cloneable cloneable;
        this._col_count = 0;
        Hashtable<String, BitSet> hashtable = new Hashtable<String, BitSet>();
        Enumeration enumeration = this._constraints.elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (Constraints)enumeration.nextElement();
            BitSet bitSet = null;
            String string = String.valueOf(((Constraints)cloneable).y);
            if (!hashtable.containsKey(string)) {
                bitSet = new BitSet();
                hashtable.put(string, bitSet);
            }
            bitSet = (BitSet)hashtable.get(string);
            int n = ((Constraints)cloneable).w == Integer.MAX_VALUE ? ((Constraints)cloneable).x + 1 : ((Constraints)cloneable).x + ((Constraints)cloneable).w;
            for (int i = ((Constraints)cloneable).x; i < n; ++i) {
                bitSet.set(i);
            }
        }
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (BitSet)enumeration.nextElement();
            for (int i = 0; i < ((BitSet)cloneable).size(); ++i) {
                if (!((BitSet)cloneable).get(i)) continue;
                this._col_count = Math.max(this._col_count, i + 1);
            }
        }
    }

    private void countRows() {
        Cloneable cloneable;
        this._row_count = 0;
        Hashtable<String, BitSet> hashtable = new Hashtable<String, BitSet>();
        Enumeration enumeration = this._constraints.elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (Constraints)enumeration.nextElement();
            BitSet bitSet = null;
            String string = String.valueOf(((Constraints)cloneable).x);
            if (!hashtable.containsKey(string)) {
                bitSet = new BitSet();
                hashtable.put(string, bitSet);
            }
            bitSet = (BitSet)hashtable.get(string);
            int n = ((Constraints)cloneable).h == Integer.MAX_VALUE ? ((Constraints)cloneable).y + 1 : ((Constraints)cloneable).y + ((Constraints)cloneable).h;
            for (int i = ((Constraints)cloneable).y; i < n; ++i) {
                bitSet.set(i);
            }
        }
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (BitSet)enumeration.nextElement();
            for (int i = 0; i < ((BitSet)cloneable).size(); ++i) {
                if (!((BitSet)cloneable).get(i)) continue;
                this._row_count = Math.max(this._row_count, i + 1);
            }
        }
    }

    public void makeColumnsSameWidth(int n, int n2) {
        this.makeColumnsSameWidth(new int[]{n, n2});
    }

    public void makeColumnsSameWidth(int[] nArray) {
        if (nArray.length <= 1) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0) continue;
            throw new IllegalArgumentException("Column parameter must be greater than 0.");
        }
        if (this._same_width_cols == null) {
            this._same_width_cols = new Vector();
        }
        this._same_width_cols.addElement(nArray);
        this._size_unknown = true;
    }

    public void makeColumnsSameWidth() {
        this.countColumns();
        int[] nArray = new int[this._col_count];
        for (int i = 0; i < this._col_count; ++i) {
            nArray[i] = i;
        }
        this.makeColumnsSameWidth(nArray);
    }

    public void makeRowsSameHeight(int n, int n2) {
        this.makeRowsSameHeight(new int[]{n, n2});
    }

    public void makeRowsSameHeight(int[] nArray) {
        if (nArray.length <= 1) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0) continue;
            throw new IllegalArgumentException("Row parameter must be greater than 0.");
        }
        if (this._same_height_rows == null) {
            this._same_height_rows = new Vector();
        }
        this._same_height_rows.addElement(nArray);
        this._size_unknown = true;
    }

    public void makeRowsSameHeight() {
        this.countRows();
        int[] nArray = new int[this._row_count];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        this.makeRowsSameHeight(nArray);
    }

    public void setColumnWidth(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Column must be >= 0.");
        }
        if (this._col_widths == null) {
            this._col_widths = new int[n + 1];
        }
        if (this._col_widths.length <= n) {
            int[] nArray = new int[this._col_widths.length];
            System.arraycopy(this._col_widths, 0, nArray, 0, this._col_widths.length);
            this._col_widths = new int[n + 1];
            System.arraycopy(nArray, 0, this._col_widths, 0, nArray.length);
        }
        this._col_widths[n] = -1 * n2;
        this._size_unknown = true;
    }

    public void setRowHeight(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Row must be >= 0.");
        }
        if (this._row_heights == null) {
            this._row_heights = new int[n + 1];
        }
        if (this._row_heights.length <= n) {
            int[] nArray = new int[this._row_heights.length];
            System.arraycopy(this._row_heights, 0, nArray, 0, this._row_heights.length);
            this._row_heights = new int[n + 1];
            System.arraycopy(nArray, 0, this._row_heights, 0, nArray.length);
        }
        this._row_heights[n] = -1 * n2;
        this._size_unknown = true;
    }

    public static Constraints createConstraint() {
        return new Constraints();
    }

    public static Component createHorizontalStrut(int n) {
        return new Strut(n, 0);
    }

    public static Component createHorizontalStrut(int n, boolean bl) {
        return new Strut(n, 0, bl);
    }

    public static Component createVerticalStrut(int n) {
        return new Strut(0, n);
    }

    public static Component createVerticalStrut(int n, boolean bl) {
        return new Strut(0, n, bl);
    }

    public static Component createStrut(int n, int n2) {
        return new Strut(n, n2);
    }

    public static Component createStrut(int n, int n2, boolean bl) {
        return new Strut(n, n2, bl);
    }

    public static class Constraints
    implements Cloneable,
    Serializable {
        public int x = 0;
        public int y = 0;
        public int w = 1;
        public int h = 1;
        public int a = 0;
        public String s = "0";
        public int p = 0;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(String.valueOf(this.x) + ",").append(String.valueOf(this.y) + ",").append(String.valueOf(this.w) + ",");
            if (this.w == Integer.MAX_VALUE) {
                stringBuffer.append("R,");
            } else {
                stringBuffer.append(String.valueOf(this.w) + ",");
            }
            if (this.h == Integer.MAX_VALUE) {
                stringBuffer.append("R,");
            } else {
                stringBuffer.append(String.valueOf(this.h) + ",");
            }
            stringBuffer.append(String.valueOf(this.a) + ",").append(String.valueOf(this.s) + ",").append(String.valueOf(this.p)).toString();
            return stringBuffer.toString();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static class Strut
    extends Component
    implements Serializable {
        private Dimension _dim;
        private boolean _rigid;

        public Strut(int n, int n2) {
            this(n, n2, false);
        }

        public Strut(int n, int n2, boolean bl) {
            this._dim = new Dimension(n, n2);
            this._rigid = bl;
        }

        public Dimension getPreferredSize() {
            return this._dim;
        }

        public Dimension getSize() {
            return this._dim;
        }

        public boolean isRigid() {
            return this._rigid;
        }

        public void setRigid(boolean bl) {
            this._rigid = bl;
        }
    }
}

