/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PrivilegedAccessor {
    public static Object getValue(Object object, String string) throws IllegalAccessException, NoSuchFieldException {
        Field field = PrivilegedAccessor.getField(object.getClass(), string);
        field.setAccessible(true);
        return field.get(object);
    }

    public static void setValue(Object object, String string, Object object2) throws IllegalAccessException, NoSuchFieldException {
        Field field = PrivilegedAccessor.getField(object.getClass(), string);
        field.setAccessible(true);
        field.set(object, object2);
    }

    public static Object getStaticValue(Class clazz, String string) throws IllegalAccessException, NoSuchFieldException {
        Field field = PrivilegedAccessor.getField(clazz, string);
        field.setAccessible(true);
        return field.get(null);
    }

    public static Object invokeMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return PrivilegedAccessor.invokeMethod(object, string, objectArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Class[] classArray = PrivilegedAccessor.getClassArray(objectArray);
        Method[] methodArray = object.getClass().getDeclaredMethods();
        boolean bl = false;
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            Class[] classArray2 = method.getParameterTypes();
            if (!method.getName().equals(string) || !PrivilegedAccessor.compare(classArray2, objectArray)) continue;
            method.setAccessible(true);
            return method.invoke(object, objectArray);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("No method named ").append(string).append(" found in ").append(object.getClass().getName()).append(" with parameters (");
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i >= classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        throw new NoSuchMethodException(stringBuffer.toString());
    }

    private static Class[] getClassArray(Object[] objectArray) {
        Class[] classArray = null;
        if (objectArray != null) {
            classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                classArray[i] = objectArray[i].getClass();
            }
        }
        return classArray;
    }

    public static Method getMethod(Object object, String string, Class[] classArray) throws NoSuchMethodException {
        Method method = PrivilegedAccessor.getMethod(object.getClass(), string, classArray);
        method.setAccessible(true);
        return method;
    }

    public static Field getField(Class clazz, String string) throws NoSuchFieldException {
        if (clazz == null) {
            throw new NoSuchFieldException("Invalid field : " + string);
        }
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return PrivilegedAccessor.getField(clazz.getSuperclass(), string);
        }
    }

    public static Method getMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        if (clazz == null) {
            throw new NoSuchMethodException("Invalid method : " + string);
        }
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return PrivilegedAccessor.getMethod(clazz.getSuperclass(), string, classArray);
        }
    }

    private static boolean compare(Class[] classArray, Object[] objectArray) {
        if (classArray.length != objectArray.length) {
            return false;
        }
        if (classArray.length == 0) {
            return true;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (classArray[i].isInstance(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    public static Object getNewInstance(String string, Object[] objectArray) throws ClassNotFoundException, InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (string == null) {
            throw new ClassNotFoundException();
        }
        return PrivilegedAccessor.getNewInstance(Class.forName(string), objectArray);
    }

    public static Object getNewInstance(Class clazz, Object[] objectArray) throws ClassNotFoundException, InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (clazz == null) {
            throw new ClassNotFoundException();
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Class[] classArray = PrivilegedAccessor.getClassArray(objectArray);
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            Constructor<?> constructor = constructorArray[i];
            Class[] classArray2 = constructor.getParameterTypes();
            if (!PrivilegedAccessor.compare(classArray2, objectArray)) continue;
            return constructor.newInstance(objectArray);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("No constructor found for ").append(clazz.getName()).append(" with parameters (");
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i >= classArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        throw new NoSuchMethodException(stringBuffer.toString());
    }
}

