/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

public class TableArray
implements Map,
Serializable,
Cloneable {
    private TreeMap table = new TreeMap(new PointComparator());
    private Object _default = null;

    public TableArray() {
        this(null);
    }

    public TableArray(Object object) {
        this._default = object;
    }

    public void setDefaultValue(Object object) {
        this._default = object;
    }

    public Object getDefaultValue() {
        return this._default;
    }

    public Object put(int n, int n2, Object object) {
        Object object2 = this.get(n, n2);
        Point point = new Point(n, n2);
        if (object != null && object.equals(this.getDefaultValue())) {
            this.remove(point);
        } else if (object == null && this.getDefaultValue() == null) {
            this.remove(point);
        } else {
            this.table.put(point, object);
        }
        return object2;
    }

    public Object put(Object object, int n, int n2) {
        return this.put(n, n2, object);
    }

    public Object get(int n, int n2) {
        Point point = new Point(n, n2);
        Object object = this.table.get(point);
        if (object == null) {
            object = this._default;
        }
        return object;
    }

    public int getWidth() {
        if (this.table.size() == 0) {
            return 0;
        }
        return this.getMaxX() - this.getMinX() + 1;
    }

    public int getColumnCount() {
        return this.getWidth();
    }

    public int getHeight() {
        if (this.table.size() == 0) {
            return 0;
        }
        return this.getMaxY() - this.getMinY() + 1;
    }

    public int getRowCount() {
        return this.getHeight();
    }

    public int getMinX() {
        Point point;
        if (this.table.size() == 0) {
            return 0;
        }
        int n = 0;
        Iterator iterator = this.table.keySet().iterator();
        if (iterator.hasNext()) {
            point = (Point)iterator.next();
            n = point.x;
        }
        while (iterator.hasNext()) {
            point = (Point)iterator.next();
            if (point.x >= n) continue;
            n = point.x;
        }
        return n;
    }

    public int getMinY() {
        if (this.table.size() == 0) {
            return 0;
        }
        Point point = (Point)this.table.firstKey();
        return point.y;
    }

    public int getMaxX() {
        Point point;
        if (this.table.size() == 0) {
            return 0;
        }
        int n = 0;
        Iterator iterator = this.table.keySet().iterator();
        if (iterator.hasNext()) {
            point = (Point)iterator.next();
            n = point.x;
        }
        while (iterator.hasNext()) {
            point = (Point)iterator.next();
            if (point.x <= n) continue;
            n = point.x;
        }
        return n;
    }

    public int getMaxY() {
        if (this.table.size() == 0) {
            return 0;
        }
        Point point = (Point)this.table.lastKey();
        return point.y;
    }

    public void clear() {
        this.table.clear();
    }

    public boolean containsKey(Object object) {
        return this.table.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.table.containsValue(object);
    }

    public Set entrySet() {
        return this.table.entrySet();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            TableArray tableArray = (TableArray)object;
            if (tableArray.size() != this.size()) {
                return false;
            }
            Iterator iterator = this.pointIterator();
            while (iterator.hasNext()) {
                Point point = (Point)iterator.next();
                if (this.get(point).equals(tableArray.get(point))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public Object get(Object object) {
        Point point = (Point)object;
        return this.get(point.x, point.y);
    }

    public List getRow(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = this.getMinX(); i <= this.getMaxX(); ++i) {
            arrayList.add(this.get(i, n));
        }
        return arrayList;
    }

    public void putRow(int n, List list) {
        this.removeRow(n);
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            this.put(n2 + this.getMinX(), n, iterator.next());
            ++n2;
        }
    }

    public List getColumn(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = this.getMinY(); i <= this.getMaxY(); ++i) {
            arrayList.add(this.get(n, i));
        }
        return arrayList;
    }

    public void putColumn(int n, List list) {
        for (int i = this.getMinY(); i <= this.getMaxY(); ++i) {
            this.remove(n, i);
        }
        Iterator iterator = list.iterator();
        int n2 = this.getMinY();
        while (iterator.hasNext()) {
            this.put(n, n2, iterator.next());
            ++n2;
        }
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public Set keySet() {
        return this.table.keySet();
    }

    public Set pointSet() {
        return this.keySet();
    }

    public Iterator pointIterator() {
        return new Iterator(){
            private int min_x;
            private int min_y;
            private int max_x;
            private int max_y;
            private int x;
            private int y;
            {
                this.min_x = TableArray.this.getMinX();
                this.min_y = TableArray.this.getMinY();
                this.max_x = TableArray.this.getMaxX();
                this.max_y = TableArray.this.getMaxY();
                this.x = this.min_x;
                this.y = this.min_y;
            }

            public boolean hasNext() {
                return this.x <= this.max_x && this.y <= this.max_y;
            }

            public Object next() {
                if (this.hasNext()) {
                    Point point = new Point(this.x, this.y);
                    ++this.x;
                    if (this.x > this.max_x) {
                        this.x = this.min_x;
                        ++this.y;
                    }
                    return point;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator valueIterator() {
        return new Iterator(){
            private int min_x;
            private int min_y;
            private int max_x;
            private int max_y;
            private int x;
            private int y;
            {
                this.min_x = TableArray.this.getMinX();
                this.min_y = TableArray.this.getMinY();
                this.max_x = TableArray.this.getMaxX();
                this.max_y = TableArray.this.getMaxY();
                this.x = this.min_x;
                this.y = this.min_y;
            }

            public boolean hasNext() {
                return this.x <= this.max_x && this.y <= this.max_y;
            }

            public Object next() {
                if (this.hasNext()) {
                    Object object = TableArray.this.get(this.x, this.y);
                    ++this.x;
                    if (this.x > this.max_x) {
                        this.x = this.min_x;
                        ++this.y;
                    }
                    return object;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator columnIterator(int n) {
        final int n2 = n;
        return new Iterator(){
            private int min_y;
            private int max_y;
            private int y;
            {
                this.min_y = TableArray.this.getMinY();
                this.max_y = TableArray.this.getMaxY();
                this.y = this.min_y;
            }

            public boolean hasNext() {
                return this.y <= this.max_y;
            }

            public Object next() {
                if (this.hasNext()) {
                    Object object = TableArray.this.get(n2, this.y);
                    ++this.y;
                    return object;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator rowIterator(int n) {
        final int n2 = n;
        return new Iterator(){
            private int min_x;
            private int max_x;
            private int x;
            {
                this.min_x = TableArray.this.getMinX();
                this.max_x = TableArray.this.getMaxX();
                this.x = this.min_x;
            }

            public boolean hasNext() {
                return this.x <= this.max_x;
            }

            public Object next() {
                if (this.hasNext()) {
                    Object object = TableArray.this.get(this.x, n2);
                    ++this.x;
                    return object;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object put(Object object, Object object2) {
        return this.put(((Point)object).x, ((Point)object).y, object2);
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            Object v = map.get(point);
            this.put(point.x, point.y, v);
        }
    }

    public Object remove(Object object) {
        return this.table.remove(object);
    }

    public Object remove(int n, int n2) {
        return this.remove(new Point(n, n2));
    }

    public void removeRow(int n) {
        for (int i = this.getMinX(); i < this.getMaxX(); ++i) {
            this.remove(i, n);
        }
    }

    public void removeColumn(int n) {
        for (int i = this.getMinY(); i < this.getMaxY(); ++i) {
            this.remove(n, i);
        }
    }

    public int size() {
        return this.table.size();
    }

    public int getSize() {
        return this.size();
    }

    public int getCellCount() {
        return this.getWidth() * this.getHeight();
    }

    public Collection values() {
        return this.table.values();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TableArray [(").append(this.getMinX()).append(",").append(this.getMinY()).append("), (").append(this.getMaxX()).append(",").append(this.getMaxY()).append("), w=").append(this.getWidth()).append(", h=").append(this.getHeight()).append(", size=").append(this.size()).append("]");
        if (this.size() > 0) {
            stringBuffer.append(System.getProperty("line.separator")).append(this.dataToString());
        } else {
            stringBuffer.append("[empty]");
        }
        return stringBuffer.toString();
    }

    public String dataToString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        for (int i = this.getMinY(); i <= this.getMaxY(); ++i) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("[");
            for (int j = this.getMinX(); j <= this.getMaxX(); ++j) {
                Object object = this.get(j, i);
                if (object == null) {
                    object = "";
                }
                stringBuffer2.append(object.toString());
                if (j >= this.getMaxX()) continue;
                stringBuffer2.append(",");
            }
            stringBuffer2.append("]").append(string);
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        TableArray tableArray = new TableArray();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Point point = (Point)iterator.next();
            tableArray.put(point, this.get(point.x, point.y));
        }
        return tableArray;
    }

    class PointComparator
    implements Comparator,
    Serializable {
        PointComparator() {
        }

        public int compare(Object object, Object object2) {
            Point point = (Point)object;
            Point point2 = (Point)object2;
            if (point.x == point2.x && point.y == point2.y) {
                return 0;
            }
            if (point.y < point2.y) {
                return -1;
            }
            if (point.y == point2.y && point.x < point2.x) {
                return -1;
            }
            return 1;
        }
    }
}

