/*
 * Decompiled with CFR 0.152.
 */
package ise.library.ascii;

import java.io.BufferedReader;
import java.io.StringReader;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MessageBox {
    private static String LS = System.getProperty("line.separator");
    private static int MAX_WIDTH = 60;

    public static void setMaxWidth(int n) {
        MAX_WIDTH = n;
    }

    public static int getMaxWidth() {
        return MAX_WIDTH;
    }

    public static String box(CharSequence charSequence) {
        return MessageBox.box(null, charSequence);
    }

    public static String box(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null && charSequence2 == null) {
            return "";
        }
        if (charSequence != null && charSequence2 == null) {
            charSequence2 = charSequence;
            charSequence = null;
        }
        List list = MessageBox.getLines(charSequence);
        List list2 = MessageBox.getLines(charSequence2);
        int n = Math.max(MessageBox.getWidth(list), MessageBox.getWidth(list2));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LS);
        if (list != null) {
            stringBuffer.append(MessageBox.boxTitle(list, n));
        }
        stringBuffer.append(MessageBox.boxText(list2, n));
        return stringBuffer.toString();
    }

    private static int getWidth(List list) {
        if (list == null) {
            return 0;
        }
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            n = Math.max(n, ((String)iterator.next()).length());
        }
        return n;
    }

    private static List wrapLine(String string) {
        String string2;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.length() <= MAX_WIDTH) {
            arrayList.add(string);
            return arrayList;
        }
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n = breakIterator.first();
        int n3 = n;
        n3 = breakIterator.next();
        while (n3 != -1) {
            stringBuffer.append(string.substring(n, n3));
            if (stringBuffer.length() > MAX_WIDTH) break;
            n = n3;
            n3 = breakIterator.next();
        }
        if ((string2 = string.substring(n2, n3)).startsWith(" ") && !string2.startsWith("  ")) {
            string2 = string2.substring(1);
        }
        arrayList.add(string2);
        if (string.substring(n3).length() > 0) {
            arrayList.addAll(MessageBox.wrapLine(string.substring(n3 + 1)));
        }
        return arrayList;
    }

    private static List getLines(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(((Object)charSequence).toString()));
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                string = string.replaceAll("[\t]", "   ");
                arrayList.addAll(MessageBox.wrapLine(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    private static String boxTitle(List list, int n) {
        return MessageBox.boxText(list, n, false);
    }

    private static String boxText(List list, int n) {
        return MessageBox.boxText(list, n, true);
    }

    private static String boxText(List list, int n, boolean bl) {
        String string = MessageBox.getHR(n + 2);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuffer.append("| ");
            stringBuffer.append(string2);
            for (int i = string2.length(); i < n; ++i) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(" |").append(LS);
        }
        if (bl) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static String getHR(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("+");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("-");
        }
        stringBuffer.append("+");
        stringBuffer.append(LS);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("1) jdbc.oracle.whatever:@hoser").append(LS);
        stringBuffer.append("\tcom.oracle.jdbc.Driver").append(LS);
        stringBuffer.append("x) Cancel");
        stringBuffer.append("Character boundary analysis allows users to interact with characters as they expect to, for example, when moving the cursor around through a text string. Character boundary analysis provides correct navigation of through character strings, regardless of how the character is stored. For example, an accented character might be stored as a base character and a diacritical mark. What users consider to be a character can differ between languages.");
        System.out.println(MessageBox.box("Select a database:", stringBuffer.toString()));
        stringBuffer = new StringBuffer();
        stringBuffer.append("-> Error: Something unusual has occured to cause the driver to fail. Please report this exception: Exception: java.sql.SQLException: FATAL:  user 'Bulldog' does not exist\n");
        stringBuffer.append("\n");
        stringBuffer.append("Stack Trace:\n");
        stringBuffer.append("\n");
        stringBuffer.append("java.sql.SQLException: FATAL:  user 'bulldog' does not exist\n");
        stringBuffer.append("at org.postgresql.Connection.openConnection(Connection.java:241)\n");
        stringBuffer.append("at org.postgresql.Driver.connect(Driver.java:122)\n");
        stringBuffer.append("at org.apache.commons.dbcp.DriverConnectionFactory.createConnection(ctionFactory.java:37)\n");
        stringBuffer.append("at org.apache.commons.dbcp.PoolableConnectionFactory.makeObject(PoolableConnectionFactory.java 90)\n");
        stringBuffer.append("at org.apache.commons.pool.impl.GenericObjectPool.borrowObject(GenericObjectPool.java 771)\n");
        stringBuffer.append("at org.apache.commons.dbcp.PoolingDataSource.getConnection(PoolingDataSource.java 5)\n");
        stringBuffer.append("at ise.dbconsole.DbConsoleDAO.getConnection(DbConsoleDAO.java:829)\n");
        stringBuffer.append("at ise.dbconsole.DbConsoleDAO.getDbInfo(DbConsoleDAO.java:152)\n");
        stringBuffer.append("at ise.dbconsole.command.DbInfoCommand.execute(DbInfoCommand.java:49\n");
        stringBuffer.append("at ise.dbconsole.command.DbInfoCommand.execute(DbInfoCommand.java:41\n");
        stringBuffer.append("at ise.dbconsole.command.SetupDAOCommand2.createDAO(SetupDAOCommand2.java:163)\n");
        stringBuffer.append("at ise.dbconsole.command.SetupDAOCommand2.setupDAO(SetupDAOCommand2.javaa:145)\n");
        stringBuffer.append("at ise.dbconsole.command.SetupDAOCommand2.execute(SetupDAOCommand2.java:69)\n");
        stringBuffer.append("at ise.dbconsole.command.SetupDAOCommand2.execute(SetupDAOCommand2.java:56)\n");
        stringBuffer.append("at ise.dbconsole.DbConsole.executeCommand(DbConsole.java:521)\n");
        stringBuffer.append("at ise.dbconsole.DbConsole$1.run(DbConsole.java:158)\n");
        stringBuffer.append("End of Stack Trace\n");
        System.out.println(MessageBox.box("Here's an exception:", stringBuffer.toString()));
    }
}

