/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ant;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.slf4j.LoggerFactory;
import org.sonar.ant.SonarTask;
import org.sonar.ant.Utils;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.Batch;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.bootstrapper.ProjectDefinition;
import org.sonar.batch.bootstrapper.Reactor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher {
    private SonarTask task;

    public Launcher(SonarTask task) {
        this.task = task;
    }

    public void execute() {
        ProjectDefinition project = this.defineProject();
        Reactor reactor = new Reactor(project);
        Configuration config = this.getInitialConfiguration(project);
        this.initLogging(config);
        Batch batch = new Batch(config, new Object[]{new EnvironmentInformation("Ant", Main.getAntVersion()), reactor});
        batch.execute();
    }

    ProjectDefinition defineProject() {
        Project antProject = this.task.getProject();
        Properties properties = new Properties();
        ProjectDefinition definition = new ProjectDefinition(this.task.getBaseDir(), this.task.getWorkDir(), properties);
        definition.addContainerExtension((Object)antProject);
        properties.setProperty("sonar.projectKey", this.task.getKey());
        properties.setProperty("sonar.projectVersion", this.task.getVersion());
        if (antProject.getName() != null) {
            properties.setProperty("sonar.projectName", antProject.getName());
        }
        if (antProject.getDescription() != null) {
            properties.setProperty("sonar.projectDescription", antProject.getDescription());
        }
        properties.putAll((Map<?, ?>)this.task.getProperties());
        properties.putAll((Map<?, ?>)antProject.getProperties());
        this.setPathProperties(properties, antProject);
        for (String dir : this.getPathAsList(this.task.createSources())) {
            definition.addSourceDir(dir);
        }
        for (String dir : this.getPathAsList(this.task.createTests())) {
            definition.addTestDir(dir);
        }
        for (String dir : this.getPathAsList(this.task.createBinaries())) {
            definition.addBinaryDir(dir);
        }
        for (String file : this.getPathAsList(this.task.createLibraries())) {
            definition.addLibrary(file);
        }
        this.defineModules(antProject, definition);
        return definition;
    }

    private ProjectDefinition defineProject(Project antProject) {
        File baseDir = antProject.getBaseDir();
        File workDir = new File(baseDir, ".sonar");
        Properties properties = new Properties();
        ProjectDefinition definition = new ProjectDefinition(baseDir, workDir, properties);
        definition.addContainerExtension((Object)antProject);
        if (antProject.getName() != null) {
            properties.setProperty("sonar.projectName", antProject.getName());
        }
        if (antProject.getDescription() != null) {
            properties.setProperty("sonar.projectDescription", antProject.getDescription());
        }
        properties.putAll((Map<?, ?>)antProject.getProperties());
        this.setPathProperties(properties, antProject);
        this.defineModules(antProject, definition);
        return definition;
    }

    private void setPathProperties(Properties properties, Project antProject) {
        this.setPathProperty(properties, antProject, "sonar.libraries");
    }

    private void setPathProperty(Properties properties, Project antProject, String refid) {
        if (antProject.getReference(refid) == null) {
            return;
        }
        Object reference = antProject.getReference(refid);
        properties.setProperty(refid, Utils.convertResourceCollectionToString((ResourceCollection)reference));
    }

    private void defineModules(Project antProject, ProjectDefinition definition) {
        String[] modules;
        for (String module : modules = StringUtils.split((String)definition.getProperties().getProperty("sonar.modules", ""), (char)',')) {
            File buildFile = new File(antProject.getBaseDir(), module);
            Project antSubProject = this.prepareSubProject(antProject, buildFile);
            definition.addModule(this.defineProject(antSubProject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Project prepareSubProject(Project antProject, File buildFile) {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this.task)).getClass().getClassLoader());
            Project antSubProject = antProject.createSubProject();
            ProjectHelper.configureProject((Project)antSubProject, (File)buildFile);
            antSubProject.init();
            if (StringUtils.isNotBlank((String)this.task.getInitTarget())) {
                Iterator iter = antProject.getBuildListeners().iterator();
                while (iter.hasNext()) {
                    antSubProject.addBuildListener((BuildListener)iter.next());
                }
                antSubProject.executeTarget(this.task.getInitTarget());
            }
            Project project = antSubProject;
            return project;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private List<String> getPathAsList(Path path) {
        ArrayList<String> result = new ArrayList<String>();
        for (Resource resource : path) {
            if (!(resource instanceof FileResource)) continue;
            File fileResource = ((FileResource)resource).getFile();
            result.add(fileResource.getAbsolutePath());
        }
        return result;
    }

    private void initLogging(Configuration config) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)context);
        context.reset();
        InputStream input = Batch.class.getResourceAsStream("/org/sonar/batch/logback.xml");
        String level = this.getLoggerLevel(config);
        System.setProperty("ROOT_LOGGER_LEVEL", level);
        try {
            jc.doConfigure(input);
        }
        catch (JoranException e) {
            throw new SonarException("Can not initialize logging", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    String getLoggerLevel(Configuration config) {
        if (config.getBoolean("sonar.verbose", false)) {
            return "DEBUG";
        }
        int antLoggerLevel = Utils.getAntLoggerLever(this.task.getProject());
        switch (antLoggerLevel) {
            case 3: {
                return "DEBUG";
            }
            case 4: {
                return "TRACE";
            }
        }
        return "INFO";
    }

    private Configuration getInitialConfiguration(ProjectDefinition project) {
        CompositeConfiguration configuration = new CompositeConfiguration();
        configuration.addConfiguration((Configuration)new SystemConfiguration());
        configuration.addConfiguration((Configuration)new EnvironmentConfiguration());
        configuration.addConfiguration((Configuration)new MapConfiguration((Map)project.getProperties()));
        return configuration;
    }
}

