/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.sonar.ant.Utils;
import org.sonar.batch.bootstrapper.BootstrapClassLoader;
import org.sonar.batch.bootstrapper.Bootstrapper;
import org.sonar.batch.bootstrapper.BootstrapperIOUtils;

public class SonarTask
extends Task {
    private static final String[] UNSUPPORTED_VERSIONS = new String[]{"1", "2.0", "2.1", "2.2", "2.3", "2.4", "2.5", "2.6", "2.7"};
    private static final String HOST_PROPERTY = "sonar.host.url";
    private File workDir;
    private File baseDir;
    private Properties properties = new Properties();
    private String key;
    private String version;
    private Path sources;
    private Path tests;
    private Path binaries;
    private Path libraries;
    private Bootstrapper bootstrapper;
    private String initTarget;

    public String getServerUrl() {
        String serverUrl = this.getProperties().getProperty(HOST_PROPERTY);
        if (serverUrl == null) {
            serverUrl = this.getProject().getProperty(HOST_PROPERTY);
        }
        if (serverUrl == null) {
            serverUrl = "http://localhost:9000";
        }
        return serverUrl;
    }

    public File getWorkDir() {
        if (this.workDir == null) {
            this.workDir = new File(this.getBaseDir(), ".sonar");
        }
        return this.workDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = this.getProject().getBaseDir();
        }
        return this.baseDir;
    }

    public void setInitTarget(String initTarget) {
        this.initTarget = initTarget;
    }

    public String getInitTarget() {
        return this.initTarget;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void addConfiguredProperty(Environment.Variable property) {
        this.properties.setProperty(property.getKey(), property.getValue());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Path createSources() {
        if (this.sources == null) {
            this.sources = new Path(this.getProject());
        }
        return this.sources;
    }

    public Path createTests() {
        if (this.tests == null) {
            this.tests = new Path(this.getProject());
        }
        return this.tests;
    }

    public Path createBinaries() {
        if (this.binaries == null) {
            this.binaries = new Path(this.getProject());
        }
        return this.binaries;
    }

    public Path createLibraries() {
        if (this.libraries == null) {
            this.libraries = new Path(this.getProject());
        }
        return this.libraries;
    }

    public void execute() {
        this.log(Main.getAntVersion());
        this.log("Sonar Ant Task version: " + SonarTask.getTaskVersion());
        this.log("Loaded from: " + Utils.getJarPath());
        this.log("Sonar work directory: " + this.getWorkDir().getAbsolutePath());
        this.log("Sonar server: " + this.getServerUrl());
        this.bootstrapper = new Bootstrapper("AntTask/" + SonarTask.getTaskVersion(), this.getServerUrl(), this.getWorkDir());
        this.checkSonarVersion();
        this.delegateExecution(this.createClassLoader());
    }

    private void delegateExecution(BootstrapClassLoader sonarClassLoader) {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(sonarClassLoader);
            Class<?> launcherClass = sonarClassLoader.findClass("org.sonar.ant.Launcher");
            Constructor<?> constructor = launcherClass.getConstructor(SonarTask.class);
            Object launcher = constructor.newInstance(new Object[]{this});
            Method method = launcherClass.getMethod("execute", new Class[0]);
            method.invoke(launcher, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new BuildException(e.getTargetException());
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    private BootstrapClassLoader createClassLoader() {
        return this.bootstrapper.createClassLoader(new URL[]{Utils.getJarPath()}, ((Object)((Object)this)).getClass().getClassLoader(), "org.apache.tools.ant", "org.sonar.ant");
    }

    private void checkSonarVersion() {
        String serverVersion = this.bootstrapper.getServerVersion();
        this.log("Sonar version: " + serverVersion);
        if (SonarTask.isVersionPriorTo2Dot8(serverVersion)) {
            throw new BuildException("Sonar " + serverVersion + " does not support Sonar Ant Task " + SonarTask.getTaskVersion() + ". Please upgrade Sonar to version 2.8 or more.");
        }
    }

    static boolean isVersionPriorTo2Dot8(String version) {
        for (String unsupportedVersion : UNSUPPORTED_VERSIONS) {
            if (!SonarTask.isVersion(version, unsupportedVersion)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVersion(String version, String prefix) {
        return version.startsWith(prefix + ".") || version.equals(prefix);
    }

    public static String getTaskVersion() {
        InputStream in = null;
        try {
            in = SonarTask.class.getResourceAsStream("/org/sonar/ant/version.txt");
            Properties props = new Properties();
            props.load(in);
            String string = props.getProperty("version");
            return string;
        }
        catch (IOException e) {
            throw new BuildException("Could not load the version information for Sonar Ant Task", (Throwable)e);
        }
        finally {
            BootstrapperIOUtils.closeQuietly(in);
        }
    }
}

