/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.URI;

class XMLContext {
    private final String base;
    private final String lang;
    private final URI uri;
    private XMLContext document;

    XMLContext(String string, String string2) throws MalformedURIException {
        this(null, string, string2);
        this.document = this;
    }

    private XMLContext(XMLContext xMLContext, String string, String string2) throws MalformedURIException {
        this(xMLContext, new URI(string), string, string2);
    }

    private XMLContext(XMLContext xMLContext, URI uRI, String string, String string2) {
        this.base = string != null ? string : "http://error.com/no-xml-base-specified";
        this.lang = string2;
        this.uri = uRI;
        this.document = xMLContext;
    }

    XMLContext withBase(String string) throws MalformedURIException {
        return new XMLContext(this.document, string, this.lang);
    }

    XMLContext revertToDocument() {
        return this.document.withLang(this.lang);
    }

    XMLContext withLang(String string) {
        return new XMLContext(this.document, this.uri, this.base, string);
    }

    String getLang() {
        return this.lang;
    }

    String getBase() {
        return this.base;
    }

    URI getURI() {
        return this.uri;
    }

    boolean isSameAsDocument() {
        return this == this.document || this.uri.equals(this.document.uri);
    }

    XMLContext getDocument() {
        return this.document;
    }
}

