/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.test.BaseTest;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Assert;

class ErrorTest
extends BaseTest {
    private int[] expected;
    private int errorCnt = 0;

    public ErrorTest(String string, InputStream inputStream) {
        super(string, inputStream);
    }

    public ErrorTest(String string, InputStream inputStream, int n) {
        super(string, inputStream);
        this.setExpected(new int[]{n});
    }

    void setExpected(int n) {
        this.setExpected(new int[]{n});
    }

    void setExpected(int[] nArray) {
        this.expected = nArray;
    }

    protected void runTest() {
        try {
            this.loadRDF();
        }
        catch (RDFException rDFException) {
            if (rDFException.getErrorCode() != 10 || rDFException.toString().indexOf("SAXException") == -1) {
                Assert.fail((String)rDFException.getMessage());
            }
        }
        catch (IOException iOException) {
            Assert.fail((String)iOException.getMessage());
        }
        if (this.expected != null) {
            int n = 0;
            while (n < this.expected.length) {
                if (this.expected[n] != -1) {
                    Assert.fail((String)("Expected error number " + this.expected[n] + ", was not detected."));
                }
                ++n;
            }
        } else if (this.errorCnt == 0) {
            Assert.fail((String)"Did not detect errors in bad input file");
        }
    }

    void onError(int n) {
        ++this.errorCnt;
        if (this.expected != null) {
            int n2 = 0;
            while (n2 < this.expected.length) {
                if (this.expected[n2] == n) {
                    this.expected[n2] = -1;
                    return;
                }
                ++n2;
            }
            super.onError(n);
        }
    }
}

