/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public abstract class DynamicMethod {
    protected RubyModule implementationClass;
    protected RubyModule protectedClass;
    protected Visibility visibility;
    protected CallConfiguration callConfig;
    protected long serialNumber;
    protected boolean builtin = false;
    protected NativeCall nativeCall;
    protected String name;
    protected boolean notImplemented = false;

    protected DynamicMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
        assert (implementationClass != null);
        this.init(implementationClass, visibility, callConfig);
    }

    protected DynamicMethod(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig, String name2) {
        this(implementationClass, visibility, callConfig);
        this.name = name2;
    }

    protected DynamicMethod() {
    }

    protected void init(RubyModule implementationClass, Visibility visibility, CallConfiguration callConfig) {
        this.visibility = visibility;
        this.implementationClass = implementationClass;
        this.protectedClass = DynamicMethod.calculateProtectedClass(implementationClass);
        this.callConfig = callConfig;
        this.serialNumber = implementationClass.getRuntime().getNextDynamicMethodSerial();
    }

    public long getSerialNumber() {
        return this.serialNumber;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public void setIsBuiltin(boolean isBuiltin) {
        this.builtin = isBuiltin;
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, RubyModule var3, String var4, IRubyObject[] var5, Block var6);

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
        return this.call(context, self, clazz, name2, args2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2) {
        return this.call(context, self, klazz, name2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, Block block) {
        return this.call(context, self, klazz, name2, IRubyObject.NULL_ARRAY, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0) {
        return this.call(context, self, klazz, name2, arg0, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, Block block) {
        return this.call(context, self, klazz, name2, new IRubyObject[]{arg0}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        return this.call(context, self, klazz, name2, arg0, arg1, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.call(context, self, klazz, name2, new IRubyObject[]{arg0, arg1}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.call(context, self, klazz, name2, arg0, arg1, arg2, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.call(context, self, klazz, name2, new IRubyObject[]{arg0, arg1, arg2}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return this.call(context, self, klazz, name2, arg0, arg1, arg2, arg3, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
        return this.call(context, self, klazz, name2, new IRubyObject[]{arg0, arg1, arg2, arg3}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4) {
        return this.call(context, self, klazz, name2, arg0, arg1, arg2, arg3, arg4, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, Block block) {
        return this.call(context, self, klazz, name2, new IRubyObject[]{arg0, arg1, arg2, arg3, arg4}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5) {
        return this.call(context, self, klazz, name2, arg0, arg1, arg2, arg3, arg4, arg5, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, Block block) {
        return this.call(context, self, klazz, name2, new IRubyObject[]{arg0, arg1, arg2, arg3, arg4, arg5}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6) {
        return this.call(context, self, klazz, name2, arg0, arg1, arg2, arg3, arg4, arg5, arg6, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, Block block) {
        return this.call(context, self, klazz, name2, new IRubyObject[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7) {
        return this.call(context, self, klazz, name2, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, Block block) {
        return this.call(context, self, klazz, name2, new IRubyObject[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8) {
        return this.call(context, self, klazz, name2, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, Block block) {
        return this.call(context, self, klazz, name2, new IRubyObject[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8}, block);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, IRubyObject arg9) {
        return this.call(context, self, klazz, name2, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, Block.NULL_BLOCK);
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5, IRubyObject arg6, IRubyObject arg7, IRubyObject arg8, IRubyObject arg9, Block block) {
        return this.call(context, self, klazz, name2, new IRubyObject[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9}, block);
    }

    public abstract DynamicMethod dup();

    public boolean isCallableFrom(IRubyObject caller2, CallType callType) {
        switch (this.visibility) {
            case PUBLIC: {
                return true;
            }
            case PRIVATE: {
                return callType != CallType.NORMAL;
            }
            case PROTECTED: {
                return this.protectedAccessOk(caller2);
            }
        }
        return true;
    }

    private boolean protectedAccessOk(IRubyObject caller2) {
        return this.getProtectedClass().isInstance(caller2);
    }

    protected static RubyModule calculateProtectedClass(RubyModule cls) {
        if (cls.isSingleton()) {
            cls = cls.getSuperClass();
        }
        while (cls.isIncluded()) {
            cls = cls.getMetaClass();
        }
        if (cls instanceof MetaClass) {
            cls = ((MetaClass)cls).getRealClass();
        }
        return cls;
    }

    protected RubyModule getProtectedClass() {
        return this.protectedClass;
    }

    public RubyModule getImplementationClass() {
        return this.implementationClass;
    }

    public void setImplementationClass(RubyModule implClass) {
        this.implementationClass = implClass;
        this.protectedClass = DynamicMethod.calculateProtectedClass(implClass);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public final boolean isUndefined() {
        return this == UndefinedMethod.INSTANCE;
    }

    public Arity getArity() {
        return Arity.optional();
    }

    public DynamicMethod getRealMethod() {
        return this;
    }

    public CallConfiguration getCallConfig() {
        return this.callConfig;
    }

    public void setCallConfig(CallConfiguration callConfig) {
        this.callConfig = callConfig;
    }

    public void setNativeCall(Class nativeTarget, String nativeName, Class nativeReturn, Class[] nativeSignature, boolean statik) {
        this.nativeCall = new NativeCall(nativeTarget, nativeName, nativeReturn, nativeSignature, statik);
    }

    public NativeCall getNativeCall() {
        return this.nativeCall;
    }

    public boolean isNative() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public boolean isNotImplemented() {
        return this.notImplemented;
    }

    public void setNotImplemented(boolean setNotImplemented) {
        this.notImplemented = setNotImplemented;
    }

    protected IRubyObject handleRedo(Ruby runtime2) throws RaiseException {
        throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.REDO, runtime2.getNil(), "unexpected redo");
    }

    protected IRubyObject handleReturn(ThreadContext context, JumpException.ReturnJump rj, int callNumber) {
        if (rj.getTarget() == callNumber) {
            return (IRubyObject)rj.getValue();
        }
        throw rj;
    }

    protected IRubyObject handleBreak(ThreadContext context, Ruby runtime2, JumpException.BreakJump bj, int callNumber) {
        if (bj.getTarget() == callNumber) {
            throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, runtime2.getNil(), "unexpected break");
        }
        throw bj;
    }

    public static class NativeCall {
        private final Class nativeTarget;
        private final String nativeName;
        private final Class nativeReturn;
        private final Class[] nativeSignature;
        private final boolean statik;

        public NativeCall(Class nativeTarget, String nativeName, Class nativeReturn, Class[] nativeSignature, boolean statik) {
            this.nativeTarget = nativeTarget;
            this.nativeName = nativeName;
            this.nativeReturn = nativeReturn;
            this.nativeSignature = nativeSignature;
            this.statik = statik;
        }

        public Class getNativeTarget() {
            return this.nativeTarget;
        }

        public String getNativeName() {
            return this.nativeName;
        }

        public Class getNativeReturn() {
            return this.nativeReturn;
        }

        public Class[] getNativeSignature() {
            return this.nativeSignature;
        }

        public boolean isStatic() {
            return this.statik;
        }

        public String toString() {
            return "" + (this.statik ? "static " : "") + this.nativeReturn.getName() + " " + this.nativeTarget.getName() + "." + this.nativeName + CodegenUtils.prettyParams(this.nativeSignature);
        }
    }
}

