/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin;

import com.caucho.config.ConfigException;
import com.caucho.config.Service;
import com.caucho.config.types.RawString;
import com.caucho.env.deploy.DeployMode;
import com.caucho.server.cluster.Server;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.host.HostConfig;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

@Service
public class RemoteAdminService {
    private static final Logger log = Logger.getLogger(RemoteAdminService.class.getName());
    private static final L10N L = new L10N(RemoteAdminService.class);
    private String _hostName = "admin.resin";
    private Server _server;
    private boolean _isAuthenticationRequired = true;
    private WebApp _webApp;

    public void setAuthenticationRequired(boolean isAuthenticationRequired) {
        this._isAuthenticationRequired = isAuthenticationRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws Exception {
        this._server = Server.getCurrent();
        if (this._server == null) {
            throw new ConfigException(L.l("<admin:{0}> may only be instantiated in an active server", this.getClass().getSimpleName()));
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            HostConfig hostConfig = new HostConfig();
            hostConfig.setHostName(new RawString(this._hostName));
            hostConfig.setRootDirectory(new RawString("memory:/error/" + this._hostName));
            hostConfig.setSkipDefaultConfig(true);
            hostConfig.setRedeployMode(DeployMode.MANUAL);
            WebAppConfig webAppConfig = new WebAppConfig();
            webAppConfig.setId("/");
            webAppConfig.setRootDirectory(new RawString("memory:/error/ROOT"));
            webAppConfig.setSkipDefaultConfig(true);
            webAppConfig.setRedeployMode(DeployMode.MANUAL);
            hostConfig.addPropertyProgram("web-app", webAppConfig);
            ServletMapping mapping = new ServletMapping();
            mapping.addURLPattern("/hmtp");
            mapping.setServletClass("com.caucho.remote.HmtpServlet");
            mapping.setInitParam("authentication-required", String.valueOf(this._isAuthenticationRequired));
            mapping.setInitParam("admin", "true");
            mapping.init();
            webAppConfig.addPropertyProgram("servlet-mapping", mapping);
            this._server.addHost(hostConfig);
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " enabled at http://" + this._hostName + "/hmtp");
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public WebApp getWebApp() {
        return this._webApp;
    }

    public String toString() {
        if (this._server != null) {
            return this.getClass().getSimpleName() + "[" + this._server.getServerId() + "]";
        }
        return this.getClass().getSimpleName() + "[" + null + "]";
    }
}

