/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.BaseConfigIntrospector;
import com.caucho.amber.cfg.EntityIntrospector;
import com.caucho.amber.cfg.TypeConfig;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.BeanType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

public class AmberConfigManager {
    private static final L10N L = new L10N(AmberConfigManager.class);
    private static final Logger log = Logger.getLogger(AmberConfigManager.class.getName());
    private final AmberPersistenceUnit _persistenceUnit;
    HashMap<String, TypeConfig> _typeMap = new HashMap();
    private ArrayList<BaseConfigIntrospector> _pendingIntrospectorList = new ArrayList();

    public AmberConfigManager(AmberPersistenceUnit persistenceUnit) {
        this._persistenceUnit = persistenceUnit;
    }

    AmberPersistenceUnit getPersistenceUnit() {
        return this._persistenceUnit;
    }

    public BeanType introspect(Class type) {
        TypeConfig typeConfig = this._typeMap.get(type.getName());
        if (typeConfig != null) {
            return typeConfig.getType();
        }
        try {
            EntityIntrospector introspector = new EntityIntrospector(this);
            return introspector.introspect(type);
        }
        catch (SQLException e) {
            throw ConfigException.create(e);
        }
    }

    public void configure() {
        ArrayList<BaseConfigIntrospector> introspectorList = new ArrayList<BaseConfigIntrospector>(this._pendingIntrospectorList);
        this._pendingIntrospectorList.clear();
        for (BaseConfigIntrospector introspector : introspectorList) {
            introspector.configureLinks();
        }
        for (BaseConfigIntrospector introspector : introspectorList) {
            introspector.configureDependencies();
        }
    }

    void addType(Class type, TypeConfig typeConfig) {
        this._typeMap.put(type.getName(), typeConfig);
        if (typeConfig.getIntrospector() != null) {
            this._pendingIntrospectorList.add(typeConfig.getIntrospector());
        }
    }
}

